/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.internal.helper;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.metrics.helper.Tag;
import com.ibm.ws.microprofile.metrics23.helper.PrometheusBuilder23;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.internal.helper.Util30;
import java.time.Duration;
import java.util.Map;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Counting;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metered;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Sampling;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Timer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PrometheusBuilder30
extends PrometheusBuilder23 {
    private static final TraceComponent tc = Tr.register(PrometheusBuilder30.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    static final long serialVersionUID = -3026419232673421028L;

    protected static String resolveTagsAsStringWithGlobalTags(MetricID mid) {
        org.eclipse.microprofile.metrics.Tag[] globalTags = Util30.getCachedGlobalTags();
        if (globalTags != null && globalTags.length != 0) {
            org.eclipse.microprofile.metrics.Tag[] applicationTags = mid.getTagsAsArray();
            org.eclipse.microprofile.metrics.Tag[] combinedTags = new org.eclipse.microprofile.metrics.Tag[globalTags.length + applicationTags.length];
            System.arraycopy(globalTags, 0, combinedTags, 0, globalTags.length);
            System.arraycopy(applicationTags, 0, combinedTags, globalTags.length, applicationTags.length);
            MetricID temp = new MetricID("temporary", combinedTags);
            return temp.getTagsAsString();
        }
        return mid.getTagsAsString();
    }

    public static void buildTimer30(StringBuilder builder, String name, String description, Map<MetricID, Metric> currentMetricMap) {
        PrometheusBuilder30.buildMetered30(builder, name, description, currentMetricMap);
        double conversionFactor = 1.0E-9;
        PrometheusBuilder30.buildSampling30(builder, name, description, currentMetricMap, conversionFactor, "_seconds");
    }

    public static void buildSimpleTimer30(StringBuilder builder, String name, String description, Map<MetricID, Metric> currentMetricMap) {
        SimpleTimer simpleTimer;
        double conversionFactor = 1.0E-9;
        PrometheusBuilder30.buildCounting30(builder, name, description, currentMetricMap);
        String lineName = name + "_elapsedTime_" + "seconds".toString();
        PrometheusBuilder30.getPromTypeLine(builder, lineName, "gauge");
        for (MetricID mid : currentMetricMap.keySet()) {
            simpleTimer = (SimpleTimer)currentMetricMap.get(mid);
            PrometheusBuilder30.getPromValueLine(builder, lineName, (double)simpleTimer.getElapsedTime().toNanos() * conversionFactor, PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid));
        }
        lineName = name + "_maxTimeDuration_" + "seconds".toString();
        PrometheusBuilder30.getPromTypeLine(builder, lineName, "gauge");
        for (MetricID mid : currentMetricMap.keySet()) {
            simpleTimer = (SimpleTimer)currentMetricMap.get(mid);
            Duration maxTime = simpleTimer.getMaxTimeDuration();
            Double maxValue = maxTime != null ? (double)maxTime.toNanos() * conversionFactor : Double.NaN;
            PrometheusBuilder30.getPromValueLine(builder, lineName, maxValue, PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid));
        }
        lineName = name + "_minTimeDuration_" + "seconds".toString();
        PrometheusBuilder30.getPromTypeLine(builder, lineName, "gauge");
        for (MetricID mid : currentMetricMap.keySet()) {
            simpleTimer = (SimpleTimer)currentMetricMap.get(mid);
            Duration minTime = simpleTimer.getMinTimeDuration();
            Double minValue = minTime != null ? (double)minTime.toNanos() * conversionFactor : Double.NaN;
            PrometheusBuilder30.getPromValueLine(builder, lineName, minValue, PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid));
        }
    }

    public static void buildGauge30(StringBuilder builder, String name, String description, Map<MetricID, Metric> currentMetricMap, Double conversionFactor, String appendUnit) {
        PrometheusBuilder30.getPromTypeLine(builder, name, "gauge", appendUnit);
        PrometheusBuilder30.getPromHelpLine(builder, name, description, appendUnit);
        for (MetricID mid : currentMetricMap.keySet()) {
            Number gaugeValNumber = null;
            Object gaugeValue = null;
            try {
                gaugeValue = ((Gauge)currentMetricMap.get(mid)).getValue();
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, (String)"io.openliberty.microprofile.metrics30.internal.helper.PrometheusBuilder30", (String)"134", null, (Object[])new Object[]{builder, name, description, currentMetricMap, conversionFactor, appendUnit});
                return;
            }
            if (!Number.class.isInstance(gaugeValue)) {
                if (!improperGaugeSet.contains(mid)) {
                    Tr.event((TraceComponent)tc, (String)("Skipping Prometheus output for Gauge: " + mid.toString() + " of type " + ((Gauge)currentMetricMap.get(mid)).getValue().getClass()), (Object[])new Object[0]);
                    improperGaugeSet.add(mid);
                }
                return;
            }
            gaugeValNumber = (Number)gaugeValue;
            if (!Double.isNaN(conversionFactor)) {
                gaugeValNumber = gaugeValNumber.doubleValue() * conversionFactor;
            }
            PrometheusBuilder30.getPromValueLine(builder, name, gaugeValNumber, PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid), appendUnit);
        }
    }

    public static void buildCounter30(StringBuilder builder, String name, String description, Map<MetricID, Metric> currentMetricMap) {
        String lineName = PrometheusBuilder30.appendSuffixIfNeeded(PrometheusBuilder30.getPrometheusMetricName(name), "total");
        PrometheusBuilder30.getPromTypeLine(builder, lineName, "counter");
        PrometheusBuilder30.getPromHelpLine(builder, lineName, description);
        for (MetricID mid : currentMetricMap.keySet()) {
            PrometheusBuilder30.getPromValueLine(builder, lineName, ((Counter)currentMetricMap.get(mid)).getCount(), PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid));
        }
    }

    public static void buildConcurrentGauge30(StringBuilder builder, String name, String description, Map<MetricID, Metric> currentMetricMap) {
        String lineName = name + "_current";
        PrometheusBuilder30.getPromTypeLine(builder, lineName, "gauge");
        PrometheusBuilder30.getPromHelpLine(builder, lineName, description);
        for (MetricID mid : currentMetricMap.keySet()) {
            PrometheusBuilder30.getPromValueLine(builder, lineName, ((ConcurrentGauge)currentMetricMap.get(mid)).getCount(), PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid));
        }
        lineName = name + "_min";
        PrometheusBuilder30.getPromTypeLine(builder, lineName, "gauge");
        for (MetricID mid : currentMetricMap.keySet()) {
            PrometheusBuilder30.getPromValueLine(builder, lineName, ((ConcurrentGauge)currentMetricMap.get(mid)).getMin(), PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid));
        }
        lineName = name + "_max";
        PrometheusBuilder30.getPromTypeLine(builder, lineName, "gauge");
        for (MetricID mid : currentMetricMap.keySet()) {
            PrometheusBuilder30.getPromValueLine(builder, lineName, ((ConcurrentGauge)currentMetricMap.get(mid)).getMax(), PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid));
        }
    }

    public static void buildHistogram30(StringBuilder builder, String name, String description, Map<MetricID, Metric> currentMetricMap, Double conversionFactor, String appendUnit) {
        PrometheusBuilder30.buildSampling30(builder, name, description, currentMetricMap, conversionFactor, appendUnit);
    }

    public static void buildMeter30(StringBuilder builder, String name, String description, Map<MetricID, Metric> currentMetricMap) {
        PrometheusBuilder30.buildCounting30(builder, name, description, currentMetricMap);
        PrometheusBuilder30.buildMetered30(builder, name, description, currentMetricMap);
    }

    protected static void buildSampling30(StringBuilder builder, String name, String description, Map<MetricID, Metric> currentMetricMap, Double conversionFactor, String appendUnit) {
        Sampling sampling;
        String lineName = name + "_mean";
        PrometheusBuilder30.getPromTypeLine(builder, lineName, "gauge", appendUnit);
        for (MetricID mid : currentMetricMap.keySet()) {
            sampling = (Sampling)currentMetricMap.get(mid);
            double meanVal = !Double.isNaN(conversionFactor) ? sampling.getSnapshot().getMean() * conversionFactor : sampling.getSnapshot().getMean();
            PrometheusBuilder30.getPromValueLine(builder, lineName, meanVal, PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid), appendUnit);
        }
        lineName = name + "_max";
        PrometheusBuilder30.getPromTypeLine(builder, lineName, "gauge", appendUnit);
        for (MetricID mid : currentMetricMap.keySet()) {
            sampling = (Sampling)currentMetricMap.get(mid);
            double maxVal = !Double.isNaN(conversionFactor) ? (double)sampling.getSnapshot().getMax() * conversionFactor : (double)sampling.getSnapshot().getMax();
            PrometheusBuilder30.getPromValueLine(builder, lineName, maxVal, PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid), appendUnit);
        }
        lineName = name + "_min";
        PrometheusBuilder30.getPromTypeLine(builder, lineName, "gauge", appendUnit);
        for (MetricID mid : currentMetricMap.keySet()) {
            sampling = (Sampling)currentMetricMap.get(mid);
            double minVal = !Double.isNaN(conversionFactor) ? (double)sampling.getSnapshot().getMin() * conversionFactor : (double)sampling.getSnapshot().getMin();
            PrometheusBuilder30.getPromValueLine(builder, lineName, minVal, PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid), appendUnit);
        }
        lineName = name + "_stddev";
        PrometheusBuilder30.getPromTypeLine(builder, lineName, "gauge", appendUnit);
        for (MetricID mid : currentMetricMap.keySet()) {
            sampling = (Sampling)currentMetricMap.get(mid);
            double stdDevVal = !Double.isNaN(conversionFactor) ? sampling.getSnapshot().getStdDev() * conversionFactor : sampling.getSnapshot().getStdDev();
            PrometheusBuilder30.getPromValueLine(builder, lineName, stdDevVal, PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid), appendUnit);
        }
        PrometheusBuilder30.getPromTypeLine(builder, name, "summary", appendUnit);
        PrometheusBuilder30.getPromHelpLine(builder, name, description, appendUnit);
        for (MetricID mid : currentMetricMap.keySet()) {
            sampling = (Sampling)currentMetricMap.get(mid);
            if (Counting.class.isInstance(sampling)) {
                PrometheusBuilder30.getPromValueLine(builder, name, ((Counting)sampling).getCount(), PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid), appendUnit == null ? "_count" : appendUnit + "_count");
            }
            if (Timer.class.isInstance(sampling)) {
                PrometheusBuilder30.getPromValueLine(builder, name, (double)((Timer)sampling).getElapsedTime().toNanos() * conversionFactor, PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid), appendUnit == null ? "_sum" : appendUnit + "_sum");
            } else if (Histogram.class.isInstance(sampling)) {
                PrometheusBuilder30.getPromValueLine(builder, name, ((Histogram)sampling).getSum(), PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid), appendUnit == null ? "_sum" : appendUnit + "_sum");
            }
            double medianVal = !Double.isNaN(conversionFactor) ? sampling.getSnapshot().getMedian() * conversionFactor : sampling.getSnapshot().getMedian();
            double percentile75th = !Double.isNaN(conversionFactor) ? sampling.getSnapshot().get75thPercentile() * conversionFactor : sampling.getSnapshot().get75thPercentile();
            double percentile95th = !Double.isNaN(conversionFactor) ? sampling.getSnapshot().get95thPercentile() * conversionFactor : sampling.getSnapshot().get95thPercentile();
            double percentile98th = !Double.isNaN(conversionFactor) ? sampling.getSnapshot().get98thPercentile() * conversionFactor : sampling.getSnapshot().get98thPercentile();
            double percentile99th = !Double.isNaN(conversionFactor) ? sampling.getSnapshot().get99thPercentile() * conversionFactor : sampling.getSnapshot().get99thPercentile();
            double percentile999th = !Double.isNaN(conversionFactor) ? sampling.getSnapshot().get999thPercentile() * conversionFactor : sampling.getSnapshot().get999thPercentile();
            PrometheusBuilder30.getPromValueLine(builder, name, medianVal, PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid), new Tag("quantile", "0.5"), appendUnit);
            PrometheusBuilder30.getPromValueLine(builder, name, percentile75th, PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid), new Tag("quantile", "0.75"), appendUnit);
            PrometheusBuilder30.getPromValueLine(builder, name, percentile95th, PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid), new Tag("quantile", "0.95"), appendUnit);
            PrometheusBuilder30.getPromValueLine(builder, name, percentile98th, PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid), new Tag("quantile", "0.98"), appendUnit);
            PrometheusBuilder30.getPromValueLine(builder, name, percentile99th, PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid), new Tag("quantile", "0.99"), appendUnit);
            PrometheusBuilder30.getPromValueLine(builder, name, percentile999th, PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid), new Tag("quantile", "0.999"), appendUnit);
        }
    }

    protected static void buildCounting30(StringBuilder builder, String name, String description, Map<MetricID, Metric> currentMetricMap) {
        String lineName = name + "_total";
        PrometheusBuilder30.getPromTypeLine(builder, lineName, "counter");
        PrometheusBuilder30.getPromHelpLine(builder, lineName, description);
        for (MetricID mid : currentMetricMap.keySet()) {
            PrometheusBuilder30.getPromValueLine(builder, lineName, ((Counting)currentMetricMap.get(mid)).getCount(), PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid));
        }
    }

    protected static void buildMetered30(StringBuilder builder, String name, String description, Map<MetricID, Metric> map) {
        String lineName = name + "_rate_" + "per_second".toString();
        PrometheusBuilder30.getPromTypeLine(builder, lineName, "gauge");
        for (MetricID mid : map.keySet()) {
            PrometheusBuilder30.getPromValueLine(builder, lineName, ((Metered)map.get(mid)).getMeanRate(), PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid));
        }
        lineName = name + "_one_min_rate_" + "per_second".toString();
        PrometheusBuilder30.getPromTypeLine(builder, lineName, "gauge");
        for (MetricID mid : map.keySet()) {
            PrometheusBuilder30.getPromValueLine(builder, lineName, ((Metered)map.get(mid)).getOneMinuteRate(), PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid));
        }
        lineName = name + "_five_min_rate_" + "per_second".toString();
        PrometheusBuilder30.getPromTypeLine(builder, lineName, "gauge");
        for (MetricID mid : map.keySet()) {
            PrometheusBuilder30.getPromValueLine(builder, lineName, ((Metered)map.get(mid)).getFiveMinuteRate(), PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid));
        }
        lineName = name + "_fifteen_min_rate_" + "per_second".toString();
        PrometheusBuilder30.getPromTypeLine(builder, lineName, "gauge");
        for (MetricID mid : map.keySet()) {
            PrometheusBuilder30.getPromValueLine(builder, lineName, ((Metered)map.get(mid)).getFifteenMinuteRate(), PrometheusBuilder30.resolveTagsAsStringWithGlobalTags(mid));
        }
    }
}

