/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transaction.services;

import com.ibm.tx.jta.embeddable.impl.EmbeddableTransactionImpl;
import com.ibm.tx.jta.embeddable.impl.WSATRecoveryCoordinator;
import com.ibm.tx.jta.impl.LocalTIDTable;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.ltc.impl.LocalTranCurrentSet;
import com.ibm.tx.remote.DistributableTransaction;
import com.ibm.tx.remote.RemoteTransactionController;
import com.ibm.tx.remote.TransactionWrapper;
import com.ibm.tx.remote.Vote;
import com.ibm.tx.util.TMHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.JTA.HeuristicHazardException;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.transaction.HeuristicCommitException;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.io.Serializable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RemoteTransactionController.class})
public class RemoteTransactionControllerService
implements RemoteTransactionController {
    private static final TraceComponent tc = Tr.register(RemoteTransactionControllerService.class, (String)"transaction", (String)"com.ibm.ws.transaction.services.TransactionMessages");
    private final ThreadLocal<LocalTransactionCoordinator> _suspendedLTC = new ThreadLocal();
    private final ThreadLocal<DistributableTransaction> _threadImportedTran = new ThreadLocal();
    private UOWCurrent _uowc;
    private TransactionManager _tm;
    static final long serialVersionUID = 9029274695552536524L;

    @Reference
    protected void setUOWCurrent(UOWCurrent uowc) {
        this._uowc = uowc;
    }

    @Reference
    protected void setTransactionManager(TransactionManager tm) {
        this._tm = tm;
    }

    /*
     * WARNING - void declaration
     */
    public boolean importTransaction(String globalId, int expires) throws SystemException {
        DistributableTransaction tx;
        try {
            TMHelper.checkTMState();
        }
        catch (NotSupportedException notSupportedException) {
            void e;
            FFDCFilter.processException((Throwable)notSupportedException, (String)"com.ibm.ws.transaction.services.RemoteTransactionControllerService", (String)"81", (Object)this, (Object[])new Object[]{globalId, expires});
            SystemException se = new SystemException();
            se.initCause((Throwable)e);
            throw se;
        }
        UOWCoordinator uowCoord = this._uowc.getUOWCoord();
        if (uowCoord != null && uowCoord.isGlobal()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The Web Service request is a local invocation", (Object[])new Object[0]);
            }
            ((DistributableTransaction)uowCoord).resumeAssociation();
            return false;
        }
        LocalTransactionCoordinator ltc = LocalTranCurrentSet.instance().suspend();
        this._suspendedLTC.set(ltc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Suspended LTC", (Object[])new Object[]{ltc});
        }
        if ((tx = this.getTransactionForID(globalId)) != null) {
            try {
                this._tm.resume((Transaction)tx);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transaction.services.RemoteTransactionControllerService", (String)"111", (Object)this, (Object[])new Object[]{globalId, expires});
                SystemException se = new SystemException();
                se.initCause((Throwable)e);
                throw se;
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The Web Service request is a remote invocation", (Object[])new Object[0]);
        }
        tx = new EmbeddableTransactionImpl(expires, globalId);
        this._threadImportedTran.set(tx);
        tx.addAssociation();
        new TransactionWrapper((EmbeddableTransactionImpl)tx);
        try {
            this._tm.resume((Transaction)tx);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.transaction.services.RemoteTransactionControllerService", (String)"131", (Object)this, (Object[])new Object[]{globalId, expires});
            SystemException se = new SystemException();
            se.initCause((Throwable)e);
            throw se;
        }
        return true;
    }

    public void unimportTransaction(String globalId) throws SystemException {
        LocalTransactionCoordinator ltc;
        DistributableTransaction tx = this.getTransactionForID(globalId);
        if (tx != null) {
            if (!globalId.equals(tx.getGlobalId())) {
                SystemException e = new SystemException();
                throw e;
            }
            Transaction suspendedTx = this._tm.suspend();
            if (suspendedTx != null && !tx.equals(suspendedTx)) {
                SystemException e = new SystemException();
                throw e;
            }
        }
        this._threadImportedTran.set(null);
        if (tx != null) {
            tx.removeAssociation();
        }
        if ((ltc = this._suspendedLTC.get()) != null) {
            LocalTranCurrentSet.instance().resume(ltc);
        }
        this._suspendedLTC.set(null);
    }

    public String exportTransaction() throws SystemException {
        UOWCoordinator uowCoord = this._uowc.getUOWCoord();
        if (uowCoord == null || !uowCoord.isGlobal()) {
            throw new SystemException("No global transaction");
        }
        this._tm.suspend();
        return ((DistributableTransaction)uowCoord).getGlobalId();
    }

    /*
     * WARNING - void declaration
     */
    public void unexportTransaction(String globalId) throws SystemException {
        DistributableTransaction tx = this.getTransactionForID(globalId);
        try {
            this._tm.resume((Transaction)tx);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transaction.services.RemoteTransactionControllerService", (String)"215", (Object)this, (Object[])new Object[]{globalId});
            SystemException se = new SystemException();
            se.initCause((Throwable)e);
            throw se;
        }
    }

    public boolean registerRemoteParticipant(String xaResFactoryFilter, Serializable xaResInfo, String globalId) throws SystemException {
        boolean retval = true;
        DistributableTransaction tx = this.getTransactionForID(globalId);
        if (tx != null) {
            switch (tx.getStatus()) {
                case 0: 
                case 1: {
                    tx.enlistAsyncResource(xaResFactoryFilter, xaResInfo, tx.getXid());
                    break;
                }
                case 7: {
                    tx.setRollbackOnly();
                }
                default: {
                    retval = false;
                    break;
                }
            }
        } else {
            retval = false;
        }
        return retval;
    }

    private DistributableTransaction getTransactionForID(String globalId) {
        for (TransactionImpl tx : LocalTIDTable.getAllTransactions()) {
            if (!globalId.equals(((DistributableTransaction)tx).getGlobalId())) continue;
            return (DistributableTransaction)tx;
        }
        return null;
    }

    public boolean registerRecoveryCoordinator(String recoveryCoordinatorFactoryFilter, Serializable recoveryCoordinatorInfo, String globalId) throws SystemException {
        DistributableTransaction tx = this.getTransactionForID(globalId);
        WSATRecoveryCoordinator rc = new WSATRecoveryCoordinator(recoveryCoordinatorFactoryFilter, recoveryCoordinatorInfo, globalId);
        tx.setWSATRecoveryCoordinator(rc);
        return true;
    }

    public Vote prepare(String globalId) throws SystemException, HeuristicHazardException, HeuristicMixedException, RollbackException {
        TransactionWrapper t = TransactionWrapper.getTransactionWrapper((String)globalId);
        if (t != null) {
            return t.prepare();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("No matching TransactionWrapper: " + globalId), (Object[])new Object[0]);
        }
        throw new SystemException();
    }

    public void commit(String globalId) throws SystemException, HeuristicHazardException, HeuristicRollbackException, HeuristicMixedException {
        TransactionWrapper t = TransactionWrapper.getTransactionWrapper((String)globalId);
        if (t != null) {
            t.commit();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("No matching TransactionWrapper: " + globalId), (Object[])new Object[0]);
        }
    }

    public void rollback(String globalId) throws HeuristicHazardException, HeuristicCommitException, HeuristicMixedException, SystemException {
        TransactionWrapper t = TransactionWrapper.getTransactionWrapper((String)globalId);
        if (t == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No matching TransactionWrapper: " + globalId), (Object[])new Object[0]);
            }
            throw new SystemException();
        }
        t.rollback();
    }

    public void setRollbackOnly(String globalId) throws SystemException {
        DistributableTransaction tx = this.getTransactionForID(globalId);
        if (tx != null) {
            tx.setRollbackOnly();
        }
    }

    public boolean replayCompletion(String globalId) {
        DistributableTransaction tx = this.getTransactionForID(globalId);
        if (tx != null) {
            tx.replayCompletion();
            return true;
        }
        return false;
    }

    public String getGlobalId() throws SystemException {
        UOWCoordinator uowCoord = this._uowc.getUOWCoord();
        if (uowCoord == null || !uowCoord.isGlobal()) {
            throw new SystemException("No global transaction");
        }
        return ((DistributableTransaction)uowCoord).getGlobalId();
    }

    public Object getResource(String globalId) {
        TransactionWrapper tw = TransactionWrapper.getTransactionWrapper((String)globalId);
        if (tw != null) {
            EmbeddableTransactionImpl tx = tw.getTransaction();
            if (tx != null) {
                return tx.getResource((Object)globalId);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No matching Transaction", (Object[])new Object[0]);
            }
        } else {
            DistributableTransaction tx;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No matching TransactionWrapper", (Object[])new Object[0]);
            }
            if ((tx = this.getTransactionForID(globalId)) instanceof EmbeddableTransactionImpl) {
                return ((EmbeddableTransactionImpl)tx).getResource((Object)globalId);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No matching DistributableTransaction", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public void putResource(String globalId, Object o) {
        ((TransactionImpl)this.getTransactionForID(globalId)).putResource((Object)globalId, o);
    }
}

