/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.cache.AuthCacheService;
import com.ibm.ws.security.authentication.tai.TAIService;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.JaspiService;
import com.ibm.ws.webcontainer.security.PostParameterHelper;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.SSOCookieHelperImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorHelper;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.WebRequestImpl;
import com.ibm.ws.webcontainer.security.internal.SSOAuthenticator;
import com.ibm.ws.webcontainer.security.internal.TAIAuthenticator;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.ws.webcontainer.security.oauth20.OAuth20Service;
import com.ibm.ws.webcontainer.security.openid20.OpenidClientService;
import com.ibm.ws.webcontainer.security.openidconnect.OidcClient;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServer;
import com.ibm.ws.webcontainer.security.util.SSOAuthFilter;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import com.ibm.wsspi.security.token.SingleSignonToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebProviderAuthenticatorProxy
implements WebAuthenticator {
    private static final TraceComponent tc = Tr.register(WebProviderAuthenticatorProxy.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    AuthenticationResult JASPI_CONT = new AuthenticationResult(AuthResult.CONTINUE, "JASPI said continue...");
    protected final AtomicServiceReference<SecurityService> securityServiceRef;
    protected final AtomicServiceReference<TAIService> taiServiceRef;
    protected final ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef;
    static final List<String> authenticatorOdering = Collections.unmodifiableList(Arrays.asList("com.ibm.ws.security.spnego", "com.ibm.ws.security.openid"));
    AuthenticationResult OAUTH_CONT = new AuthenticationResult(AuthResult.CONTINUE, "OAuth service said continue...");
    AuthenticationResult OPENID_CLIENT_CONT = new AuthenticationResult(AuthResult.CONTINUE, "OpenID client service said continue...");
    AuthenticationResult OIDC_SERVER_CONT = new AuthenticationResult(AuthResult.CONTINUE, "OpenID Connect server said continue...");
    AuthenticationResult OIDC_CLIENT_CONT = new AuthenticationResult(AuthResult.CONTINUE, "OpenID Connect client said continue...");
    AuthenticationResult SPNEGO_CONT = new AuthenticationResult(AuthResult.CONTINUE, "SPNEGO said continue...");
    protected final AtomicServiceReference<OAuth20Service> oauthServiceRef;
    private final AtomicServiceReference<OpenidClientService> openIdClientServiceRef;
    private final AtomicServiceReference<OidcServer> oidcServerRef;
    private final AtomicServiceReference<OidcClient> oidcClientRef;
    private final AtomicServiceReference<SSOAuthFilter> ssoAuthFilterRef;
    private WebProviderAuthenticatorHelper authHelper;
    private ReferrerURLCookieHandler referrerURLCookieHandler = null;
    private WebAppSecurityConfig webAppSecurityConfig = null;
    protected final ConcurrentServiceReferenceMap<String, WebAuthenticator> webAuthenticatorRef;
    static final long serialVersionUID = 7286148024038209452L;

    public WebProviderAuthenticatorProxy(AtomicServiceReference<SecurityService> securityServiceRef, AtomicServiceReference<TAIService> taiServiceRef, ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef, WebAppSecurityConfig webAppSecurityConfig, AtomicServiceReference<OAuth20Service> oauthServiceRef, AtomicServiceReference<OpenidClientService> openIdClientServiceRef, AtomicServiceReference<OidcServer> oidcServerRef, AtomicServiceReference<OidcClient> oidcClientRef, ConcurrentServiceReferenceMap<String, WebAuthenticator> webAuthenticatorRef, AtomicServiceReference<SSOAuthFilter> ssoAuthFilterRef) {
        this.securityServiceRef = securityServiceRef;
        this.taiServiceRef = taiServiceRef;
        this.interceptorServiceRef = interceptorServiceRef;
        this.webAppSecurityConfig = webAppSecurityConfig;
        this.webAuthenticatorRef = webAuthenticatorRef;
        this.webAppSecurityConfig = webAppSecurityConfig;
        this.oauthServiceRef = oauthServiceRef;
        this.oidcServerRef = oidcServerRef;
        this.openIdClientServiceRef = openIdClientServiceRef;
        this.oidcClientRef = oidcClientRef;
        this.ssoAuthFilterRef = ssoAuthFilterRef;
        this.authHelper = new WebProviderAuthenticatorHelper(securityServiceRef);
        this.referrerURLCookieHandler = new ReferrerURLCookieHandler(webAppSecurityConfig);
    }

    public void setWebProviderAuthenticatorHelper(WebProviderAuthenticatorHelper authHelper) {
        this.authHelper = authHelper;
    }

    protected AuthenticationResult handleJaspi(final WebRequest webRequest, final HashMap<String, Object> props) {
        JaspiService jaspiService;
        AuthenticationResult authResult = this.JASPI_CONT;
        if (this.webAuthenticatorRef != null && (jaspiService = (JaspiService)this.webAuthenticatorRef.getService((Object)"com.ibm.ws.security.jaspi")) != null) {
            HttpServletRequest request = webRequest.getHttpServletRequest();
            authResult = props == null ? this.authenticateForOtherMechanisms(webRequest, authResult, jaspiService) : this.authenticateForFormMechanism(webRequest, props, jaspiService);
            if (authResult.getStatus() == AuthResult.SUCCESS) {
                if (System.getSecurityManager() == null) {
                    this.processAuthenticationSuccess(webRequest, props, authResult);
                } else {
                    final AuthenticationResult authResultFinal = authResult;
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){
                        static final long serialVersionUID = 3397013613883367688L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Object run() {
                            WebProviderAuthenticatorProxy.this.processAuthenticationSuccess(webRequest, props, authResultFinal);
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy$1", 1.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
                        }
                    });
                }
            }
        }
        return authResult;
    }

    private AuthenticationResult authenticateForOtherMechanisms(WebRequest webRequest, AuthenticationResult authResult, JaspiService jaspiService) {
        AuthResult result;
        authResult = this.handleSSO(webRequest, null);
        if (AuthResult.SUCCESS.equals((Object)authResult.getStatus()) && this.webAppSecurityConfig.isUseLtpaSSOForJaspic()) {
            return authResult;
        }
        Subject subject = authResult.getSubject();
        List<String> tokenUsage = null;
        if (subject != null && !this.isJaspicSessionOrJsr375Form(tokenUsage = this.getTokenUsageFromSSOToken(subject, this.webAppSecurityConfig.createSSOCookieHelper()))) {
            this.clearCacheData(subject);
        }
        boolean isNewAuth = jaspiService.isProcessingNewAuthentication(webRequest.getHttpServletRequest());
        if (!this.isJaspicForm(tokenUsage)) {
            if (!isNewAuth && this.isJaspicSessionOrJsr375Form(tokenUsage)) {
                HashMap<String, Object> requestProps = new HashMap<String, Object>();
                requestProps.put("jakarta.servlet.http.registerSession.subject", subject);
                webRequest.setProperties(requestProps);
            }
            authResult = jaspiService.authenticate(webRequest);
        }
        if ((result = authResult.getStatus()) != AuthResult.CONTINUE && !isNewAuth) {
            if ("BASIC".equals(authResult.getAuditAuthConfigProviderAuthType())) {
                String authHeader = webRequest.getHttpServletRequest().getHeader("Authorization");
                if (authHeader != null && authHeader.startsWith("Basic ")) {
                    String basicAuthHeader = this.decodeCookieString(authHeader.substring(6));
                    int index = basicAuthHeader.indexOf(58);
                    String uid = basicAuthHeader.substring(0, index);
                    authResult.setAuditCredValue(uid);
                }
                if (result == AuthResult.SEND_401) {
                    authResult.setAuditOutcome("challenge");
                }
            }
            if (result == AuthResult.RETURN) {
                authResult.setAuditOutcome("denied");
            }
            authResult.setAuditCredType("JASPIC");
        }
        return authResult;
    }

    /*
     * WARNING - void declaration
     */
    private AuthenticationResult authenticateForFormMechanism(WebRequest webRequest, HashMap<String, Object> props, JaspiService jaspiService) {
        AuthenticationResult authResult;
        try {
            HttpServletRequest req = webRequest.getHttpServletRequest();
            authResult = jaspiService.authenticate(req, webRequest.getHttpServletResponse(), props);
            if (authResult.getStatus() != AuthResult.CONTINUE) {
                String authHeader = webRequest.getHttpServletRequest().getHeader("Authorization");
                if (authHeader != null && authHeader.startsWith("Basic ")) {
                    String basicAuthHeader = this.decodeCookieString(authHeader.substring(6));
                    int index = basicAuthHeader.indexOf(58);
                    String uid = basicAuthHeader.substring(0, index);
                    authResult.setAuditCredValue(uid);
                } else {
                    String username = req.getParameter("j_username");
                    if (username != null) {
                        authResult.setAuditCredValue(username);
                    }
                }
                authResult.setAuditCredType("JASPIC");
                authResult.setAuditOutcome("denied");
            }
        }
        catch (Exception req) {
            void e;
            FFDCFilter.processException((Throwable)req, (String)"com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy", (String)"232", (Object)this, (Object[])new Object[]{webRequest, props, jaspiService});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Internal error handling JASPI request", (Object[])new Object[]{e});
            }
            authResult = new AuthenticationResult(AuthResult.FAILURE, e.getMessage());
        }
        return authResult;
    }

    private void processAuthenticationSuccess(WebRequest webRequest, HashMap<String, Object> props, AuthenticationResult authResult) {
        Subject subject = authResult.getSubject();
        this.attemptToRestorePostParams(webRequest);
        boolean isRegisterSession = false;
        Map<String, Object> reqProps = webRequest.getProperties();
        if (reqProps != null) {
            isRegisterSession = Boolean.valueOf((String)reqProps.get("jakarta.servlet.http.registerSession"));
        }
        SSOCookieHelper ssoCh = this.webAppSecurityConfig.createSSOCookieHelper();
        if (isRegisterSession) {
            this.registerSession(webRequest, subject, ssoCh);
        } else {
            List<String> tokenUsage = this.getTokenUsageFromSSOToken(subject, ssoCh);
            if (this.isJaspicAttribute(tokenUsage)) {
                if (this.isFormLogin(props)) {
                    this.registerSession(webRequest, subject, ssoCh);
                } else if (!this.isJaspicSession(tokenUsage) && !this.webAppSecurityConfig.isUseLtpaSSOForJaspic()) {
                    ssoCh.createLogoutCookies(webRequest.getHttpServletRequest(), webRequest.getHttpServletResponse());
                }
            } else if (!this.webAppSecurityConfig.isUseLtpaSSOForJaspic()) {
                this.attemptToRemoveLtpaToken(webRequest, props);
            }
        }
    }

    private void registerSession(final WebRequest webRequest, final Subject subject, final SSOCookieHelper ssoCh) {
        if (System.getSecurityManager() == null) {
            ssoCh.addSSOCookiesToResponse(subject, webRequest.getHttpServletRequest(), webRequest.getHttpServletResponse());
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){
                static final long serialVersionUID = 2061544974763019296L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() {
                    ssoCh.addSSOCookiesToResponse(subject, webRequest.getHttpServletRequest(), webRequest.getHttpServletResponse());
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy$2", 2.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
                }
            });
        }
    }

    private HttpServletResponse attemptToRestorePostParams(WebRequest webRequest) {
        HttpServletResponse res = webRequest.getHttpServletResponse();
        if (!res.isCommitted()) {
            this.restorePostParams(webRequest);
        }
        return res;
    }

    protected void restorePostParams(WebRequest webRequest) {
        PostParameterHelper postParameterHelper = new PostParameterHelper(this.webAppSecurityConfig);
        postParameterHelper.restore(webRequest.getHttpServletRequest(), webRequest.getHttpServletResponse());
    }

    private void attemptToRemoveLtpaToken(WebRequest webRequest, HashMap<String, Object> props) {
        HttpServletResponse res;
        SSOCookieHelper ssoCh = this.webAppSecurityConfig.createSSOCookieHelper();
        if (!this.isFormLogin(props) && !(res = webRequest.getHttpServletResponse()).isCommitted()) {
            ssoCh.removeSSOCookieFromResponse(res);
        }
    }

    public AuthenticationResult authenticate1(HttpServletRequest request, HttpServletResponse response, HashMap<String, Object> props) throws Exception {
        WebRequestImpl webRequest = new WebRequestImpl(request, response, null, null, null, null, null);
        AuthenticationResult authResult = this.handleJaspi(webRequest, props);
        return authResult;
    }

    protected AuthenticationResult handleTAI(WebRequest webRequest, boolean beforeSSO) {
        TAIAuthenticator taiAuthenticator = this.getTaiAuthenticator();
        AuthenticationResult authResult = null;
        if (taiAuthenticator == null) {
            authResult = new AuthenticationResult(AuthResult.CONTINUE, "TAI invoke " + (beforeSSO ? "before" : "after") + " SSO is not available, skipping TAI...");
        } else {
            authResult = taiAuthenticator.authenticate(webRequest, beforeSSO);
            if (authResult.getStatus() != AuthResult.CONTINUE) {
                authResult.setAuditCredType("TrustAssociationInterceptor");
            }
        }
        return authResult;
    }

    protected AuthenticationResult handleSSO(WebRequest webRequest, String ssoCookieName) {
        WebAuthenticator authenticator = this.getSSOAuthenticator(webRequest, ssoCookieName);
        AuthenticationResult authResult = authenticator.authenticate(webRequest);
        if (authResult == null || authResult.getStatus() != AuthResult.SUCCESS) {
            authResult = new AuthenticationResult(AuthResult.CONTINUE, "SSO did not succeed, so continue ...");
        }
        return authResult;
    }

    protected boolean isNotNullAndTrue(HttpServletRequest req, String key) {
        Boolean result = (Boolean)req.getAttribute(key);
        if (result != null) {
            return result;
        }
        return false;
    }

    public ConcurrentServiceReferenceMap<String, WebAuthenticator> getWebAuthenticatorRefs() {
        return this.webAuthenticatorRef;
    }

    @Sensitive
    private String decodeCookieString(@Sensitive String cookieString) {
        try {
            return Base64Coder.base64Decode((String)cookieString);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive java.lang.String>";
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy", (String)"378", (Object)this, (Object[])objectArray);
            return null;
        }
    }

    private List<String> getTokenUsageFromSSOToken(Subject subject, SSOCookieHelper ssoCh) {
        String[] attrs;
        SingleSignonToken ssoToken = ssoCh.getDefaultSSOTokenFromSubject(subject);
        if (ssoToken != null && (attrs = ssoToken.getAttributes("com.ibm.ws.authentication.internal.auth.provider")) != null) {
            return Arrays.asList(attrs);
        }
        return null;
    }

    private boolean isJaspicSessionOrJsr375Form(List<String> attrs) {
        return attrs != null && (attrs.contains("jaspic") || attrs.contains("jsr375Form"));
    }

    private boolean isJaspicSession(List<String> attrs) {
        return attrs != null && attrs.contains("jaspic");
    }

    private boolean isJaspicForm(List<String> attrs) {
        return attrs != null && attrs.contains("jaspicForm");
    }

    private boolean isJaspicAttribute(List<String> attrs) {
        return attrs != null && (attrs.contains("jaspic") || attrs.contains("jsr375Form") || attrs.contains("jaspicForm"));
    }

    private boolean isFormLogin(Map<String, Object> props) {
        return props != null && "FORM_LOGIN".equals(props.get("authType"));
    }

    /*
     * WARNING - void declaration
     */
    private void clearCacheData(Subject subject) {
        block3: {
            AuthCacheService authCacheService = ((SecurityService)this.securityServiceRef.getService()).getAuthenticationService().getAuthCacheService();
            WSCredential credential = subject.getPublicCredentials(WSCredential.class).iterator().next();
            try {
                String authUserName = credential.getRealmName() + ":" + credential.getSecurityName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Deleting cache entry of user : " + authUserName), (Object[])new Object[0]);
                }
                authCacheService.remove((Object)authUserName);
            }
            catch (Exception authUserName) {
                void e;
                FFDCFilter.processException((Throwable)authUserName, (String)"com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy", (String)"440", (Object)this, (Object[])new Object[]{subject});
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("A cache entry cannot be deleted. An exception is caught : " + e), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public AuthenticationResult authenticate(WebRequest webRequest) {
        HttpServletRequest request = webRequest.getHttpServletRequest();
        HttpServletResponse response = webRequest.getHttpServletResponse();
        AuthenticationResult authResult = this.handleTAI(webRequest, true);
        if (authResult.getStatus() == AuthResult.CONTINUE && (authResult = this.handleAccessToken(webRequest)).getStatus() == AuthResult.CONTINUE) {
            webRequest.setCallAfterSSO(false);
            authResult = this.handleSpnego(webRequest);
            if (authResult.getStatus() == AuthResult.CONTINUE && (authResult = this.handleOidcClient(request, response, true)).getStatus() == AuthResult.CONTINUE && (authResult = this.handleSSO(webRequest, null)).getStatus() == AuthResult.CONTINUE) {
                webRequest.setCallAfterSSO(true);
                authResult = this.handleSpnego(webRequest);
                if (authResult.getStatus() == AuthResult.CONTINUE && (authResult = this.handleTAI(webRequest, false)).getStatus() == AuthResult.CONTINUE) {
                    authResult = this.handleOidcClient(request, response, false);
                }
            }
        }
        return authResult;
    }

    @Override
    public AuthenticationResult authenticate(HttpServletRequest request, HttpServletResponse response, HashMap<String, Object> props) throws Exception {
        AuthenticationResult authResult;
        WebRequestImpl webRequest = new WebRequestImpl(request, response, null, null, null, null, this.webAppSecurityConfig);
        if (props != null && props.get("authType").equals("com.ibm.ws.security.spnego")) {
            authResult = this.handleSpnego(webRequest);
        } else {
            authResult = this.handleJaspi(webRequest, props);
            if (authResult.getStatus() == AuthResult.CONTINUE) {
                authResult = this.handleOpenidClient(request, response);
            }
        }
        return authResult;
    }

    private AuthenticationResult handleAccessToken(WebRequest webRequest) {
        HttpServletResponse res;
        HttpServletRequest req = webRequest.getHttpServletRequest();
        AuthenticationResult authResult = this.handleOAuth(req, res = webRequest.getHttpServletResponse());
        if (authResult.getStatus() != AuthResult.CONTINUE) {
            authResult.setAuditCredType("OAuth token");
        }
        return authResult;
    }

    public AuthenticationResult handleSpnego(WebRequest webRequest) {
        HttpServletResponse response;
        HttpServletRequest request;
        WebAuthenticator webAuthenticator;
        AuthenticationResult authResult = this.SPNEGO_CONT;
        if (this.webAuthenticatorRef != null && (webAuthenticator = this.getSpnegoAuthenticator()) != null && (authResult = webAuthenticator.authenticate(webRequest)).getStatus() == AuthResult.SUCCESS && AuthResult.SUCCESS == (authResult = this.authHelper.loginWithHashtable(request = webRequest.getHttpServletRequest(), response = webRequest.getHttpServletResponse(), authResult.getSubject())).getStatus()) {
            SSOCookieHelper ssoCh = this.webAppSecurityConfig.createSSOCookieHelper();
            ssoCh.addSSOCookiesToResponse(authResult.getSubject(), request, response);
        }
        if (authResult.getStatus() != AuthResult.CONTINUE) {
            authResult.setAuditCredType("SPNEGO");
        }
        return authResult;
    }

    public WebAuthenticator getSpnegoAuthenticator() {
        WebAuthenticator webAuthenticator = (WebAuthenticator)this.webAuthenticatorRef.getService((Object)"com.ibm.ws.security.spnego");
        return webAuthenticator;
    }

    private AuthenticationResult handleOpenidClient(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuthenticationResult authResult = this.OPENID_CLIENT_CONT;
        OpenidClientService openIdClientService = (OpenidClientService)this.openIdClientServiceRef.getService();
        if (openIdClientService != null) {
            String opId = openIdClientService.getOpenIdIdentifier(request);
            if (opId != null && !opId.isEmpty()) {
                openIdClientService.createAuthRequest(request, response);
                authResult = new AuthenticationResult(AuthResult.REDIRECT_TO_PROVIDER, "OpenID client creates auth request...");
            } else if (openIdClientService.getRpRequestIdentifier(request, response) != null) {
                ProviderAuthenticationResult result = openIdClientService.verifyOpResponse(request, response);
                if (result.getStatus() != AuthResult.SUCCESS) {
                    return new AuthenticationResult(AuthResult.FAILURE, "OpenID client failed with status code " + (Object)((Object)result.getStatus()));
                }
                authResult = this.authHelper.loginWithUserName(request, response, result.getUserName(), result.getSubject(), result.getCustomProperties(), openIdClientService.isMapIdentityToRegistryUser());
            }
        }
        if (authResult.getStatus() != AuthResult.CONTINUE) {
            authResult.setAuditCredType("IDToken");
        }
        return authResult;
    }

    private AuthenticationResult handleOidcClient(HttpServletRequest req, HttpServletResponse res, boolean firstCall) {
        String provider;
        AuthenticationResult authResult = this.OIDC_CLIENT_CONT;
        OidcClient oidcClient = (OidcClient)this.oidcClientRef.getService();
        if (oidcClient == null) {
            return new AuthenticationResult(AuthResult.CONTINUE, "OpenID Connect client is not available, skipping OpenID Connect client...");
        }
        if (firstCall) {
            oidcClient.logoutIfSessionInvalidated(req);
            if (!oidcClient.anyClientIsBeforeSso()) {
                return authResult;
            }
        }
        if ((provider = oidcClient.getOidcProvider(req)) == null) {
            return new AuthenticationResult(AuthResult.CONTINUE, "not an OpenID Connect client request, skipping OpenID Connect client...");
        }
        ProviderAuthenticationResult oidcResult = oidcClient.authenticate(req, res, provider, this.referrerURLCookieHandler, firstCall);
        if (oidcResult.getStatus() == AuthResult.CONTINUE) {
            return this.OIDC_CLIENT_CONT;
        }
        if (oidcResult.getStatus() == AuthResult.REDIRECT_TO_PROVIDER) {
            return new AuthenticationResult(AuthResult.REDIRECT, oidcResult.getRedirectUrl());
        }
        if (oidcResult.getStatus() == AuthResult.FAILURE) {
            if (401 == oidcResult.getHttpStatusCode()) {
                return new AuthenticationResult(AuthResult.OAUTH_CHALLENGE, "OpenID Connect client failed the request...");
            }
            return new AuthenticationResult(AuthResult.FAILURE, "OpenID Connect client failed the request...");
        }
        if (oidcResult.getStatus() != AuthResult.SUCCESS) {
            if (401 == oidcResult.getHttpStatusCode()) {
                return new AuthenticationResult(AuthResult.OAUTH_CHALLENGE, "OpenID Connect client returned with status: " + (Object)((Object)oidcResult.getStatus()));
            }
            return new AuthenticationResult(AuthResult.FAILURE, "OpenID Connect client returned with status: " + (Object)((Object)oidcResult.getStatus()));
        }
        if (oidcResult.getStatus() == AuthResult.SUCCESS && oidcResult.getUserName() != null && AuthResult.SUCCESS == (authResult = this.authHelper.loginWithUserName(req, res, oidcResult.getUserName(), oidcResult.getSubject(), oidcResult.getCustomProperties(), oidcClient.isMapIdentityToRegistryUser(provider))).getStatus()) {
            boolean bDisableLtpaCookie = firstCall;
            boolean bPropagationTokenAuthenticated = this.isNotNullAndTrue(req, "com.ibm.ws.webcontainer.security.openidconnect.propagation.token.authenticated");
            boolean bAuthnSessionDisabled = (Boolean)req.getAttribute("com.ibm.ws.webcontainer.security.openidconnect.authn.session.disabled");
            String inboundValue = (String)req.getAttribute("com.ibm.ws.webcontainer.security.openidconnect.inbound.propagation.value");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Booleans: fisrtCall:" + firstCall + " tokenAuthenticated:" + bPropagationTokenAuthenticated + " SessionDisabled:" + bAuthnSessionDisabled + " inboundValue:" + inboundValue), (Object[])new Object[0]);
            }
            boolean includeAccessTokenInLtpa = (Boolean)req.getAttribute("com.ibm.ws.webcontainer.security.oidc.accesstoken.in.ltpa");
            if ("none".equals(inboundValue) && !bDisableLtpaCookie || "required".equals(inboundValue) && !bAuthnSessionDisabled || "supported".equals(inboundValue) && !bPropagationTokenAuthenticated && !bDisableLtpaCookie || includeAccessTokenInLtpa && "supported".equals(inboundValue)) {
                SSOCookieHelper ssoCh = this.webAppSecurityConfig.createSSOCookieHelper();
                if (includeAccessTokenInLtpa) {
                    this.addAccessTokenToTheCookie(authResult, ssoCh);
                }
                ssoCh.addSSOCookiesToResponse(authResult.getSubject(), req, res);
            }
        }
        return authResult;
    }

    private void addAccessTokenToTheCookie(AuthenticationResult authResult, SSOCookieHelper ssoCh) {
        Subject subject = authResult.getSubject();
        if (subject != null) {
            String accessToken = WebProviderAuthenticatorProxy.getAccessTokenFromTheSubject(subject, "access_token");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"access token from the subject = ", (Object[])new Object[]{accessToken});
            }
            SingleSignonToken ssoToken = ssoCh.getDefaultSSOTokenFromSubject(subject);
            if (accessToken != null && ssoToken != null) {
                if (ssoToken.getAttributes("oidc_access_token") == null || ssoToken.getAttributes("oidc_access_token").length < 1) {
                    ssoToken.addAttribute("oidc_access_token", accessToken);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Successfully added the access token to the single sign on token  = ", (Object[])new Object[]{accessToken});
                }
            }
        }
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    static String getAccessTokenFromTheSubject(Subject subject, String attribKey) {
        String result;
        block3: {
            result = null;
            try {
                Set<Object> publicCredentials = subject.getPublicCredentials();
                result = WebProviderAuthenticatorProxy.getCredentialAttribute(publicCredentials, attribKey, "publicCredentials");
                if (result == null || result.isEmpty()) {
                    Set<Object> privateCredentials = subject.getPrivateCredentials();
                    result = WebProviderAuthenticatorProxy.getCredentialAttribute(privateCredentials, attribKey, "privateCredentials");
                }
            }
            catch (PrivilegedActionException e) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Did not find a value for the attribute (" + attribKey + ")"), (Object[])new Object[0]);
            }
        }
        return result;
    }

    static String getCredentialAttribute(final Set<Object> credentials, final String attribKey, final String msg) throws PrivilegedActionException {
        Object obj = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
            static final long serialVersionUID = -4778002191149095386L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object run() throws Exception {
                int iCnt = 0;
                for (Object credentialObj : credentials) {
                    Object value;
                    Object accessToken;
                    ++iCnt;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(msg + "(" + iCnt + ") class:" + credentialObj.getClass().getName()), (Object[])new Object[0]);
                    }
                    if (!(credentialObj instanceof Map) || (accessToken = ((Map)credentialObj).get("access_token")) == null || (value = ((Map)credentialObj).get(attribKey)) == null) continue;
                    return value;
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy$3", 3.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
            }
        });
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    private AuthenticationResult handleOAuth(HttpServletRequest req, HttpServletResponse res) {
        AuthenticationResult authResult = this.OAUTH_CONT;
        if (this.oauthServiceRef != null) {
            OAuth20Service oauthService = (OAuth20Service)this.oauthServiceRef.getService();
            if (oauthService == null) {
                return new AuthenticationResult(AuthResult.CONTINUE, "OAuth service is not available, skipping OAuth...");
            }
            ProviderAuthenticationResult oauthResult = oauthService.authenticate(req, res);
            if (oauthResult.getStatus() == AuthResult.CONTINUE) {
                return this.OAUTH_CONT;
            }
            if (oauthResult.getStatus() == AuthResult.FAILURE) {
                if (401 == oauthResult.getHttpStatusCode()) {
                    return new AuthenticationResult(AuthResult.OAUTH_CHALLENGE, "OAuth service failed the request");
                }
                return new AuthenticationResult(AuthResult.FAILURE, "OAuth service failed the request...");
            }
            if (oauthResult.getStatus() != AuthResult.SUCCESS) {
                if (401 == oauthResult.getHttpStatusCode()) {
                    return new AuthenticationResult(AuthResult.OAUTH_CHALLENGE, "OAuth service failed the request due to unsuccessful request");
                }
                return new AuthenticationResult(AuthResult.FAILURE, "OAuth service returned with status: " + (Object)((Object)oauthResult.getStatus()));
            }
            if (oauthResult.getUserName() != null) {
                authResult = this.authHelper.loginWithUserName(req, res, oauthResult.getUserName(), oauthResult.getSubject(), oauthResult.getCustomProperties(), true);
            }
        }
        return authResult;
    }

    protected TAIAuthenticator getTaiAuthenticator() {
        TAIAuthenticator taiAuthenticator = null;
        TAIService taiService = (TAIService)this.taiServiceRef.getService();
        Iterator interceptorServices = this.interceptorServiceRef.getServices();
        if (taiService != null || interceptorServices != null && interceptorServices.hasNext()) {
            SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
            taiAuthenticator = new TAIAuthenticator(taiService, this.interceptorServiceRef, securityService.getAuthenticationService(), new SSOCookieHelperImpl(this.webAppSecurityConfig));
        }
        return taiAuthenticator;
    }

    public WebAuthenticator getSSOAuthenticator(WebRequest webRequest, String ssoCookieName) {
        SecurityMetadata securityMetadata = webRequest.getSecurityMetadata();
        SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        SSOCookieHelperImpl cookieHelper = ssoCookieName != null ? new SSOCookieHelperImpl(this.webAppSecurityConfig, ssoCookieName) : new SSOCookieHelperImpl(this.webAppSecurityConfig);
        return new SSOAuthenticator(securityService.getAuthenticationService(), securityMetadata, this.webAppSecurityConfig, cookieHelper, this.ssoAuthFilterRef);
    }
}

