/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.jwtsso.token.proxy.JwtSSOTokenHelper;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.internal.LoggedOutJwtSsoCookieCache;
import com.ibm.ws.webcontainer.security.internal.StringUtil;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServer;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SSOCookieHelperImpl
implements SSOCookieHelper {
    private static final TraceComponent tc = Tr.register(SSOCookieHelperImpl.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    private static final String OIDC_BROWSER_STATE_COOKIE = "oidc_bsc";
    private final AtomicServiceReference<OidcServer> oidcServerRef = null;
    private static final String[] disableSsoLtpaCookie = new String[]{"com.ibm.ws.authentication.internal.sso.disable.ltpa.cookie"};
    protected static final ConcurrentMap<ByteArray, String> cookieByteStringCache = new ConcurrentHashMap<ByteArray, String>(20);
    private static int MAX_COOKIE_STRING_ENTRIES = 100;
    private String cookieName = null;
    protected final WebAppSecurityConfig config;
    static final long serialVersionUID = 6579450566000043629L;

    public SSOCookieHelperImpl(WebAppSecurityConfig config) {
        this(config, null);
    }

    public SSOCookieHelperImpl(WebAppSecurityConfig config, String ssoCookieName) {
        this.config = config;
        this.cookieName = ssoCookieName;
    }

    @Override
    public boolean addJwtSsoCookiesToResponse(Subject subject, HttpServletRequest req, HttpServletResponse resp) {
        boolean result = false;
        if (JwtSSOTokenHelper.isDisableJwtCookie()) {
            return result;
        }
        String cookieByteString = JwtSSOTokenHelper.getJwtSSOToken((Subject)subject);
        if (cookieByteString != null) {
            boolean cookieAlreadySent;
            String testString = this.getJwtSsoTokenFromCookies(req, this.getJwtCookieName());
            boolean bl = cookieAlreadySent = testString != null && testString.equals(cookieByteString);
            if (!cookieAlreadySent) {
                result = this.addJwtCookies(cookieByteString, req, resp);
            }
        }
        return result;
    }

    protected boolean addJwtCookies(String cookieByteString, HttpServletRequest req, HttpServletResponse resp) {
        String baseName = this.getJwtCookieName();
        if (baseName == null) {
            return false;
        }
        if (!req.isSecure() && this.getJwtCookieSecure()) {
            Tr.warning((TraceComponent)tc, (String)"JWT_COOKIE_SECURITY_MISMATCH", (Object[])new Object[0]);
        }
        String[] chunks = this.splitString(cookieByteString, 3900);
        String cookieName = baseName;
        for (int i = 0; i < chunks.length; ++i) {
            if (i > 98) {
                String eMsg = "Too many jwt cookies created";
                FFDCFilter.processException((Throwable)new Exception(eMsg), (String)this.getClass().getName(), (String)"132");
                break;
            }
            Cookie ssoCookie = this.createCookie(req, cookieName, chunks[i], this.getJwtCookieSecure());
            resp.addCookie(ssoCookie);
            cookieName = baseName + (i + 2 < 10 ? "0" : "") + (i + 2);
        }
        return true;
    }

    protected String getJwtCookieName() {
        return JwtSSOTokenHelper.getJwtCookieName();
    }

    protected boolean getJwtCookieSecure() {
        return JwtSSOTokenHelper.isCookieSecured();
    }

    public Cookie createCookie(HttpServletRequest req, String cookieValue) {
        return this.createCookie(req, this.getSSOCookiename(), cookieValue, this.config.getSSORequiresSSL());
    }

    public Cookie createCookie(HttpServletRequest req, String cookieName, String cookieValue, boolean isSecure) {
        String sameSite;
        Cookie ssoCookie = new Cookie(cookieName, cookieValue);
        ssoCookie.setMaxAge(-1);
        ssoCookie.setPath("/");
        ssoCookie.setSecure(isSecure);
        ssoCookie.setHttpOnly(this.config.getHttpOnlyCookies());
        String domainName = this.getSSODomainName(req, this.config.getSSODomainList(), this.config.getSSOUseDomainFromURL());
        if (domainName != null) {
            ssoCookie.setDomain(domainName);
        }
        if ((sameSite = this.config.getSameSiteCookie()) != null && !sameSite.equals("Disabled")) {
            WebContainerRequestState requestState = WebContainerRequestState.getInstance((boolean)true);
            requestState.setCookieAttributes(cookieName, "SameSite=" + sameSite);
            if (sameSite.equals("None")) {
                ssoCookie.setSecure(true);
            }
        }
        return ssoCookie;
    }

    @Override
    public boolean allowToAddCookieToResponse(HttpServletRequest req) {
        if (!this.config.isSingleSignonEnabled()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SSO is not enabled. Not setting the SSO Cookie", (Object[])new Object[0]);
            }
            return false;
        }
        boolean secureRequest = req.isSecure();
        if (this.config.getSSORequiresSSL() && !secureRequest) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SSO requires SSL. The cookie will not be sent back because the request is not over https.", (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    @Override
    public void removeSSOCookieFromResponse(HttpServletResponse resp) {
        if (resp instanceof IExtendedResponse) {
            ((IExtendedResponse)resp).removeCookie(this.getSSOCookiename());
            this.removeJwtSSOCookies((IExtendedResponse)resp);
        }
    }

    protected void removeJwtSSOCookies(IExtendedResponse resp) {
        String cookieName = this.getJwtCookieName();
        if (cookieName == null) {
            return;
        }
        resp.removeCookie(cookieName);
        for (int i = 2; i <= 99; ++i) {
            String nextCookieName = cookieName + (i < 10 ? "0" : "") + i;
            resp.removeCookie(nextCookieName);
        }
    }

    protected synchronized void updateCookieCache(ByteArray cookieBytes, String cookieByteString) {
        if (cookieByteStringCache.size() > MAX_COOKIE_STRING_ENTRIES) {
            cookieByteStringCache.clear();
        }
        if (cookieByteString != null) {
            cookieByteStringCache.put(cookieBytes, cookieByteString);
        }
    }

    @Override
    public void createLogoutCookies(HttpServletRequest req, HttpServletResponse res, boolean deleteJwtCookies) {
        Cookie[] cookies = req.getCookies();
        ArrayList<Cookie> logoutCookieList = new ArrayList<Cookie>();
        if (cookies != null) {
            String ssoCookieName = this.resolveCookieName(cookies);
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equalsIgnoreCase(ssoCookieName)) continue;
                cookies[i].setValue(null);
                this.addLogoutCookieToList(req, ssoCookieName, logoutCookieList);
            }
            if (deleteJwtCookies) {
                this.logoutJwtCookies(req, cookies, logoutCookieList);
            }
            for (Cookie cookie : logoutCookieList) {
                res.addCookie(cookie);
            }
        }
    }

    protected void logoutJwtCookies(HttpServletRequest req, Cookie[] cookies, ArrayList<Cookie> logoutCookieList) {
        String jwtCookieName = this.getJwtCookieName();
        if (jwtCookieName != null) {
            String jwtTokenStr = this.getJwtSsoTokenFromCookies(req, jwtCookieName);
            if (jwtTokenStr != null) {
                LoggedOutJwtSsoCookieCache.put(jwtTokenStr);
            }
            for (int i = 0; i < cookies.length; ++i) {
                if (!this.isJwtCookie(jwtCookieName, cookies[i].getName())) continue;
                cookies[i].setValue(null);
                this.addLogoutCookieToList(req, cookies[i].getName(), logoutCookieList);
            }
        }
    }

    protected boolean isJwtCookie(String baseName, String cookieName) {
        if (baseName.equalsIgnoreCase(cookieName)) {
            return true;
        }
        if (!cookieName.startsWith(baseName)) {
            return false;
        }
        if (cookieName.length() != baseName.length() + 2) {
            return false;
        }
        String lastTwoChars = cookieName.substring(baseName.length());
        return lastTwoChars.matches("\\d\\d");
    }

    protected String resolveCookieName(Cookie[] cookies) {
        boolean foundCookie = false;
        String ssoCookieName = this.getSSOCookiename();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equalsIgnoreCase(ssoCookieName)) continue;
                foundCookie = true;
                break;
            }
        }
        if (!foundCookie && !this.config.isUseOnlyCustomCookieName()) {
            return "LtpaToken2";
        }
        return ssoCookieName;
    }

    protected void addLogoutCookieToList(HttpServletRequest req, String cookieName, ArrayList<Cookie> cookieList) {
        String domainName;
        Cookie c = new Cookie(cookieName, "");
        c.setMaxAge(0);
        c.setPath("/");
        c.setSecure(req.isSecure());
        if (this.config.getHttpOnlyCookies()) {
            c.setHttpOnly(true);
        }
        if ((domainName = this.getSSODomainName(req, this.config.getSSODomainList(), this.config.getSSOUseDomainFromURL())) != null) {
            c.setDomain(domainName);
        }
        cookieList.add(c);
    }

    @Override
    public SingleSignonToken getDefaultSSOTokenFromSubject(final Subject subject) {
        if (subject == null) {
            return null;
        }
        SingleSignonToken ssoToken = null;
        Set privateCredentials = null;
        try {
            privateCredentials = (Set)AccessController.doPrivileged(new PrivilegedAction(){
                static final long serialVersionUID = -7306312076967563729L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public Object run() {
                    return subject.getPrivateCredentials(SingleSignonToken.class);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.webcontainer.security.SSOCookieHelperImpl$1", 1.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
                }
            });
            Iterator ssoIterator = privateCredentials.iterator();
            while (ssoIterator.hasNext() && !(ssoToken = (SingleSignonToken)ssoIterator.next()).getName().equals(this.getSSOCookiename())) {
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.security.SSOCookieHelperImpl", (String)"372", (Object)this, (Object[])new Object[]{subject});
        }
        return ssoToken;
    }

    @Override
    public String getSSOCookiename() {
        if (this.cookieName != null) {
            return this.cookieName;
        }
        return this.config.getSSOCookieName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getSSODomainName(HttpServletRequest req, List<String> ssoDomainList, boolean useDomainFromURL) {
        block7: {
            try {
                String domain;
                String host = this.getHostNameFromRequestURL(req);
                if (SSOCookieHelperImpl.isIpV4Format(host) || host.indexOf(".") == -1) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"URL host is an IP or locahost, no SSO domain will be set.", (Object[])new Object[0]);
                    }
                    return null;
                }
                String string = domain = host.indexOf(".") < host.lastIndexOf(".") ? host.substring(host.indexOf(".")) : "" + host;
                if (ssoDomainList != null && !ssoDomainList.isEmpty()) {
                    for (String dm : ssoDomainList) {
                        if (!domain.endsWith(dm)) continue;
                        return dm;
                    }
                }
                if (useDomainFromURL) {
                    return domain;
                }
            }
            catch (MalformedURLException host) {
                void e;
                FFDCFilter.processException((Throwable)host, (String)"com.ibm.ws.webcontainer.security.SSOCookieHelperImpl", (String)"422", (Object)this, (Object[])new Object[]{req, ssoDomainList, useDomainFromURL});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception getting request SSO domain", (Object[])new Object[]{e});
            }
        }
        return null;
    }

    static boolean isIpV4Format(String ipAddr) {
        Pattern ptn = Pattern.compile("^(?:[0-9]{1,3}\\.){3}[0-9]{1,3}$");
        Matcher mtch = ptn.matcher(ipAddr);
        return mtch.find();
    }

    @FFDCIgnore(value={UnknownHostException.class})
    private String getHostIPAddr(String host) {
        String iAddr;
        block2: {
            iAddr = "";
            try {
                iAddr = InetAddress.getByName(host).getHostAddress().trim();
            }
            catch (UnknownHostException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Exception in getting IP address for URL host, assuming URL host is not an IP", (Object[])new Object[]{e});
            }
        }
        return iAddr;
    }

    private String getHostNameFromRequestURL(HttpServletRequest req) throws MalformedURLException {
        String requestUrl = req.getRequestURL().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("URL: " + requestUrl), (Object[])new Object[0]);
        }
        URL url = new URL(requestUrl);
        String host = url.getHost().trim();
        return host;
    }

    @Trivial
    protected String[] splitString(String buf, int blockSize) {
        ArrayList<String> al = new ArrayList<String>();
        if (blockSize <= 0 || buf == null || buf.length() == 0) {
            return al.toArray(new String[0]);
        }
        int begin = 0;
        int end = 0;
        int length = buf.length();
        while (true) {
            end = begin + (length - end < blockSize ? length - end : blockSize);
            al.add(buf.substring(begin, end));
            if (end >= length) break;
            begin += end - begin;
        }
        return al.toArray(new String[0]);
    }

    @Override
    public String getJwtSsoTokenFromCookies(HttpServletRequest req, String baseName) {
        StringBuffer tokenStr = new StringBuffer();
        String cookieName = baseName;
        for (int i = 1; i <= 99; ++i) {
            String cookieValue;
            if (i > 1) {
                cookieName = baseName + (i < 10 ? "0" : "") + i;
            }
            if ((cookieValue = this.getCookieValue(req, cookieName)) == null) break;
            if (cookieValue.length() <= 0) continue;
            tokenStr.append(cookieValue);
        }
        return tokenStr.length() > 0 ? tokenStr.toString() : null;
    }

    protected String getCookieValue(HttpServletRequest req, String cookieName) {
        String[] hdrVals = CookieHelper.getCookieValues(this.getCookies(req), cookieName);
        String result = null;
        if (hdrVals != null) {
            for (int n = 0; n < hdrVals.length; ++n) {
                String hdrVal = hdrVals[n];
                if (hdrVal == null || hdrVal.length() <= 0) continue;
                result = hdrVal;
                break;
            }
        }
        return result;
    }

    private Cookie[] getCookies(HttpServletRequest req) {
        return req.getCookies();
    }

    @Override
    public void addSSOCookiesToResponse(Subject subject, HttpServletRequest req, HttpServletResponse resp) {
        if (!this.allowToAddCookieToResponse(req)) {
            return;
        }
        this.addJwtSsoCookiesToResponse(subject, req, resp);
        if (!JwtSSOTokenHelper.shouldAlsoIncludeLtpaCookie()) {
            return;
        }
        if (!this.isDisableLtpaCookie(subject)) {
            this.addLtpaSsoCookiesToResponse(subject, req, resp);
        }
        if (this.oidcServerRef != null && this.oidcServerRef.getService() != null && this.isBrowserStateEnabled(req)) {
            this.removeBrowserStateCookie(req, resp);
        }
    }

    private boolean isDisableLtpaCookie(Subject subject) {
        SubjectHelper subjectHelper = new SubjectHelper();
        Hashtable hashtable = subjectHelper.getHashtableFromSubject(subject, disableSsoLtpaCookie);
        return hashtable != null && (Boolean)hashtable.get("com.ibm.ws.authentication.internal.sso.disable.ltpa.cookie") != false;
    }

    private void addLtpaSsoCookiesToResponse(Subject subject, HttpServletRequest req, HttpServletResponse resp) {
        byte[] ssoTokenBytes;
        SingleSignonToken ssoToken = this.getDefaultSSOTokenFromSubject(subject);
        if (ssoToken != null && (ssoTokenBytes = ssoToken.getBytes()) != null) {
            ByteArray cookieBytes = new ByteArray(ssoTokenBytes);
            String cookieByteString = (String)cookieByteStringCache.get(cookieBytes);
            if (cookieByteString == null) {
                cookieByteString = StringUtil.toString(Base64Coder.base64Encode((byte[])ssoTokenBytes));
                this.updateCookieCache(cookieBytes, cookieByteString);
            }
            Cookie ssoCookie = this.createCookie(req, cookieByteString);
            resp.addCookie(ssoCookie);
        }
    }

    @Override
    public void createLogoutCookies(HttpServletRequest req, HttpServletResponse res) {
        Cookie[] cookies = req.getCookies();
        ArrayList<Cookie> logoutCookieList = new ArrayList<Cookie>();
        if (cookies != null) {
            String ssoCookieName = this.resolveCookieName(cookies);
            for (int i = 0; i < cookies.length; ++i) {
                if (cookies[i].getName().equalsIgnoreCase(ssoCookieName)) {
                    cookies[i].setValue(null);
                    this.addLogoutCookieToList(req, ssoCookieName, logoutCookieList);
                    continue;
                }
                if (!cookies[i].getName().equalsIgnoreCase(OIDC_BROWSER_STATE_COOKIE) || this.oidcServerRef == null || this.oidcServerRef.getService() == null) continue;
                this.removeBrowserStateCookie(req, res);
            }
            this.logoutJwtCookies(req, cookies, logoutCookieList);
            for (Cookie cookie : logoutCookieList) {
                res.addCookie(cookie);
            }
        }
    }

    protected boolean isBrowserStateEnabled(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equalsIgnoreCase(OIDC_BROWSER_STATE_COOKIE)) continue;
                return true;
            }
        }
        return false;
    }

    protected void removeBrowserStateCookie(HttpServletRequest req, HttpServletResponse res) {
        Cookie c = new Cookie(OIDC_BROWSER_STATE_COOKIE, "");
        c.setMaxAge(0);
        c.setPath("/");
        c.setSecure(req.isSecure());
        res.addCookie(c);
    }
}

