/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.config.resource;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleClassesInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.webcontainer.facade.ServletContextFacade;
import jakarta.faces.context.ExternalContext;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.spi.FaceletConfigResourceProvider;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class LibertyFaceletConfigResourceProvider
extends FaceletConfigResourceProvider {
    private static final String CLASS_NAME = LibertyFaceletConfigResourceProvider.class.getName();
    protected static final Logger logger = Logger.getLogger(CLASS_NAME);
    private static final String META_INF_PREFIX = "META-INF/";
    private static final String FACELET_TAGLIB_SUFFIX = ".taglib.xml";
    private FaceletConfigResourceProvider defaultProvider;
    static final long serialVersionUID = -560686074867071616L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public LibertyFaceletConfigResourceProvider() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsf.config.resource.LibertyFaceletConfigResourceProvider", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jsf.config.resource.LibertyFaceletConfigResourceProvider", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public LibertyFaceletConfigResourceProvider(FaceletConfigResourceProvider defaultProvider) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsf.config.resource.LibertyFaceletConfigResourceProvider", "<init>", new Object[]{defaultProvider});
        }
        this.defaultProvider = defaultProvider;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jsf.config.resource.LibertyFaceletConfigResourceProvider", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Collection<URL> getFaceletTagLibConfigurationResources(ExternalContext context) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsf.config.resource.LibertyFaceletConfigResourceProvider", "getFaceletTagLibConfigurationResources", new Object[]{context});
        }
        String method = "getFaceletTagLibConfigurationResources";
        Collection<URL> urlSet = null;
        boolean isOSGIApp = false;
        if (context.getApplicationMap().get("osgi-bundlecontext") != null) {
            isOSGIApp = true;
        }
        urlSet = this.defaultProvider.getFaceletTagLibConfigurationResources(context);
        if (isOSGIApp) {
            Object o = context.getContext();
            ServletContextFacade sc = null;
            if (o instanceof ServletContextFacade) {
                sc = (ServletContextFacade)o;
                Container c = sc.getIServletContext().getModuleContainer();
                if (c != null) {
                    urlSet = this.getFaceletTagLibConfigResourcesHelper(c, urlSet);
                }
            } else if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getFaceletTagLibConfigurationResources", "OSGI app without a Servlet Context");
            }
        }
        Collection<URL> collection = urlSet;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            collection = collection;
            logger.exiting("com.ibm.ws.jsf.config.resource.LibertyFaceletConfigResourceProvider", "getFaceletTagLibConfigurationResources", collection);
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Collection<URL> getFaceletTagLibConfigResourcesHelper(Container c, Collection<URL> urlSet) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsf.config.resource.LibertyFaceletConfigResourceProvider", "getFaceletTagLibConfigResourcesHelper", new Object[]{c, urlSet});
        }
        String method = "getFaceletTagLibConfigResourcesHelper";
        if (urlSet == null) {
            urlSet = new ArrayList<URL>();
        }
        try {
            ArrayList<Container> jarResourceContainers = new ArrayList<Container>();
            WebModuleClassesInfo classesInfo = (WebModuleClassesInfo)c.adapt(WebModuleClassesInfo.class);
            int numberOfJars = 0;
            if (classesInfo != null) {
                List containerInfos = classesInfo.getClassesContainers();
                for (ContainerInfo containerInfo : containerInfos) {
                    if (containerInfo.getType() != ContainerInfo.Type.WEB_INF_LIB) continue;
                    jarResourceContainers.add(containerInfo.getContainer());
                    ++numberOfJars;
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getFaceletTagLibConfigResourcesHelper", "Checking " + numberOfJars + " jars for META-INF/*.taglib.xml");
            }
            for (Container jarContainer : jarResourceContainers) {
                Entry metaInf = jarContainer.getEntry(META_INF_PREFIX);
                if (metaInf == null) continue;
                Container metaInfContainer = (Container)metaInf.adapt(Container.class);
                for (Entry entry : metaInfContainer) {
                    String name = entry.getName();
                    if (!name.endsWith(FACELET_TAGLIB_SUFFIX)) continue;
                    URL urlObject = entry.getResource();
                    urlSet.add(urlObject);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, CLASS_NAME, "getFaceletTagLibConfigResourcesHelper", "Adding " + urlObject.toString());
                }
            }
        }
        catch (UnableToAdaptException jarResourceContainers) {
            void e;
            FFDCFilter.processException((Throwable)jarResourceContainers, (String)"com.ibm.ws.jsf.config.resource.LibertyFaceletConfigResourceProvider", (String)"125", (Object)((Object)this), (Object[])new Object[]{c, urlSet});
            throw new IllegalStateException((Throwable)e);
        }
        Collection<URL> collection = urlSet;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            collection = collection;
            logger.exiting("com.ibm.ws.jsf.config.resource.LibertyFaceletConfigResourceProvider", "getFaceletTagLibConfigResourcesHelper", collection);
        }
        return collection;
    }
}

