/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@Trivial
public final class KeyBasedLockStore<Key, Lock> {
    private final ReferenceQueue<Lock> refQueue = new ReferenceQueue();
    private final ConcurrentHashMap<String, LockWeakRef> lockMap = new ConcurrentHashMap();
    private final Supplier<Lock> lockCreator;

    public KeyBasedLockStore(Supplier<Lock> lockCreator) {
        this.lockCreator = lockCreator;
    }

    public final Lock getLock(String key) {
        Lock lock;
        this.poll();
        LockWeakRef lockRef = this.lockMap.get(key);
        Lock Lock = lock = lockRef != null ? (Lock)lockRef.get() : null;
        if (lock != null) {
            return lock;
        }
        lock = this.lockCreator.get();
        LockWeakRef retVal;
        while ((retVal = this.lockMap.putIfAbsent(key, new LockWeakRef(lock, key))) != null) {
            Object retLock = retVal.get();
            if (retLock != null) {
                return (Lock)retLock;
            }
            this.lockMap.remove(key, retVal);
        }
        return lock;
    }

    private final void poll() {
        LockWeakRef lockRef;
        while ((lockRef = (LockWeakRef)this.refQueue.poll()) != null) {
            this.lockMap.remove(lockRef.key, lockRef);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private final class LockWeakRef
    extends WeakReference<Lock> {
        final String key;
        static final long serialVersionUID = 7190777989392354667L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public LockWeakRef(Lock referent, String keyValue) {
            super(referent, KeyBasedLockStore.this.refQueue);
            this.key = keyValue;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.KeyBasedLockStore$LockWeakRef", LockWeakRef.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    }
}

