/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.rest.handler.validator.openapi20;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.validator.Validator;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, service={RESTHandler.class}, property={"com.ibm.wsspi.rest.handler.context.root=/openapi/platform", "com.ibm.wsspi.rest.handler.context.root=/ibm/api/platform", "com.ibm.wsspi.rest.handler.root=/validation"})
public class ValidatorSchemaRESTHandler
implements RESTHandler {
    private static final TraceComponent tc = Tr.register(ValidatorSchemaRESTHandler.class, (String)"rest.validation", null);
    private ComponentContext context;
    static final long serialVersionUID = -7318615630209756831L;

    public final void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        if (!"GET".equals(request.getMethod())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Request method was " + request.getMethod() + " but the validation schema endpoint is restricted to GET requests only."), (Object[])new Object[0]);
            }
            response.setResponseHeader("Accept", "GET");
            response.sendError(405);
            return;
        }
        if (!ProductInfo.getBetaEdition() && request.getContextPath().contains("/ibm/api")) {
            response.setResponseHeader("Accept", "GET");
            response.sendError(404);
            return;
        }
        OpenAPI openAPI = this.getOpenAPIDocument(response);
        if (openAPI != null) {
            String formatParam;
            this.removeDisabledValidators(openAPI);
            String acceptHeader = request.getHeader("Accept");
            String format = "yaml";
            if (acceptHeader != null && acceptHeader.equals("application/json")) {
                format = "json";
            }
            if ((formatParam = request.getParameter("format")) != null && formatParam.equals("json")) {
                format = "json";
            }
            if (format.equals("json")) {
                response.setContentType("application/json");
                response.getWriter().write(OpenApiSerializer.serialize((OpenAPI)openAPI, (Format)Format.JSON));
            } else {
                response.setContentType("text/plain");
                response.getWriter().write(OpenApiSerializer.serialize((OpenAPI)openAPI, (Format)Format.YAML));
            }
        }
    }

    private OpenAPI getOpenAPIDocument(RESTResponse response) {
        OpenAPI openAPI = null;
        InputStream inputStream = ValidatorSchemaRESTHandler.class.getResourceAsStream("/META-INF/openapi.yaml");
        if (inputStream != null) {
            OpenApiStaticFile staticFile = new OpenApiStaticFile(inputStream, Format.YAML);
            openAPI = OpenApiProcessor.modelFromStaticFile((OpenApiStaticFile)staticFile);
            response.setCharacterEncoding("UTF-8");
            if (openAPI == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"Error retrieving openapi.yaml for config validation. Returning error code 500.", (Object[])new Object[0]);
                }
                response.setStatus(500);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Null inputStream for openapi.yaml. Return 500.", (Object[])new Object[0]);
            }
            response.setStatus(500);
        }
        return openAPI;
    }

    /*
     * WARNING - void declaration
     */
    private void removeDisabledValidators(OpenAPI openAPI) {
        boolean cloudantEnabled = false;
        boolean jcaEnabled = false;
        boolean jmsEnabled = false;
        boolean jdbcEnabled = false;
        try {
            cloudantEnabled = ValidatorSchemaRESTHandler.getServiceReferences(this.context.getBundleContext(), Validator.class, "(component.name=com.ibm.ws.rest.handler.validator.cloudant.CloudantDatabaseValidator)").iterator().hasNext();
            jcaEnabled = ValidatorSchemaRESTHandler.getServiceReferences(this.context.getBundleContext(), Validator.class, "(component.name=com.ibm.ws.rest.handler.validator.jca.ConnectionFactoryValidator)").iterator().hasNext();
            jdbcEnabled = ValidatorSchemaRESTHandler.getServiceReferences(this.context.getBundleContext(), Validator.class, "(component.name=com.ibm.ws.rest.handler.validator.jdbc.DataSourceValidator)").iterator().hasNext();
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            void e;
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"io.openliberty.rest.handler.validator.openapi20.ValidatorSchemaRESTHandler", (String)"143", (Object)this, (Object[])new Object[]{openAPI});
            e.printStackTrace();
        }
        if (jcaEnabled) {
            jmsEnabled = this.isJMSValidatorEnabled();
        }
        if (!cloudantEnabled) {
            openAPI.getPaths().removePathItem("/validation/cloudantDatabase/");
            openAPI.getPaths().removePathItem("/validation/cloudantDatabase/{uid}");
            openAPI.getComponents().removeSchema("validation.cloudantDatabase.result");
        }
        if (!jcaEnabled) {
            openAPI.getPaths().removePathItem("/validation/connectionFactory/");
            openAPI.getPaths().removePathItem("/validation/connectionFactory/{uid}");
            openAPI.getComponents().removeSchema("validation.connectionFactory.result");
        }
        if (!jmsEnabled) {
            openAPI.getPaths().removePathItem("/validation/jmsConnectionFactory/");
            openAPI.getPaths().removePathItem("/validation/jmsConnectionFactory/{uid}");
            openAPI.getPaths().removePathItem("/validation/jmsQueueConnectionFactory/");
            openAPI.getPaths().removePathItem("/validation/jmsQueueConnectionFactory/{uid}");
            openAPI.getPaths().removePathItem("/validation/jmsTopicConnectionFactory/");
            openAPI.getPaths().removePathItem("/validation/jmsTopicConnectionFactory/{uid}");
            openAPI.getComponents().removeSchema("validation.jms.result");
        }
        if (!jdbcEnabled) {
            openAPI.getPaths().removePathItem("/validation/dataSource/");
            openAPI.getPaths().removePathItem("/validation/dataSource/{uid}");
            openAPI.getComponents().removeSchema("validation.dataSource.result");
        }
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    public static <S> Collection<ServiceReference<S>> getServiceReferences(BundleContext bCtx, Class<S> clazz, String filter) throws InvalidSyntaxException {
        if (System.getSecurityManager() == null) {
            return bCtx.getServiceReferences(clazz, filter);
        }
        try {
            return AccessController.doPrivileged(() -> bCtx.getServiceReferences(clazz, filter));
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof InvalidSyntaxException) {
                throw (InvalidSyntaxException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.context = context;
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.context = null;
    }

    private boolean isJMSValidatorEnabled() {
        Class jmsClass = AccessController.doPrivileged(() -> {
            try {
                return this.getClass().getClassLoader().loadClass("jakarta.jms.ConnectionFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    return this.getClass().getClassLoader().loadClass("jakarta.jms.ConnectionFactory");
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    return null;
                }
            }
        });
        return jmsClass != null;
    }
}

