/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.richclient.framework.impl;

import com.ibm.websphere.channelfw.CFEndPoint;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.messaging.lifecycle.SingletonsReady;
import com.ibm.ws.sib.jfapchannel.framework.FrameworkException;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionFactory;
import com.ibm.ws.sib.jfapchannel.framework.NetworkTransportFactory;
import com.ibm.ws.sib.jfapchannel.impl.CommsClientServiceFacade;
import com.ibm.ws.sib.jfapchannel.richclient.framework.impl.CFWNetworkConnectionFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.VirtualConnectionFactory;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;

public class RichClientTransportFactory
implements NetworkTransportFactory {
    private static final TraceComponent tc = SibTr.register(RichClientTransportFactory.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final String CLASS_NAME = RichClientTransportFactory.class.getName();
    private ChannelFramework channelFramework = null;

    public RichClientTransportFactory(ChannelFramework channelFramework) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)channelFramework);
        }
        this.channelFramework = channelFramework;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public NetworkConnectionFactory getOutboundNetworkConnectionFactoryByName(String chainName) throws FrameworkException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getOutboundNetworkConnectionFactoryByName", (Object)chainName);
        }
        CFWNetworkConnectionFactory connFactory = null;
        try {
            VirtualConnectionFactory vcFactory = ((CommsClientServiceFacade)SingletonsReady.requireService(CommsClientServiceFacade.class)).getChannelFramework().getOutboundVCFactory(chainName);
            connFactory = new CFWNetworkConnectionFactory(vcFactory);
        }
        catch (ChannelException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getOutboundNetworkConnectionFactoryByName"), (String)"00280001", (Object[])new Object[]{this, chainName});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Failure to obtain OVC for Outbound chain" + chainName), (Object)((Object)e));
            }
            throw new FrameworkException(e);
        }
        catch (ChainException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getOutboundNetworkConnectionFactoryByName"), (String)"00280001", (Object[])new Object[]{this, chainName});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Failure to obtain OVC for Outbound chain" + chainName), (Object)((Object)e));
            }
            throw new FrameworkException(e);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getOutboundNetworkConnectionFactoryByName", (Object)connFactory);
        }
        return connFactory;
    }

    @Override
    public NetworkConnectionFactory getOutboundNetworkConnectionFactoryFromEndPoint(Object endPoint) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getOutboundNetworkConnectionFactoryFromEndPoint", (Object)endPoint);
        }
        CFWNetworkConnectionFactory connFactory = null;
        if (endPoint instanceof CFEndPoint) {
            VirtualConnectionFactory vcFactory = ((CFEndPoint)endPoint).getOutboundVCFactory();
            connFactory = new CFWNetworkConnectionFactory(vcFactory);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getOutboundNetworkConnectionFactoryFromEndPoint", connFactory);
        }
        return connFactory;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/jfapchannel/framework/impl/RichClientTransportFactory.java, SIB.comms, WASX.SIB, uu1215.01 1.1");
        }
    }
}

