/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.messaging.lifecycle.SingletonsReady;
import com.ibm.ws.sib.jfapchannel.ClientConnectionManager;
import com.ibm.ws.sib.jfapchannel.impl.CommsClientServiceFacade;
import com.ibm.ws.sib.jfapchannel.impl.OutboundSecureFacet;
import com.ibm.ws.sib.jfapchannel.impl.octracker.OutboundConnectionTracker;
import com.ibm.ws.sib.jfapchannel.richclient.impl.JFapChannelFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.application.lifecycle.ApplicationPrereq;
import com.ibm.wsspi.channelfw.ChannelConfiguration;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.ibm.ws.messaging.comms.wasJmsOutbound"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class CommsOutboundChain
implements ApplicationPrereq {
    private static final TraceComponent tc = Tr.register(CommsOutboundChain.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final String OUTBOUND_CHAIN_CONFIG_ALIAS = "wasJmsOutbound";
    private final ChannelConfiguration tcpOptions;
    private final CommsClientServiceFacade commsClientService;
    private final String chainName;
    private final String tcpChannelName;
    private final String jfapChannelName;
    private final String sslChannelName;
    private OutboundSecureFacet secureFacet;
    private final boolean isSecureChain;

    @Activate
    public CommsOutboundChain(@Reference(name="tcpOptions", target="(id=unbound)") ChannelConfiguration tcpOptions, @Reference(name="commsClientService") CommsClientServiceFacade commsClientService, @Reference(name="singletonsReady") SingletonsReady singletonsReady, Map<Object, Object> properties) {
        String id;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{tcpOptions, commsClientService, properties});
        }
        this.tcpOptions = tcpOptions;
        this.commsClientService = commsClientService;
        this.isSecureChain = MetatypeUtils.parseBoolean((Object)OUTBOUND_CHAIN_CONFIG_ALIAS, (String)"useSSL", (Object)properties.get("useSSL"), (boolean)false);
        this.chainName = id = (String)properties.get("id");
        this.tcpChannelName = id + "_JfapTcp";
        this.sslChannelName = id + "_JfapSsl";
        this.jfapChannelName = id + "_JfapJfap";
        if (this.isSecureChain) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"CommsOutboundChain: Deferring secure chain startup until SSL configuration is available", (Object)this.chainName);
            }
        } else {
            this.createBasicJFAPChain();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Reference(name="secureFacet", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="unbindSecureFacet")
    void bindSecureFacet(OutboundSecureFacet newFacet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"bindSecureFacet", (Object)newFacet);
        }
        if (this.isSecureChain) {
            this.terminateConnectionsAssociatedWithChain(TerminationContext.BIND, null, newFacet);
            this.createSecureJFAPChain(newFacet);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Ignoring SecureFacet bind because useSSL was false");
        }
    }

    void unbindSecureFacet(OutboundSecureFacet oldFacet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unbindSecureFacet", (Object)oldFacet);
        }
        if (this.isSecureChain) {
            this.terminateConnectionsAssociatedWithChain(TerminationContext.UNBIND, oldFacet, null);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Ignoring SecureFacet unbind because useSSL was false");
        }
    }

    private Map<String, Object> getTcpOptions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getTcpOptions", (Object[])new Object[0]);
        }
        Map tcpProps = this.tcpOptions.getConfiguration();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getTcpOptions", (Object)tcpProps);
        }
        return tcpProps;
    }

    private synchronized void createBasicJFAPChain() {
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"createBasicJFAPChain", (Object)this.chainName);
            }
            try {
                ChannelData jfapChannel;
                ChannelFramework cfw = this.commsClientService.getChannelFramework();
                cfw.registerFactory("JFapChannelOutbound", JFapChannelFactory.class);
                Map<String, Object> tcpOptions = this.getTcpOptions();
                ChannelData tcpChannel = cfw.getChannel(this.tcpChannelName);
                if (tcpChannel == null) {
                    String typeName = (String)tcpOptions.get("type");
                    tcpChannel = cfw.addChannel(this.tcpChannelName, cfw.lookupFactory(typeName), new HashMap<String, Object>(tcpOptions));
                }
                if ((jfapChannel = cfw.getChannel(this.jfapChannelName)) == null) {
                    jfapChannel = cfw.addChannel(this.jfapChannelName, cfw.lookupFactory("JFapChannelOutbound"), null);
                }
                String[] chanList = new String[]{this.jfapChannelName, this.tcpChannelName};
                ChainData cd = cfw.addChain(this.chainName, FlowType.OUTBOUND, chanList);
                cd.setEnabled(true);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("JFAP Outbound chain" + this.chainName + " successfully started "));
                }
            }
            catch (ChainException | ChannelException exception) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("JFAP Outbound chain " + this.chainName + " failed to start, exception =" + exception));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createBasicJFAPChain");
        }
    }

    private synchronized void createSecureJFAPChain(OutboundSecureFacet secureFacet) {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"createSecureJFAPChain", (Object)this.chainName);
            }
            try {
                ChannelData jfapChannel;
                ChannelFramework cfw = this.commsClientService.getChannelFramework();
                cfw.registerFactory("JFapChannelOutbound", JFapChannelFactory.class);
                Map<String, Object> tcpOptions = this.getTcpOptions();
                ChannelData tcpChannel = cfw.getChannel(this.tcpChannelName);
                if (tcpChannel == null) {
                    String typeName = (String)tcpOptions.get("type");
                    tcpChannel = cfw.addChannel(this.tcpChannelName, cfw.lookupFactory(typeName), new HashMap<String, Object>(tcpOptions));
                }
                if (null == secureFacet) {
                    throw new ChainException(new Throwable(nls.getFormattedMessage("missingSslOptions.ChainNotStarted", new Object[]{this.chainName}, "Chain not started " + this.chainName)));
                }
                ChannelData sslChannel = cfw.getChannel(this.sslChannelName);
                if (sslChannel == null) {
                    sslChannel = cfw.addChannel(this.sslChannelName, cfw.lookupFactory("SSLChannel"), secureFacet.copyConfig());
                }
                if ((jfapChannel = cfw.getChannel(this.jfapChannelName)) == null) {
                    jfapChannel = cfw.addChannel(this.jfapChannelName, cfw.lookupFactory("JFapChannelOutbound"), null);
                }
                String[] chanList = new String[]{this.jfapChannelName, this.sslChannelName, this.tcpChannelName};
                ChainData cd = cfw.addChain(this.chainName, FlowType.OUTBOUND, chanList);
                cd.setEnabled(true);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("JFAP Outbound secure chain" + this.chainName + " successfully started "));
                }
            }
            catch (ChainException | ChannelException exception) {
                FFDCFilter.processException((Throwable)exception, (String)("CommsOutboundChain.createSecureJFAPChain for chain " + this.chainName), (String)this.jfapChannelName, (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("JFAP Outbound secure chain " + this.chainName + " failed to start, exception =" + exception));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createSecureJFAPChain");
        }
    }

    @Deactivate
    protected void deactivate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deactivate");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("CommsOutboundChain: Destroying " + (this.isSecureChain ? "Secure" : "Non-Secure") + " chain "), (Object)this.chainName);
        }
        this.terminateConnectionsAssociatedWithChain(TerminationContext.DEACTIVATE, null, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"deactivate");
        }
    }

    private synchronized void terminateConnectionsAssociatedWithChain(TerminationContext caller, OutboundSecureFacet oldFacet, OutboundSecureFacet newFacet) {
        block18: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"terminateConnectionsAssociatedWithChain", (Object[])new Object[]{this.chainName, caller, oldFacet, newFacet, this.secureFacet});
            }
            assert (TerminationContext.DEACTIVATE == caller || this.isSecureChain);
            assert (TerminationContext.UNBIND == caller || oldFacet == null);
            assert (TerminationContext.BIND == caller || newFacet == null);
            if (this.isSecureChain) {
                boolean alreadyTerminated;
                if (caller == TerminationContext.UNBIND) {
                    if (oldFacet == this.secureFacet) {
                        this.secureFacet = null;
                        alreadyTerminated = false;
                    } else {
                        alreadyTerminated = true;
                    }
                } else {
                    alreadyTerminated = null == this.secureFacet;
                    this.secureFacet = newFacet;
                }
                if (alreadyTerminated) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Already terminated chain - returning early");
                    }
                    return;
                }
            }
            try {
                ChainData cd;
                ChannelFramework cfw = this.commsClientService.getChannelFramework();
                OutboundConnectionTracker oct = ClientConnectionManager.getRef().getOutboundConnectionTracker();
                if (null != oct) {
                    oct.terminateConnectionsAssociatedWithChain(this.chainName);
                }
                if (null != cfw.getChain(this.chainName)) {
                    cfw.getOutboundVCFactory(this.chainName).destroy();
                }
                if (null != (cd = cfw.getChain(this.chainName))) {
                    cfw.removeChain(cd);
                }
            }
            catch (Exception exception) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block18;
                SibTr.debug((TraceComponent)tc, (String)("Failure in terminating conversations and physical connections while destroying chain : " + this.chainName), (Object)exception);
            }
        }
        this.removeChannel(this.tcpChannelName);
        if (this.isSecureChain) {
            this.removeChannel(this.sslChannelName);
        }
        this.removeChannel(this.jfapChannelName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"terminateConnectionsAssociatedWithChain");
        }
    }

    private void removeChannel(String channelName) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeChannel", (Object)channelName);
            }
            ChannelFramework cfw = this.commsClientService.getChannelFramework();
            try {
                if (cfw.getChannel(channelName) != null) {
                    cfw.removeChannel(channelName);
                }
            }
            catch (ChainException | ChannelException exception) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Error removing channel:" + channelName), (Object)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeChannel");
        }
    }

    public String getApplicationPrereqID() {
        return this.chainName;
    }

    static enum TerminationContext {
        BIND,
        UNBIND,
        DEACTIVATE;

    }
}

