/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mail.internal.injection;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceFactory;
import com.ibm.ws.resource.ResourceFactoryBuilder;
import com.ibm.ws.resource.ResourceRefInfo;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import io.openliberty.mail.internal.injection.MailSessionResourceFactory;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ResourceFactoryBuilder.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "creates.objectClass=jakarta.mail.Session"})
public class MailSessionResourceFactoryBuilder
implements ResourceFactoryBuilder {
    private static final TraceComponent tc = Tr.register(MailSessionResourceFactoryBuilder.class, (String)"Mail", (String)"io.openliberty.jakarta.mail.resources.MailMessages");
    private static final String ID = "id";
    private BundleContext bundleContext;
    static final long serialVersionUID = -4891102609622009446L;

    protected void activate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{context});
        }
        this.bundleContext = context.getBundleContext();
    }

    public ResourceFactory createResourceFactory(Map<String, Object> props) throws Exception {
        Hashtable<String, Object> mailSessionSvcProps = new Hashtable<String, Object>();
        HashMap<String, Object> annotationProps = new HashMap<String, Object>();
        for (Map.Entry<String, Object> prop : props.entrySet()) {
            Object value = prop.getValue();
            annotationProps.put(prop.getKey(), value);
        }
        String application = (String)annotationProps.remove("application");
        String module = (String)annotationProps.remove("module");
        String component = (String)annotationProps.remove("component");
        String jndiName = (String)annotationProps.remove("jndiName");
        String mailSessionID = MailSessionResourceFactoryBuilder.getMailSessionID(application, module, component, jndiName);
        StringBuilder filter = new StringBuilder(FilterUtils.createPropertyFilter((String)ID, (String)mailSessionID));
        filter.insert(filter.length() - 1, '*');
        if (!this.removeExistingConfigurations(filter.toString())) {
            throw new IllegalArgumentException(mailSessionID);
        }
        mailSessionSvcProps.put("jndiName", jndiName);
        mailSessionSvcProps.put("mailSessionID", mailSessionID);
        if (application != null) {
            mailSessionSvcProps.put("application", application);
            if (module != null) {
                mailSessionSvcProps.put("module", module);
                if (component != null) {
                    mailSessionSvcProps.put("component", component);
                }
            }
        }
        if (!annotationProps.isEmpty()) {
            Set annotationKeys = annotationProps.keySet();
            for (String key : annotationKeys) {
                mailSessionSvcProps.put(key, annotationProps.get(key));
            }
        }
        MailSessionResourceFactory mss = new MailSessionResourceFactory();
        mss.processProperties(mailSessionSvcProps);
        mss.createResource((ResourceRefInfo)null);
        return mss;
    }

    protected void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"deactivate", (Object[])new Object[]{context});
        }
    }

    private static final String getMailSessionID(String application, String module, String component, String jndiName) {
        StringBuilder sb = new StringBuilder(jndiName.length() + 80);
        if (application != null) {
            sb.append("application").append('[').append(application).append(']').append('/');
            if (module != null) {
                sb.append("module").append('[').append(module).append(']').append('/');
                if (component != null) {
                    sb.append("component").append('[').append(component).append(']').append('/');
                }
            }
        }
        return sb.append("mailSessionID").append('[').append(jndiName).append(']').toString();
    }

    public final boolean removeExistingConfigurations(String filter) throws Exception {
        return true;
    }
}

