/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.CMConfigData;
import com.ibm.ejs.j2c.CMConfigDataImpl;
import com.ibm.ejs.j2c.CommonFunction;
import com.ibm.ejs.j2c.ConnectionManager;
import com.ibm.ejs.j2c.EmbXAResourceInfo;
import com.ibm.ejs.j2c.J2CGlobalConfigProperties;
import com.ibm.ejs.j2c.PoolManager;
import com.ibm.ejs.j2c.PoolManagerMBeanImpl;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.adapter.PurgePolicy;
import com.ibm.ws.jca.cm.AbstractConnectionFactoryService;
import com.ibm.ws.jca.cm.ConnectionManagerService;
import com.ibm.ws.jca.cm.ConnectorService;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import com.ibm.wsspi.resource.ResourceInfo;
import jakarta.resource.ResourceException;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MalformedObjectNameException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.ComponentContext;

public class ConnectionManagerServiceImpl
extends ConnectionManagerService {
    private static final TraceComponent tc = Tr.register(ConnectionManagerServiceImpl.class, (String)"WAS.j2c", (String)"com.ibm.ws.jca.cm.internal.resources.J2CAMessages");
    static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    private final Map<String, ConnectionManager> cfKeyToCM = new ConcurrentHashMap<String, ConnectionManager>();
    private ConnectorService connectorSvc;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private String name;
    private PoolManager pm;
    private PoolManagerMBeanImpl pmMBean = null;
    private Map<String, Object> properties;
    BundleContext bndCtx = null;
    private ClassLoader raClassLoader = null;
    private boolean disableLibertyConnectionPool;

    public ConnectionManagerServiceImpl() {
    }

    public ConnectionManagerServiceImpl(String name) {
        this.name = name + '/' + "connectionManager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{properties});
        }
        this.bndCtx = priv.getBundleContext(context);
        this.name = (String)properties.get("config.displayId");
        this.lock.writeLock().lock();
        try {
            this.properties = properties;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if ("file".equals(properties.get("config.source")) && this.name.startsWith("#APP-RESOURCE#")) {
            throw new IllegalArgumentException(ConnectorService.getMessage("UNSUPPORTED_VALUE_J2CA8011", this.name, "id", "connectionManager"));
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"activate");
        }
    }

    @Override
    public void addObserver(Observer observer) {
        super.addObserver(observer);
        if (this.countObservers() > 1) {
            super.deleteObserver(observer);
            AbstractConnectionFactoryService cfSvc = (AbstractConnectionFactoryService)observer;
            Object[] params = new Object[]{"connectionManager", this.name, cfSvc.getConfigElementName()};
            RuntimeException failure = this.connectorSvc.ignoreWarnOrFail(tc, null, UnsupportedOperationException.class, "CARDINALITY_ERROR_J2CA8040", params);
            if (failure != null) {
                throw failure;
            }
        }
    }

    private void createPoolManager(AbstractConnectionFactoryService svc) throws ResourceException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"createPoolManager", (Object[])new Object[]{svc, this.properties});
        }
        J2CGlobalConfigProperties gConfigProps = this.processServerPoolManagerProperties(svc, this.properties);
        this.pm = new PoolManager(svc, null, gConfigProps, this.raClassLoader);
        if (this.bndCtx == null) {
            this.bndCtx = priv.getBundleContext(FrameworkUtil.getBundle(this.getClass()));
        }
        try {
            this.pmMBean = new PoolManagerMBeanImpl(this.pm, svc.getFeatureVersion());
            this.pmMBean.register(this.bndCtx);
        }
        catch (MalformedObjectNameException e) {
            this.pmMBean = null;
            throw new ResourceException((Throwable)e);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createPoolManager", (Object)this);
        }
    }

    protected void deactivate(ComponentContext context) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"deactivate", (Object[])new Object[]{this.name});
        }
        this.lock.writeLock().lock();
        try {
            if (this.pmMBean != null) {
                this.pmMBean.unregister();
                this.pmMBean = null;
            }
            this.pm = null;
            this.properties = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"deactivate");
        }
    }

    @Override
    public void destroyConnectionFactories() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            String pmName = this.pm != null ? this.pm.getUniqueId() : "factory name not avaiable";
            Tr.entry((Object)this, (TraceComponent)tc, (String)"destroyConnectionFactories", (Object[])new Object[]{pmName});
        }
        this.lock.writeLock().lock();
        try {
            if (this.pmMBean != null) {
                this.pmMBean.unregister();
                this.pmMBean = null;
            }
            if (this.pm != null) {
                try {
                    this.pm.serverShutDown();
                    this.pm = null;
                    this.cfKeyToCM.clear();
                }
                catch (Throwable x) {
                    FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"263", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)x.getMessage(), (Object[])new Object[]{CommonFunction.stackTraceToString(x)});
                    }
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"destroyConnectionFactories");
        }
    }

    private final CMConfigData getCMConfigData(AbstractConnectionFactoryService cfSvc, ResourceInfo refInfo) {
        int sharingScope;
        int auth;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getCMConfigData", (Object[])new Object[0]);
        }
        int branchCoupling = -1;
        int commitPriority = 0;
        int isolation = 0;
        String loginConfigName = null;
        Map<String, String> loginConfigProps = Collections.emptyMap();
        String resRefName = null;
        if (refInfo != null) {
            auth = refInfo.getAuth() == 0 ? 0 : 1;
            branchCoupling = refInfo.getBranchCoupling();
            commitPriority = refInfo.getCommitPriority();
            isolation = refInfo.getIsolationLevel();
            loginConfigName = refInfo.getLoginConfigurationName();
            loginConfigProps = ConnectionManagerServiceImpl.toHashMap(refInfo.getLoginPropertyList());
            resRefName = refInfo.getName();
            sharingScope = refInfo.getSharingScope();
        } else if (this.properties != null) {
            Object enableSharingForDirectLookups = this.properties.get("enableSharingForDirectLookups");
            sharingScope = enableSharingForDirectLookups == null || Boolean.TRUE.equals(enableSharingForDirectLookups) || enableSharingForDirectLookups instanceof String && Boolean.parseBoolean((String)enableSharingForDirectLookups) ? 0 : 1;
            Object enableContainerAuthForDirectLookups = this.properties.get("enableContainerAuthForDirectLookups");
            auth = enableContainerAuthForDirectLookups == null || Boolean.FALSE.equals(enableContainerAuthForDirectLookups) || enableContainerAuthForDirectLookups instanceof String && !Boolean.parseBoolean((String)enableContainerAuthForDirectLookups) ? 1 : 0;
        } else {
            sharingScope = 0;
            auth = 1;
        }
        CMConfigDataImpl cmConfig = new CMConfigDataImpl(cfSvc.getJNDIName(), sharingScope, isolation, auth, cfSvc.getID(), loginConfigName, loginConfigProps, resRefName, commitPriority, branchCoupling, null);
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getCMConfigData", (Object)cmConfig);
        }
        return cmConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionManager getConnectionManager(ResourceInfo refInfo, AbstractConnectionFactoryService svc) throws ResourceException {
        ConnectionManager cm;
        boolean trace;
        block15: {
            trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"getConnectionManager", (Object[])new Object[]{refInfo, svc});
            }
            this.lock.readLock().lock();
            try {
                CMConfigData cmConfigData;
                String cfDetailsKey;
                if (this.pm == null) {
                    try {
                        this.lock.readLock().unlock();
                        this.lock.writeLock().lock();
                        if (this.pm == null) {
                            this.createPoolManager(svc);
                        }
                    }
                    finally {
                        this.lock.readLock().lock();
                        this.lock.writeLock().unlock();
                    }
                }
                if ((cm = this.cfKeyToCM.get(cfDetailsKey = (cmConfigData = this.getCMConfigData(svc, refInfo)).getCFDetailsKey())) != null) break block15;
                EmbXAResourceInfo xaResInfo = new EmbXAResourceInfo(cmConfigData);
                J2CGlobalConfigProperties gConfigProps = this.pm.getGConfigProps();
                ConnectionManagerServiceImpl connectionManagerServiceImpl = this;
                synchronized (connectionManagerServiceImpl) {
                    cm = this.cfKeyToCM.get(cfDetailsKey);
                    if (cm == null) {
                        cm = new ConnectionManager(svc, this.pm, gConfigProps, xaResInfo);
                        this.cfKeyToCM.put(cfDetailsKey, cm);
                    }
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getConnectionManager", (Object)cm);
        }
        return cm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modified(Map<String, Object> newProperties) throws Exception {
        boolean trace;
        block15: {
            boolean reCreateNeeded;
            block14: {
                trace = TraceComponent.isAnyTracingEnabled();
                if (trace && tc.isEntryEnabled()) {
                    Tr.entry((Object)this, (TraceComponent)tc, (String)"modified", (Object[])new Object[]{newProperties});
                }
                reCreateNeeded = false;
                this.lock.writeLock().lock();
                try {
                    this.properties = newProperties;
                    if (this.pm == null) break block14;
                    try {
                        this.processServerPoolManagerProperties(null, newProperties);
                    }
                    catch (IllegalStateException e1) {
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"modify failed, retrying", (Object[])new Object[]{CommonFunction.stackTraceToString(e1)});
                        }
                        try {
                            this.processServerPoolManagerProperties(null, newProperties);
                        }
                        catch (IllegalStateException e2) {
                            reCreateNeeded = true;
                            if (trace && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"retry failed", (Object[])new Object[]{CommonFunction.stackTraceToString(e2)});
                            }
                        }
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            if (reCreateNeeded) {
                try {
                    this.setChanged();
                    this.notifyObservers();
                }
                catch (Throwable x) {
                    FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"402", (Object)this);
                    if (!trace || !tc.isDebugEnabled()) break block15;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)x.getMessage(), (Object[])new Object[]{CommonFunction.stackTraceToString(x)});
                }
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"modified");
        }
    }

    private J2CGlobalConfigProperties processServerPoolManagerProperties(AbstractConnectionFactoryService svc, Map<String, Object> properties) throws ResourceException {
        int numConnectionsPerThreadLocal;
        int maxNumberOfMCsAllowableInThread;
        int reapTime;
        PurgePolicy purgePolicy;
        int minPoolSize;
        int maxPoolSize;
        int maxIdleTime;
        int connectionTimeout;
        int agedTimeout;
        boolean autoCloseConnections;
        Object value;
        Map<Object, Object> map;
        Map<Object, Object> map2 = map = properties == null ? Collections.EMPTY_MAP : new HashMap<String, Object>(properties);
        if (svc != null) {
            this.disableLibertyConnectionPool = svc.isLibertyConnectionPoolingDisabled();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Setting disableLibertyConnectionManager to " + this.disableLibertyConnectionPool), (Object[])new Object[0]);
            }
        }
        boolean bl = (value = map.remove("autoCloseConnections")) == null || (value instanceof Boolean ? (Boolean)value != false : Boolean.parseBoolean((String)value)) ? true : (autoCloseConnections = false);
        if (this.disableLibertyConnectionPool) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Overriding config with values for a disabled connection pool.", (Object[])new Object[0]);
            }
            agedTimeout = 0;
            connectionTimeout = -1;
            maxIdleTime = -1;
            maxPoolSize = 0;
            minPoolSize = 0;
            purgePolicy = PurgePolicy.FailingConnectionOnly;
            reapTime = -1;
            maxNumberOfMCsAllowableInThread = 0;
            numConnectionsPerThreadLocal = 0;
        } else {
            agedTimeout = this.validateProperty((Map<String, Object>)map, "agedTimeout", -1, TimeUnit.SECONDS, -1, Integer.MAX_VALUE, true, this.connectorSvc);
            connectionTimeout = this.validateProperty((Map<String, Object>)map, "connectionTimeout", 30, TimeUnit.SECONDS, -1, Integer.MAX_VALUE, true, this.connectorSvc);
            maxIdleTime = this.validateProperty((Map<String, Object>)map, "maxIdleTime", 1800, TimeUnit.SECONDS, -1, Integer.MAX_VALUE, false, this.connectorSvc);
            maxNumberOfMCsAllowableInThread = this.validateProperty((Map<String, Object>)map, "maxConnectionsPerThread", 0, null, 0, Integer.MAX_VALUE, true, this.connectorSvc);
            maxPoolSize = this.validateProperty((Map<String, Object>)map, "maxPoolSize", 50, null, 0, Integer.MAX_VALUE, true, this.connectorSvc);
            minPoolSize = 0;
            minPoolSize = maxPoolSize == 0 ? this.validateProperty((Map<String, Object>)map, "minPoolSize", 0, null, 0, Integer.MAX_VALUE, true, this.connectorSvc) : this.validateProperty((Map<String, Object>)map, "minPoolSize", 0, null, 0, maxPoolSize, true, this.connectorSvc);
            numConnectionsPerThreadLocal = this.validateProperty((Map<String, Object>)map, "numConnectionsPerThreadLocal", 0, null, 0, Integer.MAX_VALUE, true, this.connectorSvc);
            reapTime = this.validateProperty((Map<String, Object>)map, "reapTime", 180, TimeUnit.SECONDS, -1, Integer.MAX_VALUE, false, this.connectorSvc);
            purgePolicy = ConnectionManagerServiceImpl.validateProperty((Map<String, Object>)map, "purgePolicy", PurgePolicy.EntirePool, PurgePolicy.class, this.connectorSvc);
        }
        value = map.remove("temporarilyAssociateIfDissociateUnavailable");
        boolean temporarilyAssociateIfDissociateUnavailable = value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean((String)value);
        boolean throwExceptionOnMCThreadCheck = false;
        if (this.pm != null) {
            if (this.pm.gConfigProps.getAgedTimeout() != agedTimeout) {
                this.pm.gConfigProps.setAgedTimeout(agedTimeout);
            }
            if (this.pm.gConfigProps.getAutoCloseConnections() != autoCloseConnections) {
                this.pm.gConfigProps.setAutoCloseConnections(autoCloseConnections);
            }
            if (this.pm.gConfigProps.getConnctionWaitTime() != connectionTimeout) {
                this.pm.gConfigProps.setConnectionTimeout(connectionTimeout);
            }
            if (this.pm.gConfigProps.getUnusedTimeout() != maxIdleTime) {
                this.pm.gConfigProps.setUnusedTimeout(maxIdleTime);
            }
            if (this.pm.gConfigProps.getMaxConnections() != maxPoolSize) {
                this.pm.gConfigProps.setMaxConnections(maxPoolSize);
            }
            if (this.pm.gConfigProps.getMinConnections() != minPoolSize) {
                this.pm.gConfigProps.setMinConnections(minPoolSize);
            }
            if (!this.pm.gConfigProps.getPurgePolicy().equals((Object)purgePolicy)) {
                this.pm.gConfigProps.setPurgePolicy(purgePolicy);
            }
            if (this.pm.gConfigProps.getReapTime() != reapTime) {
                this.pm.gConfigProps.setReapTime(reapTime);
            }
            if (this.pm.gConfigProps.getnumConnectionsPerThreadLocal() != numConnectionsPerThreadLocal) {
                this.pm.gConfigProps.setnumConnectionsPerThreadLocal(numConnectionsPerThreadLocal);
            }
            if (this.pm.gConfigProps.getMaxNumberOfMCsAllowableInThread() != maxNumberOfMCsAllowableInThread) {
                this.pm.gConfigProps.setMaxNumberOfMCsAllowableInThread(maxNumberOfMCsAllowableInThread);
            }
            if (this.pm.gConfigProps.getParkIfDissociateUnavailable() != temporarilyAssociateIfDissociateUnavailable) {
                this.pm.gConfigProps.setParkIfDissociateUnavailable(temporarilyAssociateIfDissociateUnavailable);
            }
            return null;
        }
        return new J2CGlobalConfigProperties(this.name, svc, false, 200, 100, false, connectionTimeout, maxPoolSize, minPoolSize, purgePolicy, reapTime, maxIdleTime, agedTimeout, 10, 0, autoCloseConnections, numConnectionsPerThreadLocal, maxNumberOfMCsAllowableInThread, temporarilyAssociateIfDissociateUnavailable, throwExceptionOnMCThreadCheck);
    }

    protected void setConnectorService(ConnectorService svc) {
        this.connectorSvc = svc;
    }

    protected void unsetConnectorService(ConnectorService svc) {
        this.connectorSvc = null;
    }

    private int validateProperty(Map<String, Object> map, String propName, int defaultVal, TimeUnit units, Integer minVal, Integer maxVal, Boolean immediateSupported, ConnectorService connectorSvc) throws ResourceException {
        ResourceException immediateFailure;
        long val;
        Object value = map.remove(propName);
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof Number) {
            val = ((Number)value).longValue();
        } else {
            try {
                val = units == null ? (long)Integer.parseInt((String)value) : MetatypeUtils.evaluateDuration((String)((String)value), (TimeUnit)units);
            }
            catch (Exception x) {
                ResourceException resX = connectorSvc.ignoreWarnOrFail(tc, x, ResourceException.class, "UNSUPPORTED_VALUE_J2CA8011", value, propName, this.name);
                if (resX == null) {
                    return defaultVal;
                }
                throw resX;
            }
        }
        if (!immediateSupported.booleanValue() && val == 0L && (immediateFailure = connectorSvc.ignoreWarnOrFail(tc, null, ResourceException.class, "UNSUPPORTED_VALUE_J2CA8011", val, propName, "connectionManager")) != null) {
            throw immediateFailure;
        }
        if (val < (long)minVal.intValue() || val > (long)maxVal.intValue()) {
            ResourceException failure = connectorSvc.ignoreWarnOrFail(tc, null, ResourceException.class, "UNSUPPORTED_VALUE_J2CA8011", val, propName, "connectionManager");
            if (failure != null) {
                throw failure;
            }
            return defaultVal;
        }
        return (int)val;
    }

    private static final <E extends Enum<E>> E validateProperty(Map<String, Object> map, String propName, E defaultVal, Class<E> type, ConnectorService connectorSvc) {
        String strVal = (String)map.remove(propName);
        if (strVal == null) {
            return defaultVal;
        }
        try {
            return Enum.valueOf(type, strVal);
        }
        catch (RuntimeException x) {
            x = (RuntimeException)connectorSvc.ignoreWarnOrFail(tc, x, x.getClass(), "UNSUPPORTED_VALUE_J2CA8011", strVal, propName, "connectionManager");
            if (x == null) {
                return defaultVal;
            }
            throw x;
        }
    }

    private static final HashMap<String, String> toHashMap(List<? extends ResourceInfo.Property> propList) {
        if (propList == null) {
            return null;
        }
        HashMap<String, String> propMap = new HashMap<String, String>();
        for (ResourceInfo.Property property : propList) {
            propMap.put(property.getName(), property.getValue());
        }
        return propMap;
    }

    @Override
    public void addRaClassLoader(ClassLoader raClassLoader) {
        this.raClassLoader = raClassLoader;
    }
}

