/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import jakarta.faces.context.ExternalContext;
import jakarta.servlet.ServletContext;
import org.apache.myfaces.shared.util.ExternalContextUtils;

public class ContainerUtils {
    private static final String GAE_SERVER_INFO_BEGINNING = "Google App Engine";
    private static Boolean runningOnGoogleAppEngine = null;

    public static boolean isJsp21(ServletContext context) {
        if (ContainerUtils.isRunningOnGoogleAppEngine(context)) {
            return false;
        }
        try {
            Class.forName("jakarta.servlet.jsp.JspApplicationContext");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isValueReference(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        int start = value.indexOf("#{");
        if (start < 0) {
            return false;
        }
        int end = value.lastIndexOf(125);
        return end >= 0 && start < end;
    }

    public static boolean isRunningOnGoogleAppEngine(ServletContext servletContext) {
        if (runningOnGoogleAppEngine != null) {
            return runningOnGoogleAppEngine;
        }
        return ContainerUtils.isServerGoogleAppEngine(servletContext.getServerInfo());
    }

    public static boolean isRunningOnGoogleAppEngine(ExternalContext externalContext) {
        if (runningOnGoogleAppEngine != null) {
            return runningOnGoogleAppEngine;
        }
        String serverInfo = ExternalContextUtils.getServerInfo(externalContext);
        return ContainerUtils.isServerGoogleAppEngine(serverInfo);
    }

    private static boolean isServerGoogleAppEngine(String serverInfo) {
        runningOnGoogleAppEngine = serverInfo != null && serverInfo.startsWith(GAE_SERVER_INFO_BEGINNING) ? Boolean.TRUE : Boolean.FALSE;
        return runningOnGoogleAppEngine;
    }
}

