/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.internal.validation.ValidatorUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.annotations.enums.SecuritySchemeType;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SecuritySchemeValidator
extends TypeValidator<SecurityScheme> {
    private static final TraceComponent tc = Tr.register(SecuritySchemeValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final SecuritySchemeValidator INSTANCE = new SecuritySchemeValidator();
    static final long serialVersionUID = -6159503902904183096L;

    public static SecuritySchemeValidator getInstance() {
        return INSTANCE;
    }

    private SecuritySchemeValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, SecurityScheme t) {
        String reference = t.getRef();
        if (reference != null && !reference.isEmpty()) {
            ValidatorUtils.referenceValidatorHelper(reference, t, helper, context, key);
            return;
        }
        Optional<OASValidationResult.ValidationEvent> op_type = ValidatorUtils.validateRequiredField(t.getType(), context, "type");
        if (op_type.isPresent()) {
            op_type.ifPresent(helper::addValidationEvent);
        } else {
            String message;
            String type = t.getType().toString();
            if (SecuritySchemeType.APIKEY.toString().equals(type)) {
                ValidatorUtils.validateRequiredField(t.getName(), context, "name").ifPresent(helper::addValidationEvent);
                Optional<OASValidationResult.ValidationEvent> op_in = ValidatorUtils.validateRequiredField(t.getIn(), context, "in");
                if (op_in.isPresent()) {
                    op_in.ifPresent(helper::addValidationEvent);
                } else {
                    List inValues = Arrays.asList(SecurityScheme.In.values()).stream().map(SecurityScheme.In::toString).collect(Collectors.toList());
                    if (!inValues.contains(t.getIn().toString())) {
                        String message2 = Tr.formatMessage((TraceComponent)tc, (String)"securitySchemeInFieldInvalid", (Object[])new Object[]{key, t.getIn().toString()});
                        helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message2));
                    }
                }
            } else if (SecuritySchemeType.HTTP.toString().equals(type)) {
                ValidatorUtils.validateRequiredField(t.getScheme(), context, "scheme").ifPresent(helper::addValidationEvent);
            } else if (SecuritySchemeType.OAUTH2.toString().equals(type)) {
                ValidatorUtils.validateRequiredField(t.getFlows(), context, "flows").ifPresent(helper::addValidationEvent);
            } else if (SecuritySchemeType.OPENIDCONNECT.toString().equals(type)) {
                Optional<OASValidationResult.ValidationEvent> op_url = ValidatorUtils.validateRequiredField(t.getOpenIdConnectUrl(), context, "openIdConnectUrl");
                if (op_url.isPresent()) {
                    op_url.ifPresent(helper::addValidationEvent);
                } else if (!ValidatorUtils.isValidURI(t.getOpenIdConnectUrl())) {
                    String message3 = Tr.formatMessage((TraceComponent)tc, (String)"securitySchemeInvalidURL", (Object[])new Object[]{t.getOpenIdConnectUrl()});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message3));
                }
            }
            if (t.getBearerFormat() != null && !t.getBearerFormat().isEmpty() && !SecuritySchemeType.HTTP.toString().equals(type)) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableFieldWithValue", (Object[])new Object[]{"bearerFormat", t.getBearerFormat(), "Security Scheme Object", type});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
            }
            if (t.getScheme() != null && !t.getScheme().isEmpty() && !SecuritySchemeType.HTTP.toString().equals(type)) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableFieldWithValue", (Object[])new Object[]{"scheme", t.getScheme(), "Security Scheme Object", type});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
            }
            if (t.getIn() != null && !SecuritySchemeType.APIKEY.toString().equals(type)) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableFieldWithValue", (Object[])new Object[]{"in", t.getIn(), "Security Scheme Object", type});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
            }
            if (t.getName() != null && !t.getName().isEmpty() && !SecuritySchemeType.APIKEY.toString().equals(type)) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableFieldWithValue", (Object[])new Object[]{"name", t.getName(), "Security Scheme Object", type});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
            }
            if (t.getOpenIdConnectUrl() != null && !t.getOpenIdConnectUrl().isEmpty() && !SecuritySchemeType.OPENIDCONNECT.toString().equals(type)) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableFieldWithValue", (Object[])new Object[]{"openIdConnectUrl", t.getOpenIdConnectUrl(), "Security Scheme Object", type});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
            }
            if (!SecuritySchemeType.OAUTH2.toString().equals(type) && ValidatorUtils.flowsIsSet(t.getFlows())) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableField", (Object[])new Object[]{"flows", "Security Scheme Object", type});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
            }
        }
    }
}

