/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.annocache.AnnotationsBetaHelper;
import com.ibm.ws.container.service.app.deploy.EJBModuleInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxws.utils.StringUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.info.AnnotationInfo;
import com.ibm.wsspi.anno.info.AnnotationValue;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.info.InfoStore;
import com.ibm.wsspi.anno.info.PackageInfo;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.PackageUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxWsUtils {
    private static final TraceComponent tc = Tr.register(JaxWsUtils.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
    static final long serialVersionUID = -345281186926299451L;

    public static boolean isWebService(ClassInfo classInfo) {
        return (classInfo.isAnnotationPresent("jakarta.jws.WebService") || classInfo.isAnnotationPresent("jakarta.xml.ws.WebServiceProvider")) && JaxWsUtils.isProperWebService(classInfo);
    }

    private static boolean isProperWebService(ClassInfo classInfo) {
        int modifiers = classInfo.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isFinal(modifiers) && !Modifier.isAbstract(modifiers);
    }

    @FFDCIgnore(value={Exception.class})
    public static URL resolve(String location, Container container) {
        if (StringUtils.isEmpty(location)) {
            return null;
        }
        URL ret = JaxWsUtils.createAbsoluteURL(location);
        try {
            Entry entry;
            if (ret == null && (entry = container.getEntry(location)) != null) {
                ret = entry.getResource();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    @FFDCIgnore(value={MalformedURLException.class})
    private static URL createAbsoluteURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static QName getServiceQName(ClassInfo classInfo, String seiClassName, String targetNamespace) {
        AnnotationInfo annotationInfo = JaxWsUtils.getAnnotationInfoFromClass(classInfo, "Service QName");
        if (annotationInfo == null) {
            return null;
        }
        return JaxWsUtils.getQName(classInfo, targetNamespace, annotationInfo.getValue("serviceName").getStringValue(), "Service");
    }

    private static AnnotationInfo getAnnotationInfoFromClass(ClassInfo classInfo, String attribute) {
        AnnotationInfo annotationInfo = classInfo.getAnnotation("jakarta.jws.WebService");
        if (annotationInfo == null) {
            annotationInfo = classInfo.getAnnotation("jakarta.xml.ws.WebServiceProvider");
        }
        if (annotationInfo == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("No @WebService or @WebServiceProvider annotation is found on the class " + classInfo + ", will return null or \"\" for " + attribute), (Object[])new Object[0]);
        }
        return annotationInfo;
    }

    public static String getServiceName(ClassInfo classInfo) {
        return JaxWsUtils.getServiceQName(classInfo, null, null).getLocalPart();
    }

    public static QName getPortQName(ClassInfo classInfo, String seiClassName, String targetNamespace) {
        AnnotationInfo annotationInfo = JaxWsUtils.getAnnotationInfoFromClass(classInfo, "Port QName");
        if (annotationInfo == null) {
            return null;
        }
        boolean webServiceProviderAnnotation = JaxWsUtils.isProvider(classInfo);
        String wsName = webServiceProviderAnnotation ? null : annotationInfo.getValue("name").getStringValue();
        return JaxWsUtils.getPortQName(classInfo, targetNamespace, wsName, annotationInfo.getValue("portName").getStringValue(), "Port");
    }

    public static String getSEIClassNameFromAnnotation(ClassInfo classInfo) {
        AnnotationInfo annotationInfo = JaxWsUtils.getAnnotationInfoFromClass(classInfo, "SEI Name");
        if (annotationInfo == null) {
            return null;
        }
        boolean webServiceProviderAnnotation = JaxWsUtils.isProvider(classInfo);
        return webServiceProviderAnnotation ? null : annotationInfo.getValue("endpointInterface").getStringValue();
    }

    public static boolean isProvider(ClassInfo classInfo) {
        AnnotationInfo annotationInfo = classInfo.getAnnotation("jakarta.jws.WebService");
        return annotationInfo == null && (annotationInfo = classInfo.getAnnotation("jakarta.xml.ws.WebServiceProvider")) != null;
    }

    public static String getImplementedTargetNamespace(ClassInfo classInfo) {
        AnnotationInfo annotationInfo;
        String defaultValue = JaxWsUtils.getNamespace(classInfo, null);
        if (StringUtils.isEmpty(defaultValue)) {
            defaultValue = "http://unknown.namespace/";
        }
        if ((annotationInfo = JaxWsUtils.getAnnotationInfoFromClass(classInfo, "targetNamespace")) == null) {
            return "";
        }
        AnnotationValue attrValue = annotationInfo.getValue("targetNamespace");
        String attrFromAnnotation = attrValue == null ? null : attrValue.getStringValue().trim();
        return StringUtils.isEmpty(attrFromAnnotation) ? defaultValue : attrFromAnnotation;
    }

    public static String getInterfaceTargetNamespace(ClassInfo classInfo, String seiClassName, String implementedTargetNamespace, InfoStore infoStore) {
        AnnotationInfo annotationInfo = JaxWsUtils.getAnnotationInfoFromClass(classInfo, "targetNamespace");
        if (annotationInfo == null) {
            return "";
        }
        boolean isProvider = JaxWsUtils.isProvider(classInfo);
        if (isProvider) {
            AnnotationValue attrValue = annotationInfo.getValue("targetNamespace");
            String attrFromAnnotation = attrValue == null ? null : attrValue.getStringValue().trim();
            return StringUtils.isEmpty(attrFromAnnotation) ? implementedTargetNamespace : attrFromAnnotation;
        }
        if (null == infoStore || StringUtils.isEmpty(seiClassName)) {
            return implementedTargetNamespace;
        }
        ClassInfo seiClassInfo = infoStore.getDelayableClassInfo(seiClassName);
        String defaultValue = JaxWsUtils.getNamespace(seiClassInfo, null);
        if (StringUtils.isEmpty(defaultValue)) {
            defaultValue = "http://unknown.namespace/";
        }
        if (null == (annotationInfo = seiClassInfo.getAnnotation("jakarta.jws.WebService"))) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No @WebService or @WebServiceProvider annotation is found on the class " + seiClassInfo + " will return " + defaultValue), (Object[])new Object[0]);
            }
            return defaultValue;
        }
        String attrFromSEI = annotationInfo.getValue("targetNamespace").getStringValue().trim();
        return StringUtils.isEmpty(attrFromSEI) ? defaultValue : attrFromSEI;
    }

    public static String getWSDLLocation(ClassInfo classInfo, String seiClassName, InfoStore infoStore) {
        return JaxWsUtils.getStringAttributeFromAnnotation(classInfo, seiClassName, infoStore, "wsdlLocation", "", "");
    }

    private static String getStringAttributeFromWebServiceProviderAnnotation(AnnotationInfo annotationInfo, String attribute, String defaultForServiceProvider) {
        if (attribute.equals("endpointInterface") || attribute.equals("name")) {
            return defaultForServiceProvider;
        }
        AnnotationValue attrValue = annotationInfo.getValue(attribute);
        String attrFromSP = attrValue == null ? null : attrValue.getStringValue().trim();
        return StringUtils.isEmpty(attrFromSP) ? defaultForServiceProvider : attrFromSP;
    }

    private static String getStringAttributeFromAnnotation(ClassInfo classInfo, String seiClassName, InfoStore infoStore, String attribute, String defaultForService, String defaultForServiceProvider) {
        AnnotationInfo annotationInfo = JaxWsUtils.getAnnotationInfoFromClass(classInfo, attribute);
        if (annotationInfo == null) {
            return "";
        }
        boolean isProvider = JaxWsUtils.isProvider(classInfo);
        if (isProvider) {
            return JaxWsUtils.getStringAttributeFromWebServiceProviderAnnotation(annotationInfo, attribute, defaultForServiceProvider);
        }
        String attrFromImplBean = annotationInfo.getValue(attribute).getStringValue().trim();
        if (attrFromImplBean.isEmpty()) {
            if (seiClassName.isEmpty()) {
                return defaultForService;
            }
            ClassInfo seiClassInfo = infoStore.getDelayableClassInfo(seiClassName);
            annotationInfo = seiClassInfo.getAnnotation("jakarta.jws.WebService");
            if (null == annotationInfo) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("No @WebService or @WebServiceProvider annotation is found on the class " + seiClassInfo + " will return " + defaultForService), (Object[])new Object[0]);
                }
                return defaultForService;
            }
            String attrFromSEI = annotationInfo.getValue(attribute).getStringValue().trim();
            return StringUtils.isEmpty(attrFromSEI) ? defaultForService : attrFromSEI;
        }
        return attrFromImplBean;
    }

    public static String getPortName(ClassInfo classInfo) {
        return JaxWsUtils.getPortQName(classInfo, null, null).getLocalPart();
    }

    public static String getPortComponentName(ClassInfo classInfo, String seiClassName, InfoStore infoStore) {
        String defaultForServiceProvider = classInfo.getName();
        String defaultForService = JaxWsUtils.getClassName(classInfo.getName());
        return JaxWsUtils.getStringAttributeFromAnnotation(classInfo, seiClassName, infoStore, "name", defaultForService, defaultForServiceProvider);
    }

    private static String getClassName(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1);
    }

    private static QName getQName(ClassInfo classInfo, String namespace, String name, String suffix) {
        return new QName(namespace, JaxWsUtils.constructName(classInfo, name, suffix));
    }

    private static QName getPortQName(ClassInfo classInfo, String namespace, String wsName, String wsPortName, String suffix) {
        String portName;
        if (wsPortName != null && !wsPortName.isEmpty()) {
            portName = wsPortName.trim();
        } else {
            String qualifiedName;
            int lastDotIndex;
            portName = wsName != null && !wsName.isEmpty() ? wsName.trim() : ((lastDotIndex = (qualifiedName = classInfo.getQualifiedName()).lastIndexOf(".")) == -1 ? qualifiedName : qualifiedName.substring(lastDotIndex + 1));
            portName = portName + suffix;
        }
        return new QName(namespace, portName);
    }

    public static String getNamespace(ClassInfo classInfo, String namespace) {
        if (namespace == null || namespace.trim().length() == 0) {
            PackageInfo packageInfo = classInfo.getPackage();
            if (packageInfo == null) {
                return null;
            }
            return JaxWsUtils.getNamespace(packageInfo.getName());
        }
        return namespace.trim();
    }

    private static String getNamespace(String packageName) {
        return PackageUtils.getNamespace((String)packageName);
    }

    private static String constructName(ClassInfo classInfo, String name, String suffix) {
        if (name == null || name.trim().length() == 0) {
            String qualifiedName = classInfo.getQualifiedName();
            int lastDotIndex = qualifiedName.lastIndexOf(".");
            return (lastDotIndex == -1 ? qualifiedName : qualifiedName.substring(lastDotIndex + 1)) + suffix;
        }
        return name.trim();
    }

    public static URL getEntryURL(Container container, String entryName) {
        if (entryName == null) {
            return null;
        }
        URL entryURL = null;
        Entry containerEntry = container.getEntry(entryName);
        if (containerEntry != null) {
            entryURL = containerEntry.getResource();
        }
        return entryURL;
    }

    public static boolean matchesQName(QName regQName, QName targetQName) {
        return JaxWsUtils.matchesQName(regQName, targetQName, false);
    }

    public static boolean matchesQName(QName regQName, QName targetQName, boolean ignorePrefix) {
        if (regQName == null || targetQName == null) {
            return false;
        }
        if ("*".equals(JaxWsUtils.getQNameString(regQName))) {
            return true;
        }
        if (!regQName.getNamespaceURI().equals(targetQName.getNamespaceURI()) || !ignorePrefix && !regQName.getPrefix().equals(targetQName.getPrefix())) {
            return false;
        }
        if (regQName.getLocalPart().contains("*")) {
            return Pattern.matches(JaxWsUtils.mapPattern(regQName.getLocalPart()), targetQName.getLocalPart());
        }
        return regQName.getLocalPart().equals(targetQName.getLocalPart());
    }

    public static ModuleInfo getModuleInfo(Container container) {
        NonPersistentCache overlayCache;
        ModuleInfo moduleInfo = null;
        try {
            overlayCache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.jaxws.utils.JaxWsUtils", (String)"517", null, (Object[])new Object[]{container});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to get ModuleInfo due to no NonPersistentCache found", (Object[])new Object[0]);
            }
            return null;
        }
        if (overlayCache != null && (moduleInfo = (ModuleInfo)overlayCache.getFromCache(WebModuleInfo.class)) == null) {
            moduleInfo = (ModuleInfo)overlayCache.getFromCache(EJBModuleInfo.class);
        }
        return moduleInfo;
    }

    public static WebModuleInfo getWebModuleInfo(Container container) {
        NonPersistentCache overlayCache;
        WebModuleInfo moduleInfo = null;
        try {
            overlayCache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.jaxws.utils.JaxWsUtils", (String)"537", null, (Object[])new Object[]{container});
            return null;
        }
        if (overlayCache != null) {
            moduleInfo = (WebModuleInfo)overlayCache.getFromCache(WebModuleInfo.class);
        }
        return moduleInfo;
    }

    private static String mapPattern(String s) {
        StringBuilder buf = new StringBuilder(s);
        block4: for (int x = 0; x < buf.length(); ++x) {
            switch (buf.charAt(x)) {
                case '*': {
                    buf.insert(x, '.');
                    ++x;
                    continue block4;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '\\': 
                case '^': 
                case '{': 
                case '}': {
                    buf.insert(x, '\\');
                    ++x;
                    continue block4;
                }
            }
        }
        return buf.toString();
    }

    private static String getQNameString(QName qName) {
        if ("".equals(qName.getPrefix())) {
            return qName.toString();
        }
        int i = qName.getNamespaceURI().length();
        if (i == 0) {
            return qName.getPrefix() + ':' + qName.getLocalPart();
        }
        StringBuilder sBuffer = new StringBuilder(i + qName.getLocalPart().length() + qName.getPrefix() + 3);
        sBuffer.append('{');
        sBuffer.append(qName.getNamespaceURI());
        sBuffer.append('}');
        sBuffer.append(qName.getPrefix());
        sBuffer.append(':');
        sBuffer.append(qName.getLocalPart());
        return sBuffer.toString();
    }

    public static boolean singleProtocolMatches(String name, String protocol) {
        if ("##SOAP11_HTTP".equals(name)) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http".contains(protocol) || "http://schemas.xmlsoap.org/soap/".contains(protocol);
        }
        if ("##SOAP11_HTTP_MTOM".equals(name)) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".contains(protocol) || "http://schemas.xmlsoap.org/soap/?mtom=true".contains(protocol);
        }
        if ("##SOAP12_HTTP".equals(name)) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/".contains(protocol) || "http://schemas.xmlsoap.org/wsdl/soap12/".contains(protocol);
        }
        if ("##SOAP12_HTTP_MTOM".equals(name)) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".contains(protocol) || "http://schemas.xmlsoap.org/wsdl/soap12/?mtom=true".contains(protocol);
        }
        if ("##XML_HTTP".equals(name)) {
            name = "http://www.w3.org/2004/08/wsdl/http";
        } else if ("http://schemas.xmlsoap.org/wsdl/soap/http".equals(name) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(name) || "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(name) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(name) || "http://www.w3.org/2004/08/wsdl/http".equals(name)) {
            return true;
        }
        return name.contains(protocol);
    }

    public static String getProtocolByToken(String token) {
        return JaxWsUtils.getProtocolByToken(token, false);
    }

    public static String getProtocolByToken(String token, boolean returnDefault) {
        if (StringUtils.isEmpty(token) && returnDefault) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        if ("##SOAP11_HTTP".equals(token)) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        if ("##SOAP11_HTTP_MTOM".equals(token)) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true";
        }
        if ("##SOAP12_HTTP".equals(token)) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
        }
        if ("##SOAP12_HTTP_MTOM".equals(token)) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true";
        }
        if ("##XML_HTTP".equals(token)) {
            return "http://www.w3.org/2004/08/wsdl/http";
        }
        return token;
    }

    public static boolean isWSDLGenerationSupported(String bindingProtocol) {
        return "http://schemas.xmlsoap.org/wsdl/soap/http".equals(bindingProtocol) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(bindingProtocol);
    }

    public static boolean isWebModule(Container container) throws UnableToAdaptException {
        NonPersistentCache overlayCache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
        if (overlayCache != null) {
            return overlayCache.getFromCache(WebModuleInfo.class) != null;
        }
        return false;
    }

    public static boolean isEJBModule(Container container) throws UnableToAdaptException {
        NonPersistentCache overlayCache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
        if (overlayCache != null) {
            return overlayCache.getFromCache(EJBModuleInfo.class) != null;
        }
        return false;
    }

    public static InfoStore getInfoStore(Container container) throws UnableToAdaptException {
        if (JaxWsUtils.isEJBModule(container)) {
            return AnnotationsBetaHelper.getModuleAnnotations((Container)container).getInfoStore();
        }
        if (JaxWsUtils.isWebModule(container)) {
            return AnnotationsBetaHelper.getWebAnnotations((Container)container).getInfoStore();
        }
        return null;
    }
}

