/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.globalhandler;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxws.globalhandler.GlobalHandlerJaxWsMessageContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.webservices.handler.GlobalHandlerMessageContext;
import com.ibm.wsspi.webservices.handler.Handler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class GlobalHandlerChainInvoker {
    private static final TraceComponent tc = Tr.register(GlobalHandlerChainInvoker.class, null, null);
    private final List<Handler> invokedHandlers = new ArrayList<Handler>();
    static final long serialVersionUID = -5483457589644710379L;

    public boolean invokeGlobalHandlers(GlobalHandlerJaxWsMessageContext context, List<Handler> handlersList) {
        return this.invokeHandlerChain(handlersList, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeHandlerChain(List<Handler> handlerChain, GlobalHandlerJaxWsMessageContext ctx) {
        if (handlerChain.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"no registered global handlers", (Object[])new Object[0]);
            }
            return true;
        }
        boolean continueProcessing = true;
        try {
            continueProcessing = this.invokeHandleMessage(handlerChain, ctx);
        }
        finally {
            WebServiceContextImpl.clear();
        }
        return continueProcessing;
    }

    @FFDCIgnore(value={Exception.class})
    private boolean invokeHandleMessage(List<Handler> handlerChain, GlobalHandlerJaxWsMessageContext ctx) {
        boolean continueProcessing = true;
        Handler currentHandler = null;
        try {
            Iterator<Handler> it = handlerChain.iterator();
            while (it.hasNext()) {
                Handler h;
                currentHandler = h = it.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Start calling handleMessage() method for handler: " + currentHandler.getClass().getName()), (Object[])new Object[0]);
                }
                h.handleMessage((GlobalHandlerMessageContext)ctx);
                this.markHandlerInvoked(h);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Finished calling handleMessage() method for handler: " + currentHandler.getClass().getName()), (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && currentHandler != null) {
                Tr.debug((TraceComponent)tc, (String)("handleMessage() method raised exception" + e.getMessage() + "for handler: " + currentHandler.getClass().getName()), (Object[])new Object[0]);
            }
            this.invokeReversedHandleFault(ctx);
            continueProcessing = false;
            throw new RuntimeException(e);
        }
        return continueProcessing;
    }

    /*
     * WARNING - void declaration
     */
    private void invokeReversedHandleFault(GlobalHandlerJaxWsMessageContext ctx) {
        Handler h = null;
        try {
            for (int index = this.invokedHandlers.size() - 1; index >= 0; --index) {
                h = this.invokedHandlers.get(index);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Start calling handleFault() method for handler: " + h.getClass().getName()), (Object[])new Object[0]);
                }
                h.handleFault((GlobalHandlerMessageContext)ctx);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Finished calling handleFault() method for handler: " + h.getClass().getName()), (Object[])new Object[0]);
            }
        }
        catch (RuntimeException index) {
            void e;
            FFDCFilter.processException((Throwable)index, (String)"com.ibm.ws.jaxws.globalhandler.GlobalHandlerChainInvoker", (String)"110", (Object)this, (Object[])new Object[]{ctx});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception in handleFault() method on global handler  " + h.getClass().getName() + e.getMessage()), (Object[])new Object[0]);
            }
            throw e;
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxws.globalhandler.GlobalHandlerChainInvoker", (String)"116", (Object)this, (Object[])new Object[]{ctx});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception in handleFault() method on global handler  " + h.getClass().getName() + e.getMessage()), (Object[])new Object[0]);
            }
            throw new RuntimeException(e);
        }
    }

    private void markHandlerInvoked(Handler h) {
        if (!this.invokedHandlers.contains(h)) {
            this.invokedHandlers.add(h);
        }
    }
}

