/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.http;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuthUtils {
    public static final TraceComponent tc = Tr.register(AuthUtils.class, null, null);
    static final long serialVersionUID = 5906021454413301143L;

    @Sensitive
    public String getBearerTokenFromHeader(HttpServletRequest req) {
        return this.getBearerTokenFromHeader(req, "Authorization");
    }

    @Sensitive
    public String getBearerTokenFromHeader(HttpServletRequest req, String ... headersToCheck) {
        if (headersToCheck == null) {
            return null;
        }
        int n = 0;
        String[] stringArray = headersToCheck;
        int n2 = stringArray.length;
        if (n < n2) {
            String headerName = stringArray[n];
            String hdrValue = req.getHeader(headerName);
            if (!this.isAuthorizationHeader(headerName)) {
                return hdrValue;
            }
            return this.getBearerTokenFromHeader(hdrValue, "Bearer ");
        }
        return null;
    }

    @Sensitive
    public String getBearerTokenFromHeader(@Sensitive String rawHeaderValue, String scheme) {
        if (rawHeaderValue == null) {
            return rawHeaderValue;
        }
        if (scheme != null && rawHeaderValue.startsWith(scheme)) {
            return rawHeaderValue.substring(scheme.length()).trim();
        }
        return rawHeaderValue;
    }

    private boolean isAuthorizationHeader(String headerName) {
        return "Authorization".equals(headerName);
    }
}

