/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.logging.hpel.LogRecordContext;
import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.logging.internal.TraceNLSResolver;
import com.ibm.wsspi.logging.LogRecordExt;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class WsLogRecord
extends LogRecord
implements Serializable,
LogRecordExt {
    private static final long serialVersionUID = 8979064390839459362L;
    private static final String emptyString = "";
    private String ivComponent = "";
    private String ivCorrelationId = "";
    private final Map<String, String> ivExtensions = new HashMap<String, String>();
    private String ivFormattedMessage = null;
    private String ivMessageLocale = null;
    private String ivOrganization = "";
    private String ivProcessId = "";
    private String ivProcessName = "";
    private String ivProduct = "";
    private byte[] ivRawData = null;
    private String ivStackTrace;
    private String ivThreadName;
    private String ivVersion = "";
    private String ivSourceClassName;
    private String ivSourceMethodName;
    public static final int DEFAULT_LOCALIZATION = 0;
    public static final int REQUIRES_LOCALIZATION = 1;
    public static final int REQUIRES_NO_LOCALIZATION = 2;
    private int localizable;
    private transient Class<?> ivTraceClass;

    protected WsLogRecord(Level level, String msg) {
        super(level, msg);
    }

    public void addExtension(String name, String value) {
        this.ivExtensions.put(name, value);
    }

    public void addExtensions(Map<String, String> extensions) {
        this.ivExtensions.putAll(extensions);
    }

    public String getComponent() {
        return this.ivComponent;
    }

    public String getCorrelationId() {
        return this.ivCorrelationId;
    }

    public String getExtension(String name) {
        return this.ivExtensions.get(name);
    }

    public Map<String, String> getExtensions() {
        return this.ivExtensions;
    }

    public String getFormattedMessage() {
        return this.ivFormattedMessage;
    }

    public String getMessageLocale() {
        return this.ivMessageLocale;
    }

    public String getOrganization() {
        return this.ivOrganization;
    }

    public String getProcessId() {
        return this.ivProcessId;
    }

    public String getProcessName() {
        return this.ivProcessName;
    }

    public String getProduct() {
        return this.ivProduct;
    }

    public byte[] getRawData() {
        return this.ivRawData;
    }

    public String getStackTrace() {
        return this.ivStackTrace;
    }

    public String getReporterOrSourceThreadName() {
        return this.ivThreadName;
    }

    public String getVersion() {
        return this.ivVersion;
    }

    public void setComponent(String component) {
        if (component == null) {
            return;
        }
        this.ivComponent = component;
    }

    public void setCorrelationId(String correlationId) {
        if (correlationId == null) {
            return;
        }
        this.ivCorrelationId = correlationId;
    }

    public void setFormattedMessage(String formattedMessage) {
        this.ivFormattedMessage = formattedMessage;
    }

    public void setMessageLocale(String locale) {
        this.ivMessageLocale = locale;
    }

    public void setOrganization(String organization) {
        if (organization == null) {
            return;
        }
        this.ivOrganization = organization;
    }

    public void setProcessId(String id) {
        if (id == null) {
            return;
        }
        this.ivProcessId = id;
    }

    public void setProcessName(String name) {
        if (name == null) {
            return;
        }
        this.ivProcessName = name;
    }

    public void setProduct(String product) {
        if (product == null) {
            return;
        }
        this.ivProduct = product;
    }

    public void setRawData(byte[] rawData) {
        if (rawData == null) {
            return;
        }
        this.ivRawData = rawData;
    }

    public void setSourceThreadName(String threadName) {
        this.ivThreadName = threadName;
    }

    public void setStackTrace(String stackTrace) {
        this.ivStackTrace = stackTrace;
    }

    @Override
    public void setThrown(Throwable thrown) {
        if (thrown != null) {
            super.setThrown(thrown);
            this.ivStackTrace = DataFormatHelper.throwableToString(thrown);
        }
    }

    public void setVersion(String version) {
        if (version == null) {
            return;
        }
        this.ivVersion = version;
    }

    @Override
    public void setSourceClassName(String sourceClassName) {
        this.ivSourceClassName = sourceClassName;
    }

    @Override
    public String getSourceClassName() {
        return this.ivSourceClassName;
    }

    @Override
    public void setSourceMethodName(String sourceMethodName) {
        this.ivSourceMethodName = sourceMethodName;
    }

    @Override
    public String getSourceMethodName() {
        return this.ivSourceMethodName;
    }

    public void setTraceClass(Class<?> traceClazz) {
        this.ivTraceClass = traceClazz;
    }

    @Override
    public ResourceBundle getResourceBundle() {
        ResourceBundle rb = super.getResourceBundle();
        String rbBame = this.getResourceBundleName();
        if (rb == null && this.ivTraceClass != null && rbBame != null) {
            try {
                rb = TraceNLSResolver.getInstance().getResourceBundle(this.ivTraceClass, rbBame, Locale.getDefault());
                super.setResourceBundle(rb);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return rb;
    }

    @Override
    public String getFormattedMessage(Locale locale) {
        ResourceBundle bundle = null;
        if (locale == Locale.ENGLISH && this.ivTraceClass != null) {
            bundle = TraceNLS.getBaseResourceBundle(this.ivTraceClass, this.getResourceBundleName());
        }
        return TraceNLSResolver.getInstance().getMessage(this.ivTraceClass, bundle, this.getResourceBundleName(), this.getMessage(), this.getParameters(), this.getMessage() + " not found in resource bundle " + this.getResourceBundleName(), true, locale, false);
    }

    public static WsLogRecord createWsLogRecord(TraceComponent tc, Level level, String msg, Object[] msgParms) {
        WsLogRecord retMe = new WsLogRecord(level, msg);
        retMe.setLoggerName(tc.getName());
        retMe.setParameters(msgParms);
        retMe.setTraceClass(tc.getTraceClass());
        retMe.setResourceBundleName(tc.getResourceBundleName());
        if (level.intValue() >= Level.INFO.intValue()) {
            retMe.setLocalizable(1);
        } else {
            retMe.setLocalizable(2);
        }
        LogRecordContext.getExtensions(retMe.getExtensions());
        return retMe;
    }

    public int getLocalizable() {
        return this.localizable;
    }

    public void setLocalizable(int localizable) {
        this.localizable = localizable;
    }
}

