/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.basictrigger;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.TriggerService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.enterprise.concurrent.LastExecution;
import jakarta.enterprise.concurrent.Trigger;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class BasicTriggerService
implements TriggerService {
    private static final TraceComponent tc = Tr.register(BasicTriggerService.class, (String)"concurrent", null);
    static final long serialVersionUID = -1803178353596605377L;

    public ZonedDateTime getNextRunTime(LastExecution lastExecution, ZonedDateTime taskScheduledTime, Trigger trigger) {
        Date nextExecutionDate = trigger.getNextRunTime(lastExecution, Date.from(taskScheduledTime.toInstant()));
        return nextExecutionDate == null ? null : nextExecutionDate.toInstant().atZone(taskScheduledTime.getZone());
    }

    @Trivial
    public ZoneId getZoneId(Trigger trigger) {
        return ZoneId.systemDefault();
    }

    public boolean skipRun(LastExecution lastExecution, ZonedDateTime nextExecutionTime, Trigger trigger) {
        return trigger.skipRun(lastExecution, Date.from(nextExecutionTime.toInstant()));
    }
}

