/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HashUtils {
    static final char[] hexDigits;
    static final String SHA256 = "SHA-256";
    static final String MD5 = "MD5";
    static final long serialVersionUID = 7626787674441414504L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String getMD5String(String str) {
        MessageDigest messageDigest = HashUtils.getMessageDigest(MD5);
        return HashUtils.getHashString(str, messageDigest);
    }

    public static String getFileMD5String(File file) throws IOException {
        MessageDigest messageDigest = HashUtils.getMessageDigest(MD5);
        return HashUtils.getFileHashString(file, messageDigest);
    }

    public static String getSHA256String(String str) {
        MessageDigest messageDigest = HashUtils.getMessageDigest(SHA256);
        return HashUtils.getHashString(str, messageDigest);
    }

    public static String getFileSHA256String(File file) throws IOException {
        MessageDigest messageDigest = HashUtils.getMessageDigest(SHA256);
        return HashUtils.getFileHashString(file, messageDigest);
    }

    private static String getHashString(String str, MessageDigest messagedigest) {
        messagedigest.update(str.getBytes());
        return HashUtils.byteArrayToHexString(messagedigest.digest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getFileHashString(File file, MessageDigest messagedigest) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            int numRead = 0;
            while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
                messagedigest.update(buffer, 0, numRead);
            }
            if (fis == null) return HashUtils.byteArrayToHexString(messagedigest.digest());
        }
        catch (Throwable throwable) {
            if (fis == null) throw throwable;
            try {
                ((InputStream)fis).close();
                throw throwable;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.feature.internal.HashUtils", (String)"94", null, (Object[])new Object[]{file, messagedigest});
            }
            throw throwable;
        }
        try {
            ((InputStream)fis).close();
            return HashUtils.byteArrayToHexString(messagedigest.digest());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.feature.internal.HashUtils", (String)"94", null, (Object[])new Object[]{file, messagedigest});
        }
        return HashUtils.byteArrayToHexString(messagedigest.digest());
    }

    private static String byteArrayToHexString(byte[] byteArray) {
        StringBuffer stringbuffer = new StringBuffer(2 * byteArray.length);
        for (int i = 0; i < byteArray.length; ++i) {
            char upper = hexDigits[(byteArray[i] & 0xF0) >> 4];
            char lower = hexDigits[byteArray[i] & 0xF];
            stringbuffer.append(upper);
            stringbuffer.append(lower);
        }
        return stringbuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static MessageDigest getMessageDigest(String digestType) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(digestType);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            void e;
            FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.kernel.feature.internal.HashUtils", (String)"125", null, (Object[])new Object[]{digestType});
            throw new RuntimeException((Throwable)e);
        }
        return messageDigest;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.HashUtils", HashUtils.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

