/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.util.MediaTypeHelper;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ServletUtil {
    private static final Map<InitDataCacheKey, ResteasyUriInfo.InitData> initDataCache;
    static final long serialVersionUID = 5114316669056246831L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static ResteasyUriInfo extractUriInfo(HttpServletRequest request, String servletPrefix) {
        ResteasyUriInfo myResteasyUriInfo;
        String encodedContextPath;
        String contextPath = request.getContextPath();
        if (servletPrefix != null && servletPrefix.length() > 0 && !servletPrefix.equals("/")) {
            if (!contextPath.endsWith("/") && !servletPrefix.startsWith("/")) {
                contextPath = contextPath + "/";
            }
            contextPath = contextPath + servletPrefix;
        }
        String queryString = request.getQueryString();
        StringBuffer requestURL = request.getRequestURL();
        String requestURLstring = requestURL.toString();
        String absolute = queryString != null && queryString.length() > 0 ? requestURL.append('?').append(queryString).toString() : requestURLstring;
        if (!absolute.contains(contextPath) && absolute.contains(encodedContextPath = Arrays.stream(contextPath.substring(1).split("/")).map(s -> {
            try {
                return URLEncoder.encode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                return s;
            }
        }).collect(Collectors.joining("/", "/", "")))) {
            absolute = absolute.replace(encodedContextPath, contextPath);
        }
        if (ResteasyUriInfo.InitData.canBeCached(absolute)) {
            InitDataCacheKey cacheKey = new InitDataCacheKey(requestURLstring, contextPath);
            ResteasyUriInfo.InitData myInitData = initDataCache.get(cacheKey);
            if (myInitData == null) {
                myInitData = new ResteasyUriInfo.InitData(absolute, contextPath);
                initDataCache.put(cacheKey, myInitData);
            }
            myResteasyUriInfo = new ResteasyUriInfo(absolute, contextPath, myInitData);
        } else {
            myResteasyUriInfo = new ResteasyUriInfo(absolute, contextPath);
        }
        return myResteasyUriInfo;
    }

    public static ResteasyHttpHeaders extractHttpHeaders(HttpServletRequest request) {
        MultivaluedMap<String, String> requestHeaders = ServletUtil.extractRequestHeaders(request);
        ResteasyHttpHeaders headers = new ResteasyHttpHeaders(requestHeaders);
        String contentType = request.getContentType();
        if (contentType != null) {
            headers.getMutableHeaders().putSingle((Object)"Content-Type", (Object)contentType);
        }
        Map<String, jakarta.ws.rs.core.Cookie> cookies = ServletUtil.extractCookies(request);
        headers.setCookies(cookies);
        headers.testParsing();
        return headers;
    }

    static Map<String, jakarta.ws.rs.core.Cookie> extractCookies(HttpServletRequest request) {
        HashMap<String, jakarta.ws.rs.core.Cookie> cookies = new HashMap<String, jakarta.ws.rs.core.Cookie>();
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                cookies.put(cookie.getName(), new jakarta.ws.rs.core.Cookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion()));
            }
        }
        return cookies;
    }

    public static List<MediaType> extractAccepts(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
        List accepts = (List)requestHeaders.get((Object)"Accept");
        if (accepts == null) {
            return acceptableMediaTypes;
        }
        for (String accept : accepts) {
            acceptableMediaTypes.addAll(MediaTypeHelper.parseHeader(accept));
        }
        return acceptableMediaTypes;
    }

    public static List<String> extractLanguages(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<String> acceptable = new ArrayList<String>();
        List accepts = (List)requestHeaders.get((Object)"Accept-Language");
        if (accepts == null) {
            return acceptable;
        }
        for (String accept : accepts) {
            String[] splits;
            for (String split : splits = accept.split(",")) {
                acceptable.add(split.trim());
            }
        }
        return acceptable;
    }

    public static MultivaluedMap<String, String> extractRequestHeaders(HttpServletRequest request) {
        Headers<String> requestHeaders = new Headers<String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                requestHeaders.add(headerName, headerValue);
            }
        }
        return requestHeaders;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.ServletUtil", ServletUtil.class, null, null);
        initDataCache = new ConcurrentHashMap<InitDataCacheKey, ResteasyUriInfo.InitData>();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class InitDataCacheKey {
        private final String requestUrl;
        private final String contextPath;
        static final long serialVersionUID = 223885926735980094L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        InitDataCacheKey(String url, String path) {
            this.requestUrl = url;
            this.contextPath = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != InitDataCacheKey.class) {
                return false;
            }
            InitDataCacheKey that = (InitDataCacheKey)o;
            return this.requestUrl.equals(that.requestUrl) && this.contextPath.equals(that.contextPath);
        }

        public int hashCode() {
            return Objects.hash(this.requestUrl, this.contextPath);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.ServletUtil$InitDataCacheKey", InitDataCacheKey.class, null, null);
        }
    }
}

