/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jboss.resteasy.core.AbstractAsynchronousResponse;
import org.jboss.resteasy.core.AbstractExecutionContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.servlet.HttpServletInputMessage;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.RunnableWithException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class Servlet3AsyncHttpRequest
extends HttpServletInputMessage {
    protected HttpServletResponse response;
    protected ResteasyAsynchronousContext asynchronousContext;
    protected ScheduledExecutorService asyncScheduler;
    static final long serialVersionUID = -2717397069791246888L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Servlet3AsyncHttpRequest(HttpServletRequest httpServletRequest, HttpServletResponse response, ServletContext servletContext, HttpResponse httpResponse, ResteasyHttpHeaders httpHeaders, ResteasyUriInfo uriInfo, String s, SynchronousDispatcher synchronousDispatcher) {
        super(httpServletRequest, response, servletContext, httpResponse, httpHeaders, uriInfo, s, synchronousDispatcher);
        this.response = response;
        this.asynchronousContext = new Servlet3ExecutionContext((ServletRequest)httpServletRequest);
    }

    @Override
    public ResteasyAsynchronousContext getAsyncContext() {
        return this.asynchronousContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.Servlet3AsyncHttpRequest", Servlet3AsyncHttpRequest.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private class Servlet3ExecutionContext
    extends AbstractExecutionContext {
        protected final ServletRequest servletRequest;
        protected volatile boolean done;
        protected volatile boolean cancelled;
        protected volatile boolean wasSuspended;
        protected Servle3AsychronousResponse asynchronousResponse;
        static final long serialVersionUID = -8486531337553642955L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        Servlet3ExecutionContext(ServletRequest servletRequest) {
            super(Servlet3AsyncHttpRequest.this.dispatcher, Servlet3AsyncHttpRequest.this, Servlet3AsyncHttpRequest.this.httpResponse);
            this.servletRequest = servletRequest;
        }

        @Override
        public ResteasyAsynchronousResponse getAsyncResponse() {
            return this.asynchronousResponse;
        }

        @Override
        public ResteasyAsynchronousResponse suspend() throws IllegalStateException {
            return this.suspend(-1L);
        }

        @Override
        public ResteasyAsynchronousResponse suspend(long millis) throws IllegalStateException {
            return this.suspend(millis, TimeUnit.MILLISECONDS);
        }

        @Override
        public ResteasyAsynchronousResponse suspend(long time, TimeUnit unit) throws IllegalStateException {
            AsyncContext asyncContext = this.setupAsyncContext();
            asyncContext.setTimeout(unit.toMillis(time));
            return this.asynchronousResponse;
        }

        @Override
        public void complete() {
            if (this.wasSuspended && this.asynchronousResponse != null) {
                this.asynchronousResponse.complete();
            }
        }

        protected AsyncContext setupAsyncContext() {
            if (this.servletRequest.isAsyncStarted()) {
                throw new IllegalStateException(Messages.MESSAGES.alreadySuspended());
            }
            this.asynchronousResponse = new Servle3AsychronousResponse();
            AsyncContext asyncContext = this.servletRequest.startAsync();
            asyncContext.addListener((AsyncListener)this.asynchronousResponse);
            this.wasSuspended = true;
            asyncContext.setTimeout(-1L);
            return asyncContext;
        }

        private AsyncContext getAsyncContext() {
            AsyncContext asyncContext = this.servletRequest.getAsyncContext();
            if (asyncContext == null) {
                throw new IllegalStateException(Messages.MESSAGES.requestNotSuspended());
            }
            return asyncContext;
        }

        @Override
        public boolean isSuspended() {
            return this.wasSuspended;
        }

        @Override
        public CompletionStage<Void> executeBlockingIo(RunnableWithException f, boolean hasInterceptors) {
            CompletableFuture<Void> ret = new CompletableFuture<Void>();
            if (hasInterceptors && this.isOnIoThread()) {
                ret.completeExceptionally(new RuntimeException("Cannot use blocking IO with interceptors when we're on the IO thread"));
                return ret;
            }
            try {
                f.run();
                ret.complete(null);
            }
            catch (Exception e) {
                ret.completeExceptionally(e);
            }
            return ret;
        }

        @Override
        public CompletionStage<Void> executeAsyncIo(CompletionStage<Void> f) {
            CompletableFuture<Void> ret = f.toCompletableFuture();
            if (!ret.isDone() && !this.isSuspended()) {
                this.suspend();
                return ret;
            }
            return f;
        }

        private boolean isOnIoThread() {
            return Thread.currentThread().getClass().getName().equals("org.xnio.nio.WorkerThread");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.Servlet3AsyncHttpRequest$Servlet3ExecutionContext", Servlet3ExecutionContext.class, null, null);
        }

        @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
        @TraceOptions
        private class Servle3AsychronousResponse
        extends AbstractAsynchronousResponse
        implements AsyncListener {
            private Object responseLock;
            protected ScheduledFuture<?> timeoutFuture;
            static final long serialVersionUID = 1258961206177032829L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            private Servle3AsychronousResponse() {
                super(Servlet3ExecutionContext.this.dispatcher, Servlet3ExecutionContext.this.request, Servlet3ExecutionContext.this.response);
                this.responseLock = new Object();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean resume(Object entity) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (Servlet3ExecutionContext.this.done) {
                        return false;
                    }
                    if (Servlet3ExecutionContext.this.cancelled) {
                        return false;
                    }
                    AsyncContext asyncContext = Servlet3ExecutionContext.this.getAsyncContext();
                    Servlet3ExecutionContext.this.done = true;
                    return this.internalResume(entity, (Throwable t) -> asyncContext.complete());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete() {
                Object object = this.responseLock;
                synchronized (object) {
                    if (Servlet3ExecutionContext.this.done) {
                        return;
                    }
                    if (Servlet3ExecutionContext.this.cancelled) {
                        return;
                    }
                    AsyncContext asyncContext = Servlet3ExecutionContext.this.getAsyncContext();
                    Servlet3ExecutionContext.this.done = true;
                    asyncContext.complete();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean resume(Throwable exc) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (Servlet3ExecutionContext.this.done) {
                        return false;
                    }
                    if (Servlet3ExecutionContext.this.cancelled) {
                        return false;
                    }
                    AsyncContext asyncContext = Servlet3ExecutionContext.this.getAsyncContext();
                    Servlet3ExecutionContext.this.done = true;
                    return this.internalResume(exc, (Throwable t) -> asyncContext.complete());
                }
            }

            @Override
            public void initialRequestThreadFinished() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean setTimeout(long time, TimeUnit unit) throws IllegalStateException {
                Object object = this.responseLock;
                synchronized (object) {
                    if (Servlet3ExecutionContext.this.done || Servlet3ExecutionContext.this.cancelled) {
                        return false;
                    }
                    if (this.timeoutFuture != null && !this.timeoutFuture.cancel(false)) {
                        return false;
                    }
                    if (time <= 0L) {
                        return true;
                    }
                    Runnable task = new Runnable(){
                        static final long serialVersionUID = -6840857670370545355L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public void run() {
                            LogMessages.LOGGER.debug(Messages.MESSAGES.scheduledTimeout());
                            Servle3AsychronousResponse.this.handleTimeout();
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.Servlet3AsyncHttpRequest$Servlet3ExecutionContext$Servle3AsychronousResponse$1", 1.class, null, null);
                        }
                    };
                    LogMessages.LOGGER.debug(Messages.MESSAGES.schedulingTimeout());
                    this.timeoutFuture = Servlet3AsyncHttpRequest.this.asyncScheduler.schedule(task, time, unit);
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel() {
                LogMessages.LOGGER.debug(Messages.MESSAGES.cancel());
                Object object = this.responseLock;
                synchronized (object) {
                    if (Servlet3ExecutionContext.this.cancelled) {
                        LogMessages.LOGGER.debug(Messages.MESSAGES.alreadyCanceled());
                        return true;
                    }
                    if (Servlet3ExecutionContext.this.done) {
                        LogMessages.LOGGER.debug(Messages.MESSAGES.alreadyDone());
                        return false;
                    }
                    Servlet3ExecutionContext.this.done = true;
                    Servlet3ExecutionContext.this.cancelled = true;
                    AsyncContext asyncContext = Servlet3ExecutionContext.this.getAsyncContext();
                    LogMessages.LOGGER.debug(Messages.MESSAGES.cancellingWith503());
                    return this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build(), (Throwable t) -> asyncContext.complete());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel(int retryAfter) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (Servlet3ExecutionContext.this.cancelled) {
                        return true;
                    }
                    if (Servlet3ExecutionContext.this.done) {
                        return false;
                    }
                    Servlet3ExecutionContext.this.done = true;
                    Servlet3ExecutionContext.this.cancelled = true;
                    AsyncContext asyncContext = Servlet3ExecutionContext.this.getAsyncContext();
                    return this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", (Object)retryAfter).build(), (Throwable t) -> asyncContext.complete());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel(Date retryAfter) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (Servlet3ExecutionContext.this.cancelled) {
                        return true;
                    }
                    if (Servlet3ExecutionContext.this.done) {
                        return false;
                    }
                    Servlet3ExecutionContext.this.done = true;
                    Servlet3ExecutionContext.this.cancelled = true;
                    AsyncContext asyncContext = Servlet3ExecutionContext.this.getAsyncContext();
                    return this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", (Object)retryAfter).build(), (Throwable t) -> asyncContext.complete());
                }
            }

            public boolean isCancelled() {
                return Servlet3ExecutionContext.this.cancelled;
            }

            public boolean isDone() {
                return Servlet3ExecutionContext.this.done;
            }

            public boolean isSuspended() {
                return !Servlet3ExecutionContext.this.done && !Servlet3ExecutionContext.this.cancelled;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(AsyncEvent asyncEvent) throws IOException {
                LogMessages.LOGGER.debug(Messages.MESSAGES.onComplete());
                Object object = this.responseLock;
                synchronized (object) {
                    Servlet3ExecutionContext.this.done = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTimeout(AsyncEvent asyncEvent) throws IOException {
                LogMessages.LOGGER.debug(Messages.MESSAGES.onTimeout());
                Object object = this.responseLock;
                synchronized (object) {
                    if (Servlet3ExecutionContext.this.done || Servlet3ExecutionContext.this.cancelled) {
                        return;
                    }
                    this.response.reset();
                    this.handleTimeout();
                }
            }

            protected void handleTimeout() {
                if (Servlet3ExecutionContext.this.done) {
                    return;
                }
                if (this.timeoutHandler != null) {
                    this.timeoutHandler.handleTimeout((AsyncResponse)this);
                    return;
                }
                this.resume(new ServiceUnavailableException());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(AsyncEvent asyncEvent) throws IOException {
                Object object = this.responseLock;
                synchronized (object) {
                    Servlet3ExecutionContext.this.cancelled = true;
                    Servlet3ExecutionContext.this.done = true;
                }
            }

            public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.Servlet3AsyncHttpRequest$Servlet3ExecutionContext$Servle3AsychronousResponse", Servle3AsychronousResponse.class, null, null);
            }
        }
    }
}

