/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.sse;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Providers;
import jakarta.ws.rs.sse.InboundSseEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.plugins.providers.sse.SseConstants;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class InboundSseEventImpl
implements InboundSseEvent {
    private final String name;
    private final String id;
    private final String comment;
    private final byte[] data;
    private final long reconnectDelay;
    private final Annotation[] annotations;
    private final MediaType mediaType;
    private final MultivaluedMap<String, String> headers;
    private final Providers providers;
    static final long serialVersionUID = -7482619699042718470L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private InboundSseEventImpl(String name, String id, String comment, long reconnectDelay, byte[] data, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, Providers providers) {
        this.name = name;
        this.id = id;
        this.comment = comment;
        this.reconnectDelay = reconnectDelay;
        this.data = data;
        this.annotations = annotations;
        this.mediaType = mediaType;
        this.headers = headers;
        this.providers = providers;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getComment() {
        return this.comment;
    }

    public long getReconnectDelay() {
        if (this.reconnectDelay < 0L) {
            return -1L;
        }
        return this.reconnectDelay;
    }

    public boolean isReconnectDelaySet() {
        return this.reconnectDelay > -1L;
    }

    public boolean isEmpty() {
        return this.data.length == 0;
    }

    public String readData() {
        return this.readData(SseConstants.STRING_AS_GENERIC_TYPE);
    }

    public <T> T readData(Class<T> type) {
        return this.readData(new GenericType(type), MediaType.TEXT_PLAIN_TYPE);
    }

    public <T> T readData(GenericType<T> type) {
        return this.readData(type, MediaType.TEXT_PLAIN_TYPE);
    }

    public <T> T readData(Class<T> messageType, MediaType mediaType) {
        return this.readData(new GenericType(messageType), mediaType);
    }

    public <T> T readData(GenericType<T> type, MediaType mediaType) {
        MediaType effectiveMediaType = mediaType == null ? this.mediaType : mediaType;
        MessageBodyReader reader = null;
        if (this.providers != null) {
            reader = this.providers.getMessageBodyReader(type.getRawType(), type.getType(), this.annotations, mediaType);
        } else {
            ResteasyProviderFactory factory = ResteasyProviderFactory.getInstance();
            if (!factory.isBuiltinsRegistered()) {
                RegisterBuiltin.register(factory);
            }
            reader = factory.getClientMessageBodyReader(type.getRawType(), type.getType(), this.annotations, mediaType);
        }
        if (reader == null) {
            throw new IllegalStateException(Messages.MESSAGES.notFoundMBR(type.getClass().getName()));
        }
        return this.readAndCast(type, effectiveMediaType, reader);
    }

    private <T> T readAndCast(GenericType<T> type, MediaType effectiveMediaType, MessageBodyReader reader) {
        try {
            return (T)reader.readFrom(type.getRawType(), type.getType(), this.annotations, effectiveMediaType, this.headers, (InputStream)new ByteArrayInputStream(this.data));
        }
        catch (IOException ex) {
            throw new ProcessingException(Messages.MESSAGES.failedToReadData(), (Throwable)ex);
        }
    }

    public byte[] getRawData() {
        if (this.data.length == 0) {
            return this.data;
        }
        return Arrays.copyOf(this.data, this.data.length);
    }

    public String toString() {
        String s;
        try {
            s = this.readData();
        }
        catch (ProcessingException e) {
            s = "Exception:" + e.getLocalizedMessage();
        }
        return "InboundSseEvent{id=" + this.id + '\'' + ", comment=" + (this.comment == null ? "[]" : '\'' + this.comment + '\'') + ", data=" + s + '}';
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.sse.InboundSseEventImpl", InboundSseEventImpl.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    static class Builder {
        private String name;
        private String id;
        private long reconnectDelay = -1L;
        private final ByteArrayOutputStream dataStream;
        private final Annotation[] annotations;
        private final MediaType mediaType;
        private final MultivaluedMap<String, String> headers;
        private final StringBuilder commentBuilder;
        private Providers providers;
        static final long serialVersionUID = 8531794893816571596L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        Builder(Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers) {
            this.annotations = annotations;
            this.mediaType = mediaType;
            this.headers = headers;
            this.commentBuilder = new StringBuilder();
            this.dataStream = new ByteArrayOutputStream();
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder commentLine(CharSequence commentLine) {
            if (commentLine != null) {
                this.commentBuilder.append(commentLine).append('\n');
            }
            return this;
        }

        public Builder reconnectDelay(long milliseconds) {
            this.reconnectDelay = milliseconds;
            return this;
        }

        public Builder write(byte[] data) {
            if (data == null || data.length == 0) {
                return this;
            }
            try {
                this.dataStream.write(data);
            }
            catch (IOException ex) {
                throw new ProcessingException(Messages.MESSAGES.failedToWriteDataToInboudEvent(), (Throwable)ex);
            }
            return this;
        }

        public Builder providers(Providers providers) {
            this.providers = providers;
            return this;
        }

        public InboundSseEvent build() {
            return new InboundSseEventImpl(this.name, this.id, this.commentBuilder.length() > 0 ? this.commentBuilder.substring(0, this.commentBuilder.length() - 1) : null, this.reconnectDelay, this.dataStream.toByteArray(), this.annotations, this.mediaType, this.headers, this.providers);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.sse.InboundSseEventImpl$Builder", Builder.class, null, null);
        }
    }
}

