/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.util.CommitHeaderOutputStream;

@Provider
@Priority(value=4000)
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class GZIPEncodingInterceptor
implements WriterInterceptor {
    static final long serialVersionUID = 6406145500926210456L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        LogMessages.LOGGER.debugf("Interceptor : %s,  Method : aroundWriteTo", this.getClass().getName());
        Object encoding = context.getHeaders().getFirst((Object)"Content-Encoding");
        if (encoding != null && encoding.toString().equalsIgnoreCase("gzip")) {
            OutputStream old = context.getOutputStream();
            CommittedGZIPOutputStream gzipOutputStream = new CommittedGZIPOutputStream(old, null);
            context.getHeaders().remove((Object)"Content-Length");
            context.setOutputStream((OutputStream)gzipOutputStream);
            try {
                context.proceed();
            }
            finally {
                if (gzipOutputStream.getGzip() != null) {
                    gzipOutputStream.getGzip().finish();
                }
                context.setOutputStream(old);
            }
            return;
        }
        context.proceed();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.interceptors.GZIPEncodingInterceptor", GZIPEncodingInterceptor.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    public static class CommittedGZIPOutputStream
    extends CommitHeaderOutputStream {
        protected GZIPOutputStream gzip;
        static final long serialVersionUID = 5462484345292954609L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected CommittedGZIPOutputStream(OutputStream delegate, CommitHeaderOutputStream.CommitCallback headers) {
            super(delegate, headers);
        }

        public GZIPOutputStream getGzip() {
            return this.gzip;
        }

        @Override
        public synchronized void commit() {
            if (this.isHeadersCommitted) {
                return;
            }
            this.isHeadersCommitted = true;
            try {
                this.gzip = new EndableGZIPOutputStream(this.delegate);
                this.delegate = this.gzip;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.interceptors.GZIPEncodingInterceptor$CommittedGZIPOutputStream", CommittedGZIPOutputStream.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    public static class EndableGZIPOutputStream
    extends GZIPOutputStream {
        static final long serialVersionUID = 6784527329915362990L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public EndableGZIPOutputStream(OutputStream os) throws IOException {
            super(os);
        }

        @Override
        public void finish() throws IOException {
            super.finish();
            this.def.end();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.interceptors.GZIPEncodingInterceptor$EndableGZIPOutputStream", EndableGZIPOutputStream.class, null, null);
        }
    }
}

