/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.registry;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.resteasy.util.PathHelper;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public abstract class Expression
implements Comparable<Expression> {
    public static final Pattern GROUP;
    protected String pathExpression;
    protected String regex;
    protected Pattern pattern;
    protected List<Group> groups = new ArrayList<Group>();
    protected int literalCharacters;
    protected int numCapturingGroups;
    protected int numNonDefaultGroups;
    static final long serialVersionUID = 1448377700781981335L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Expression(String segment, String additionalRegex) {
        this.pathExpression = segment;
        CharSequence replacedCurlySegment = PathHelper.replaceEnclosedCurlyBracesCS(segment);
        this.literalCharacters = PathHelper.URI_PARAM_PATTERN.matcher(replacedCurlySegment).replaceAll("").length();
        String[] split = PathHelper.URI_PARAM_PATTERN.split(replacedCurlySegment);
        Matcher withPathParam = PathHelper.URI_PARAM_PATTERN.matcher(replacedCurlySegment);
        int i = 0;
        StringBuffer buffer = new StringBuffer();
        if (i < split.length) {
            buffer.append(Pattern.quote(split[i++]));
        }
        int groupNumber = 1;
        while (withPathParam.find()) {
            String name = withPathParam.group(1);
            buffer.append("(");
            if (withPathParam.group(3) == null) {
                buffer.append("[^/]+");
                this.groups.add(new Group(groupNumber++, name, true));
            } else {
                String expr = withPathParam.group(3);
                expr = PathHelper.recoverEnclosedCurlyBraces(expr);
                buffer.append(expr);
                ++this.numNonDefaultGroups;
                this.groups.add(new Group(groupNumber++, name));
                groupNumber += Expression.groupCount(expr);
            }
            buffer.append(")");
            if (i >= split.length) continue;
            buffer.append(Pattern.quote(split[i++]));
        }
        if (additionalRegex != null) {
            buffer.append(additionalRegex);
        }
        this.regex = buffer.toString();
        this.pattern = Pattern.compile(this.getRegex());
    }

    @Override
    public int compareTo(Expression expression) {
        if (this.literalCharacters > expression.literalCharacters) {
            return -1;
        }
        if (this.literalCharacters < expression.literalCharacters) {
            return 1;
        }
        if (this.numCapturingGroups > expression.numCapturingGroups) {
            return -1;
        }
        if (this.numCapturingGroups < expression.numCapturingGroups) {
            return 1;
        }
        if (this.numNonDefaultGroups > expression.numNonDefaultGroups) {
            return -1;
        }
        if (this.numNonDefaultGroups < expression.numNonDefaultGroups) {
            return 1;
        }
        return 0;
    }

    protected static int groupCount(String regex) {
        int idxClose;
        regex = " " + regex;
        int idxOpen = regex.indexOf(91);
        if (idxOpen != -1 && (idxClose = regex.indexOf(93, idxOpen)) != -1) {
            regex = regex.substring(0, idxOpen) + regex.substring(idxClose + 1);
        }
        Matcher matcher = GROUP.matcher(regex);
        int groupCount = 0;
        while (matcher.find()) {
            ++groupCount;
        }
        return groupCount;
    }

    public boolean isStatic() {
        return this.groups.isEmpty();
    }

    public int getNumGroups() {
        return this.groups.size();
    }

    public String getRegex() {
        return this.regex;
    }

    public String getPathExpression() {
        return this.pathExpression;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.registry.Expression", Expression.class, null, null);
        GROUP = Pattern.compile("[^\\\\]\\([^?]");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    protected static class Group {
        int group;
        String name;
        boolean storePathSegment;
        static final long serialVersionUID = -3390668681513478536L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected Group(int group, String name) {
            this.group = group;
            this.name = name;
        }

        protected Group(int group, String name, boolean storePathSegment) {
            this.group = group;
            this.name = name;
            this.storePathSegment = storePathSegment;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.registry.Expression$Group", Group.class, null, null);
        }
    }
}

