/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal.proxy.extractors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Method;
import org.jboss.resteasy.annotations.ResponseObject;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.BodyEntityExtractor;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ClientContext;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.EntityExtractor;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.EntityExtractorFactory;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ResponseObjectEntityExtractorFactory;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ResponseObjectProxy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class DefaultEntityExtractorFactory
implements EntityExtractorFactory {
    public static final EntityExtractor clientResponseExtractor;
    static final long serialVersionUID = 7862825894036996814L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static EntityExtractor<Response.Status> createStatusExtractor(final boolean release) {
        return new EntityExtractor<Response.Status>(){
            static final long serialVersionUID = 2039350023190187789L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Response.Status extractEntity(ClientContext context, Object ... args) {
                if (release) {
                    context.getClientResponse().close();
                }
                return Response.Status.fromStatusCode((int)context.getClientResponse().getStatus());
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.DefaultEntityExtractorFactory$2", 2.class, null, null);
            }
        };
    }

    public static final EntityExtractor createVoidExtractor() {
        return new EntityExtractor(){
            static final long serialVersionUID = 1019624112117643379L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Object extractEntity(ClientContext context, Object ... args) {
                ClientResponse response = context.getClientResponse();
                int status = response.getStatus();
                if (status >= 400) {
                    response.bufferEntity();
                    response.close();
                    ClientInvocation.handleErrorStatus(response);
                }
                response.close();
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.DefaultEntityExtractorFactory$3", 3.class, null, null);
            }
        };
    }

    @Override
    public EntityExtractor createExtractor(Method method) {
        Class<?> returnType = method.getReturnType();
        if (DefaultEntityExtractorFactory.isVoidReturnType(returnType)) {
            return DefaultEntityExtractorFactory.createVoidExtractor();
        }
        if (returnType.equals(Response.Status.class)) {
            return DefaultEntityExtractorFactory.createStatusExtractor(true);
        }
        if (Response.class.isAssignableFrom(returnType)) {
            return clientResponseExtractor;
        }
        if (returnType.isInterface() && returnType.isAnnotationPresent(ResponseObject.class)) {
            return new ResponseObjectProxy(method, new ResponseObjectEntityExtractorFactory());
        }
        return new BodyEntityExtractor(method);
    }

    protected EntityExtractor createResponseTypeEntityExtractor(Method method) {
        return new EntityExtractor<Response>(){
            static final long serialVersionUID = -8824474771006989448L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Response extractEntity(ClientContext context, Object ... args) {
                return context.getClientResponse();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.DefaultEntityExtractorFactory$4", 4.class, null, null);
            }
        };
    }

    public static final boolean isVoidReturnType(Class<?> returnType) {
        return returnType == null || Void.TYPE.equals(returnType) || Void.class.equals(returnType);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.DefaultEntityExtractorFactory", DefaultEntityExtractorFactory.class, null, null);
        clientResponseExtractor = new EntityExtractor<ClientResponse>(){
            static final long serialVersionUID = 5294805178927997898L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClientResponse extractEntity(ClientContext context, Object ... args) {
                return context.getClientResponse();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.DefaultEntityExtractorFactory$1", 1.class, null, null);
            }
        };
    }
}

