/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.io.IOException;
import java.net.URI;
import org.jboss.resteasy.client.jaxrs.i18n.LogMessages;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.spi.ClientConfigProvider;
import org.jboss.resteasy.util.BasicAuthHelper;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ClientConfigProviderFilter
implements ClientRequestFilter {
    private final ClientConfigProvider clientConfigProvider;
    static final long serialVersionUID = -2883820013692048204L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ClientConfigProviderFilter(ClientConfigProvider clientConfigProvider) {
        this.clientConfigProvider = clientConfigProvider;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (requestContext.getHeaderString("Authorization") == null) {
            URI uri = requestContext.getUri();
            if (uri == null) {
                LogMessages.LOGGER.warn(Messages.MESSAGES.unableToLoadClientConfigProviderConfiguration());
                return;
            }
            String token = this.clientConfigProvider.getBearerToken(uri);
            if (token != null) {
                requestContext.getHeaders().putSingle((Object)"Authorization", (Object)("Bearer " + token));
            } else {
                String username = this.clientConfigProvider.getUsername(uri);
                String password = this.clientConfigProvider.getPassword(uri);
                if (username != null && password != null) {
                    requestContext.getHeaders().putSingle((Object)"Authorization", (Object)BasicAuthHelper.createHeader(username, password));
                }
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.ClientConfigProviderFilter", ClientConfigProviderFilter.class, null, null);
    }
}

