/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.restfulWS.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import io.openliberty.restfulWS.introspector.RESTfulEndpointLoggingIntrospector;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class RestfulWSUtils {
    private static final TraceComponent tc = Tr.register(RestfulWSUtils.class, null, null);
    static final long serialVersionUID = -1052264642776337927L;

    @FFDCIgnore(value={NoClassDefFoundError.class})
    public static void logEndpoints(ServletConfig servletConfig) {
        RESTfulEndpointLoggingIntrospector introspector = RestfulWSUtils.getRESTfulEndpointLoggingIntrospector();
        if (introspector != null) {
            ServletContext sc = servletConfig.getServletContext();
            String appname = sc.getServletContextName();
            String contextRoot = sc.getContextPath();
            String servletName = servletConfig.getServletName();
            String servletMapping = servletConfig.getInitParameter("resteasy.servlet.mapping.prefix");
            String resourceList = servletConfig.getInitParameter("resteasy.scanned.resources");
            String[] resources = null;
            if (resourceList != null) {
                resources = resourceList.split(",");
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Endpoints for Application: ").append(appname).append(" - ").append(servletName).append("\n");
            if (resources != null) {
                for (String clazz : resources) {
                    Method[] methods;
                    Class<?> resource = RestfulWSUtils.loadClass(clazz, sb);
                    if (resource == null) continue;
                    sb.append(resource.getName()).append("\n");
                    String classPath = RestfulWSUtils.getAnnotationValue(resource, Path.class, String.class);
                    String[] classConsumes = RestfulWSUtils.getAnnotationValue(resource, Consumes.class, String[].class);
                    String[] classProduces = RestfulWSUtils.getAnnotationValue(resource, Produces.class, String[].class);
                    for (Method m : methods = RestfulWSUtils.getMethods(resource)) {
                        String httpMethod = RestfulWSUtils.getHttpMethod(m);
                        if (httpMethod == null) continue;
                        String methodPath = RestfulWSUtils.getAnnotationValue(m, Path.class, String.class);
                        String[] consumes = RestfulWSUtils.getAnnotationValue(m, Consumes.class, String[].class);
                        String[] produces = RestfulWSUtils.getAnnotationValue(m, Produces.class, String[].class);
                        sb.append(httpMethod).append("\t");
                        if (contextRoot.length() > 0 && !contextRoot.startsWith("/")) {
                            sb.append("/");
                        }
                        sb.append(contextRoot);
                        if (servletMapping.length() > 0 && !servletMapping.startsWith("/")) {
                            sb.append("/");
                        }
                        sb.append(servletMapping);
                        if (classPath != null) {
                            if (classPath.length() > 0 && !classPath.startsWith("/")) {
                                sb.append("/");
                            }
                            sb.append(classPath);
                        }
                        if (methodPath != null) {
                            if (methodPath.length() > 0 && !methodPath.startsWith("/")) {
                                sb.append("/");
                            }
                            sb.append(methodPath);
                        }
                        sb.append(" - ");
                        sb.append(resource.getName()).append(".").append(m.getName()).append("(");
                        int i = 0;
                        for (Parameter p : m.getParameters()) {
                            if (i > 0) {
                                sb.append(", ");
                            }
                            sb.append(p.getType().getName());
                            ++i;
                        }
                        sb.append(") return=").append(m.getReturnType().getName()).append(" ");
                        i = 0;
                        sb.append(" consumes={");
                        RestfulWSUtils.appendMediaTypes(classConsumes, sb, i);
                        RestfulWSUtils.appendMediaTypes(consumes, sb, i);
                        sb.append("} ");
                        i = 0;
                        sb.append("produces={");
                        RestfulWSUtils.appendMediaTypes(classProduces, sb, i);
                        RestfulWSUtils.appendMediaTypes(produces, sb, i);
                        sb.append("}\n");
                    }
                    sb.append("\n");
                }
            }
            introspector.addEndpoints(servletConfig, sb);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.info((TraceComponent)tc, (String)sb.toString(), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unable to find LibertyResteasyEndpointLoggingIntrospector", (Object[])new Object[0]);
        }
    }

    private static RESTfulEndpointLoggingIntrospector getRESTfulEndpointLoggingIntrospector() {
        return AccessController.doPrivileged(new PrivilegedAction<RESTfulEndpointLoggingIntrospector>(){
            static final long serialVersionUID = -2088973336016668127L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public RESTfulEndpointLoggingIntrospector run() {
                try {
                    Bundle b = FrameworkUtil.getBundle(ResourceMethodRegistry.class);
                    if (b != null) {
                        BundleContext bc = b.getBundleContext();
                        ServiceReference sr = bc.getServiceReference(RESTfulEndpointLoggingIntrospector.class);
                        return (RESTfulEndpointLoggingIntrospector)bc.getService(sr);
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.restfulWS.utils.RestfulWSUtils$1", 1.class, null, null);
            }
        });
    }

    private static Class<?> loadClass(final String clazz, final StringBuffer sb) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){
            static final long serialVersionUID = 4661506292449327237L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Class<?> run() {
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass(clazz);
                }
                catch (ClassNotFoundException e) {
                    sb.append("ERROR WHILE INTROSPECTING - ").append(e.getMessage());
                    return null;
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.restfulWS.utils.RestfulWSUtils$2", 2.class, null, null);
            }
        });
    }

    private static Method[] getMethods(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){
            static final long serialVersionUID = 6671819909698504647L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.restfulWS.utils.RestfulWSUtils$3", 3.class, null, null);
            }
        });
    }

    private static String getHttpMethod(Method m) {
        String httpMethod = null;
        for (Annotation annotation : m.getAnnotations()) {
            if (annotation.annotationType().equals(DELETE.class)) {
                httpMethod = "DELETE";
            }
            if (annotation.annotationType().equals(GET.class)) {
                httpMethod = "GET";
            }
            if (annotation.annotationType().equals(HEAD.class)) {
                httpMethod = "HEAD";
            }
            if (annotation.annotationType().equals(OPTIONS.class)) {
                httpMethod = "OPTIONS";
            }
            if (annotation.annotationType().equals(PATCH.class)) {
                httpMethod = "PATCH";
            }
            if (annotation.annotationType().equals(POST.class)) {
                httpMethod = "POST";
            }
            if (!annotation.annotationType().equals(PUT.class)) continue;
            httpMethod = "PUT";
        }
        return httpMethod;
    }

    public static <T> T getAnnotationValue(AnnotatedElement element, Class<? extends Annotation> annoType, Class<T> valueType) {
        T value = null;
        if (element.isAnnotationPresent(annoType)) {
            try {
                Method valueMethod = annoType.getMethod("value", new Class[0]);
                Annotation anno = element.getAnnotation(annoType);
                return valueType.cast(valueMethod.invoke((Object)anno, new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    private static void appendMediaTypes(String[] list, StringBuffer sb, int i) {
        if (list != null && list.length > 0) {
            for (String c : list) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("\"").append(c).append("\"");
                ++i;
            }
        }
    }
}

