/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.restfulWS.client.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.ClientRequestContext;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class SamlPropagationHandler {
    private static final TraceComponent tc = Tr.register(SamlPropagationHandler.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
    static final long serialVersionUID = -73155592002578417L;

    @FFDCIgnore(value={NoClassDefFoundError.class})
    public static void configClientSAMLHandler(ClientRequestContext crc) {
        String saml = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Entering SAML Handler - About to get a SAML authentication token from the runAs Subject", (Object[])new Object[0]);
        }
        try {
            saml = SamlPropagationHandler.getEncodedSaml20Token();
            if (saml != null && !saml.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Retrieved the encoded SAML token. About to set it on the request Header " + saml), (Object[])new Object[0]);
                }
                crc.getHeaders().putSingle((Object)"Authorization", (Object)("SAML " + saml));
            }
        }
        catch (NoClassDefFoundError ncdfe) {
            Tr.warning((TraceComponent)tc, (String)"failed_to_extract_saml_token_from_subject", (Object[])new Object[]{ncdfe});
        }
        catch (Throwable e) {
            Tr.warning((TraceComponent)tc, (String)"failed_to_extract_saml_token_from_subject", (Object[])new Object[]{e});
            throw new ProcessingException(e);
        }
    }

    @FFDCIgnore(value={NoSuchMethodException.class})
    public static String getEncodedSaml20Token() {
        String base64Saml = null;
        String samlString = null;
        try {
            Subject subject = WSSubject.getRunAsSubject();
            for (Object credential : subject.getPrivateCredentials()) {
                try {
                    Class<?> credentialClass = credential.getClass();
                    Method method = credentialClass.getDeclaredMethod("getSAMLAsString", new Class[0]);
                    samlString = (String)method.invoke(credential, new Object[0]);
                    break;
                }
                catch (NoSuchMethodException e) {
                }
                catch (Exception e) {
                    Tr.warning((TraceComponent)tc, (String)"failed_to_extract_saml_token_from_subject", (Object[])new Object[]{e.getLocalizedMessage()});
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception while getting SAML token from subject:", (Object[])new Object[]{e.getCause()});
            }
            Tr.warning((TraceComponent)tc, (String)"failed_to_extract_saml_token_from_subject", (Object[])new Object[]{e.getLocalizedMessage()});
        }
        if (samlString != null) {
            byte[] output = samlString.getBytes(StandardCharsets.UTF_8);
            if (output != null) {
                base64Saml = Base64Coder.base64EncodeToString((byte[])output);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error while trying to get token bytes using utf-8:", (Object[])new Object[0]);
            }
        }
        return base64Saml;
    }
}

