/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics.internal.cdi30.interceptors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.astefanutti.metrics.cdi30.MetricResolver;
import io.openliberty.microprofile.metrics.internal.cdi30.helper.Utils;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.annotation.SimplyTimed;

@SimplyTimed
@Interceptor
@Priority(value=1010)
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SimplyTimedInterceptor {
    private final Bean<?> bean;
    private final MetricRegistry registry;
    private final MetricResolver resolver;
    static final long serialVersionUID = 283233270835701679L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Inject
    private SimplyTimedInterceptor(@Intercepted Bean<?> bean, MetricRegistry registry, MetricResolver resolver) {
        this.bean = bean;
        this.registry = registry;
        this.resolver = resolver;
    }

    @AroundConstruct
    private Object timedConstructor(InvocationContext context) throws Exception {
        return this.simplyTimedCallable(context, context.getConstructor());
    }

    @AroundInvoke
    private Object timedMethod(InvocationContext context) throws Exception {
        return this.simplyTimedCallable(context, context.getMethod());
    }

    @AroundTimeout
    private Object timedTimeout(InvocationContext context) throws Exception {
        return this.simplyTimedCallable(context, context.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private <E extends Member & AnnotatedElement> Object simplyTimedCallable(InvocationContext context, E element) throws Exception {
        MetricResolver.Of<SimplyTimed> simplyTimed = this.resolver.simplyTimed(this.bean.getBeanClass(), element);
        MetricID MetricID2 = new MetricID(simplyTimed.metricName(), Utils.tagsToTags(simplyTimed.tags()));
        SimpleTimer simpleTimer = (SimpleTimer)this.registry.getMetric(MetricID2);
        if (simpleTimer == null) {
            try {
                throw new IllegalStateException("No simple timer with metricID [" + MetricID2 + "] found in registry [" + this.registry + "]");
            }
            catch (IllegalStateException illegalStateException) {
                void exception;
                FFDCFilter.processException((Throwable)illegalStateException, (String)"io.openliberty.microprofile.metrics.internal.cdi30.interceptors.SimplyTimedInterceptor", (String)"92", (Object)this, (Object[])new Object[]{context, element});
                throw exception;
            }
        }
        SimpleTimer.Context time = simpleTimer.time();
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            time.stop();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics.internal.cdi30.interceptors.SimplyTimedInterceptor", SimplyTimedInterceptor.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.cdi.resources.MetricsCDI");
    }
}

