/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.utils.comms.ProviderEndPoint;
import java.util.Map;

public class ConnectionProperties {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private ProviderEndPoint endPoint;
    private Object wlmEndPointData;
    private PropertiesType mode;
    private Map clientConnectionProperties = null;
    public static final String CHAIN_NAME_JFAP_TCP = "BootstrapBasicMessaging";
    public static final String CHAIN_NAME_JFAP_SSL_TCP = "BootstrapSecureMessaging";
    public static final String CHAIN_NAME_JFAP_HTTP_TCP = "BootstrapTunneledMessaging";
    public static final String CHAIN_NAME_JFAP_HTTP_SSL_TCP = "BootstrapTunneledSecureMessaging";

    public ConnectionProperties() {
        this.mode = PropertiesType.ZOS_PROXY;
    }

    public ConnectionProperties(ProviderEndPoint endPoint) {
        if (endPoint == null) {
            throw new SIErrorException(nls.getFormattedMessage("NULL_EP_SICO0004", null, "NULL_EP_SICO0004"));
        }
        if (endPoint.getChain() == null) {
            throw new SIErrorException(nls.getFormattedMessage("NULL_CHAIN_SICO0005", null, "NULL_CHAIN_SICO0005"));
        }
        this.endPoint = endPoint;
        this.mode = PropertiesType.HOST_PORT;
    }

    public ConnectionProperties(Object wlmEndPointData) {
        if (wlmEndPointData == null) {
            throw new SIErrorException(nls.getFormattedMessage("NULL_EP_SICO0004", null, "NULL_EP_SICO0004"));
        }
        this.wlmEndPointData = wlmEndPointData;
        this.mode = PropertiesType.WLM_EP;
    }

    public Object getWLMEndPointData() {
        if (this.mode != PropertiesType.WLM_EP) {
            throw new SIErrorException(nls.getFormattedMessage("INVALID_METHOD_FOR_OBJECT_TYPE_SICO0006", null, "INVALID_METHOD_FOR_OBJECT_TYPE_SICO0006"));
        }
        return this.wlmEndPointData;
    }

    public PropertiesType getMode() {
        return this.mode;
    }

    public ProviderEndPoint getEndPoint() {
        if (this.mode != PropertiesType.HOST_PORT) {
            throw new SIErrorException(nls.getFormattedMessage("INVALID_METHOD_FOR_OBJECT_TYPE_SICO0006", null, "INVALID_METHOD_FOR_OBJECT_TYPE_SICO0006"));
        }
        return this.endPoint;
    }

    public String getChainName() {
        if (this.mode != PropertiesType.HOST_PORT) {
            throw new SIErrorException(nls.getFormattedMessage("INVALID_METHOD_FOR_OBJECT_TYPE_SICO0006", null, "INVALID_METHOD_FOR_OBJECT_TYPE_SICO0006"));
        }
        return this.endPoint.getChain();
    }

    public void setClientConnectionPropertyMap(Map clientConnectionProperties) {
        this.clientConnectionProperties = clientConnectionProperties;
    }

    public Map getClientConnectionPropertyMap() {
        return this.clientConnectionProperties;
    }

    public String toString() {
        String s = "ConnectionProperties@" + Integer.toHexString(System.identityHashCode(this)) + ":- ";
        s = s + "Mode: " + (Object)((Object)this.mode);
        if (this.mode == PropertiesType.HOST_PORT) {
            s = s + ", Endpoint: " + this.endPoint;
        } else if (this.mode == PropertiesType.WLM_EP) {
            s = s + ", CFEndpoint: " + this.wlmEndPointData;
        }
        s = s + ", ClientConnectionProperties: " + this.clientConnectionProperties;
        return s;
    }

    public static enum PropertiesType {
        WLM_EP,
        HOST_PORT,
        ZOS_PROXY;

    }
}

