/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.lifecycle;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.messaging.lifecycle.LifecycleError;
import com.ibm.ws.messaging.lifecycle.SingletonAgent;
import com.ibm.wsspi.logging.Introspector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"osgi.command.scope=sib", "osgi.command.function=singletons", "service.vendor=IBM"})
public class SingletonMonitor
implements Introspector,
ConfigurationListener {
    public static final TraceComponent tc = Tr.register(SingletonMonitor.class);
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final int version = counter.incrementAndGet();
    private final Set<String> realizedSingletons = new TreeSet<String>();
    private final ConfigurationAdmin configAdmin;
    private volatile Set<String> declaredSingletons;

    @Activate
    public SingletonMonitor(@Reference(name="configAdmin") ConfigurationAdmin configAdmin) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"SingletonMonitor constructed", (Object[])new Object[0]);
        }
        this.configAdmin = configAdmin;
        this.declaredSingletons = Collections.unmodifiableSet(SingletonMonitor.findDeclaredSingletons(configAdmin));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Declared singletons: " + this.declaredSingletons), (Object[])new Object[0]);
        }
    }

    private static Set<String> findDeclaredSingletons(ConfigurationAdmin configAdmin) {
        Object[] configs;
        try {
            configs = configAdmin.listConfigurations("(service.factoryPid=com.ibm.ws.messaging.lifecycle.SingletonAgent)");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Singleton configs: ", (Object[])new Object[]{Arrays.toString(configs)});
            }
        }
        catch (IOException | InvalidSyntaxException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.messaging.lifecycle.SingletonMonitor.findDeclaredSingletons", (String)"list configs");
            throw new LifecycleError("Could not list declared singletons", e);
        }
        return Stream.of(configs).map(Configuration::getProperties).map(dict -> dict.get("id")).map(String.class::cast).collect(TreeSet::new, Set::add, Set::addAll);
    }

    public void configurationEvent(ConfigurationEvent cfgEvent) {
        Set<String> oldSet = this.declaredSingletons;
        Set<String> newSet = SingletonMonitor.findDeclaredSingletons(this.configAdmin);
        if (newSet.equals(oldSet)) {
            return;
        }
        this.declaredSingletons = newSet;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            TreeSet<String> removed = new TreeSet<String>(oldSet);
            TreeSet<String> added = new TreeSet<String>(newSet);
            TreeSet<String> unmodified = new TreeSet<String>(oldSet);
            removed.removeAll(newSet);
            added.removeAll(oldSet);
            unmodified.removeAll(removed);
            if (unmodified.size() > 0) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Singleton declarations unmodified:", (Object[])new Object[]{unmodified});
            }
            if (removed.size() > 0) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Singleton declarations removed:", (Object[])new Object[]{removed});
            }
            if (added.size() > 0) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Singleton declarations added:", (Object[])new Object[]{added});
            }
        }
    }

    @Deactivate
    public void deactivate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this + " deactivate"), (Object[])new Object[0]);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    synchronized void addRealizedSingleton(SingletonAgent agent) {
        this.realizedSingletons.add(agent.getSingletonType());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)String.format("Realized Singleton added: %s%nDeclared: %s%n:  Realized: %s", agent.getSingletonType(), this.declaredSingletons, this.realizedSingletons), (Object[])new Object[0]);
        }
    }

    synchronized void removeRealizedSingleton(SingletonAgent agent) {
        this.realizedSingletons.remove(agent.getSingletonType());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)String.format("Realized Singleton removed: %s%nDeclared: %s%n  Realized: %s", agent.getSingletonType(), this.declaredSingletons, this.realizedSingletons), (Object[])new Object[0]);
        }
    }

    public String toString() {
        return SingletonMonitor.class.getName() + "#" + this.version;
    }

    public String getIntrospectorName() {
        return "Messaging" + this.getClass().getSimpleName();
    }

    public String getIntrospectorDescription() {
        return String.format("List the declared (D) and the realized (R) messaging singletons.%nMessaging cannot start until all the declared singletons become available (i.e. are realized).", new Object[0]);
    }

    public void introspect(PrintWriter out) throws Exception {
        ((Stream)Stream.concat(this.declaredSingletons.stream(), this.realizedSingletons.stream()).sorted().distinct().sequential()).peek(s -> out.print('[')).peek(s -> out.print(this.declaredSingletons.contains(s) ? (char)'D' : (char)' ')).peek(s -> out.print(this.realizedSingletons.contains(s) ? (char)'R' : (char)' ')).peek(s -> out.print("] ")).forEach(out::println);
    }

    public void singletons() throws Exception {
        System.out.println(this.getIntrospectorName());
        System.out.println(this.getIntrospectorDescription());
        try (PrintWriter pw = new PrintWriter(System.out);){
            this.introspect(pw);
        }
    }
}

