/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.ClassProvider;
import com.ibm.ws.classloading.java2sec.PermissionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.permissions.PermissionsConfig;
import com.ibm.ws.jca.internal.DeferredService;
import com.ibm.ws.jca.internal.ResourceAdapterMetaData;
import com.ibm.ws.jca.internal.Utils;
import com.ibm.ws.jca.rar.ResourceAdapterBundleService;
import com.ibm.ws.jca.utils.xml.metatype.Metatype;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.classloading.GatewayConfiguration;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ResourceAdapterService
extends DeferredService
implements ClassProvider,
MetaTypeProvider {
    private static final TraceComponent tc = Tr.register(ResourceAdapterService.class, (String)"WAS.j2c", (String)"com.ibm.ws.jca.internal.resources.J2CAMessages");
    private static final String PERMISSION_XML = "permissions.xml";
    private PermissionManager permissionManager;
    private ClassLoader classloader;
    private ClassLoadingService classloadingSvc;
    private volatile String id;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private ClassLoaderIdentity rarClassLoaderId;
    private String rarFilePath;
    private volatile BundleContext bundleContext;
    private Bundle bundle;
    private ArtifactContainerFactory _acf;
    private AdaptableModuleFactory _amf;
    private Metatype metatype;
    private ResourceAdapterMetaData ramd;
    private ResourceAdapterBundleService raBundleSvc;
    static final long serialVersionUID = -7509063558542124617L;

    @ManualTrace
    protected void activate(ComponentContext context) throws UnableToAdaptException, MalformedURLException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{context.getProperties()});
        }
        this.id = (String)context.getProperties().get("id");
        this.rarFilePath = (String)context.getProperties().get("location");
        this.bundleContext = Utils.priv.getBundleContext(context);
        this.bundle = this.bundleContext.getBundle();
        this.getClassLoader();
        this.raBundleSvc.setClassLoaderID(this.rarClassLoaderId);
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"activate");
        }
    }

    protected void deactivate(ComponentContext context) throws BundleException {
        this.deregisterDeferredService();
    }

    public boolean rarFileExists() {
        final File zipFile = new File(this.rarFilePath);
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 4974525191203323783L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return zipFile.exists();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jca.internal.ResourceAdapterService$1", 1.class, (String)"WAS.j2c", (String)"com.ibm.ws.jca.internal.resources.J2CAMessages");
            }
        });
    }

    public ClassLoader getClassLoader() throws UnableToAdaptException, MalformedURLException {
        this.lock.readLock().lock();
        try {
            if (this.classloader != null) {
                ClassLoader classLoader = this.classloader;
                return classLoader;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (!this.rarFileExists()) {
            return null;
        }
        this.lock.writeLock().lock();
        try {
            if (this.classloader == null) {
                this.classloader = this.createRarClassLoader();
            }
            ClassLoader classLoader = this.classloader;
            return classLoader;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private ClassLoader createRarClassLoader() throws UnableToAdaptException, MalformedURLException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        File bundleWorkareaRoot = this.bundle.getDataFile("");
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("bundleWorkareaRoot " + bundleWorkareaRoot), (Object[])new Object[0]);
        }
        final Bundle theBundle = this.bundle;
        File[] cacheFiles = AccessController.doPrivileged(new PrivilegedAction<File[]>(){
            static final long serialVersionUID = -3561484488384833396L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public File[] run() {
                return theBundle.getDataFile("").listFiles();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jca.internal.ResourceAdapterService$2", 2.class, (String)"WAS.j2c", (String)"com.ibm.ws.jca.internal.resources.J2CAMessages");
            }
        });
        String cacheSuffix = "-.-." + this.id + "--.-";
        String cacheSuffixMod = cacheSuffix + Long.valueOf(FileUtils.fileLastModified((File)new File(this.rarFilePath))).toString();
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("cacheSuffixMod " + cacheSuffixMod), (Object[])new Object[0]);
        }
        for (File f : cacheFiles) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("bundle file path: " + f.getPath()), (Object[])new Object[0]);
            }
            if (f.getPath().contains(cacheSuffixMod)) {
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"This is a good cache dir for the rar file, keep it", (Object[])new Object[0]);
                continue;
            }
            if (f.getPath().contains(cacheSuffix)) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("This is a cache dir for " + cacheSuffix + " but the modification date is not a match, delete it"), (Object[])new Object[0]);
                }
                if (this.deleteBundleCacheDir(f) || !trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Delete failed for ", (Object[])new Object[]{f, " check previous debug messages"});
                continue;
            }
            if (!trace || !tc.isDebugEnabled()) continue;
            Tr.debug((Object)this, (TraceComponent)tc, (String)("This is NOT a cache dir for " + cacheSuffix + " leave it alone"), (Object[])new Object[0]);
        }
        File rarCacheDir = this.bundle.getDataFile("rarCache" + cacheSuffixMod);
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getDataFile rarCacheDir " + rarCacheDir), (Object[])new Object[0]);
        }
        if (!FileUtils.ensureDirExists((File)rarCacheDir) && trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Cache failed!!!", (Object[])new Object[0]);
        }
        File rarOverlayDirectory = this.bundle.getDataFile("rarOverlayDirectory" + cacheSuffixMod);
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getDataFile rarOverlayDirectory " + rarOverlayDirectory), (Object[])new Object[0]);
        }
        if (!FileUtils.ensureDirExists((File)rarOverlayDirectory) && trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Overlay failed!!!", (Object[])new Object[0]);
        }
        File rarCacheDirForOverlayContent = this.bundle.getDataFile("rarCacheDirForOverlayContent" + cacheSuffixMod);
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getDataFile rarCacheDirForOverlayContent " + rarCacheDirForOverlayContent), (Object[])new Object[0]);
        }
        if (!FileUtils.ensureDirExists((File)rarCacheDirForOverlayContent) && trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Cache for overlay failed!!!", (Object[])new Object[0]);
        }
        ArtifactContainer c = null;
        ArrayList<ArtifactContainer> rarContainers = new ArrayList<ArtifactContainer>();
        c = this._acf.getContainer(rarCacheDir, (Object)new File(this.rarFilePath));
        rarContainers.add(c);
        for (ArtifactEntry ae : c) {
            if (!ae.getPath().toLowerCase().endsWith(".jar")) continue;
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Artifact entry [ " + ae.getPath() + " ]"), (Object[])new Object[0]);
            }
            ArtifactContainer jarEntry = ae.convertToContainer();
            rarContainers.add(jarEntry);
            if (!trace || !tc.isDebugEnabled()) continue;
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Jar entry [ " + jarEntry.getPath() + " ]"), (Object[])new Object[0]);
        }
        ArrayList<Container> classLoaderContainers = new ArrayList<Container>();
        for (ArtifactContainer ac : rarContainers) {
            classLoaderContainers.add(this._amf.getContainer(rarOverlayDirectory, rarCacheDirForOverlayContent, ac));
        }
        GatewayConfiguration gwCfg = this.classloadingSvc.createGatewayConfiguration().setApiTypeVisibility(new ApiType[]{ApiType.SPEC, ApiType.API, ApiType.IBMAPI, ApiType.THIRDPARTY, ApiType.STABLE}).setDynamicImportPackage(new String[]{"*"}).setDelegateToSystem(true);
        this.rarClassLoaderId = this.classloadingSvc.createIdentity("Resource Adapter", this.id);
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Resource adapter [ " + this.rarFilePath + " ]: Class loader ID [ " + this.rarClassLoaderId + " ]"), (Object[])new Object[0]);
        }
        Container rarContainer = this._amf.getContainer(rarOverlayDirectory, rarCacheDirForOverlayContent, c);
        ProtectionDomain protectionDomain = this.getProtectionDomain(rarContainer);
        ClassLoaderConfiguration clCfg = this.classloadingSvc.createClassLoaderConfiguration().setId(this.rarClassLoaderId).setProtectionDomain(protectionDomain);
        ClassLoader rarClassLoader = this.classloadingSvc.createTopLevelClassLoader(classLoaderContainers, gwCfg, clCfg);
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Resource adapter [ " + this.rarFilePath + " ]: Class loader [ " + rarClassLoader + " ]"), (Object[])new Object[0]);
        }
        return rarClassLoader;
    }

    /*
     * WARNING - void declaration
     */
    private ProtectionDomain getProtectionDomain(Container rarContainer) throws UnableToAdaptException, MalformedURLException {
        CodeSource codeSource;
        Permissions perms = new Permissions();
        try {
            String loc = this.rarFilePath;
            codeSource = new CodeSource(new URL("file://" + (loc.startsWith("/") ? "" : "/") + loc), (Certificate[])null);
        }
        catch (MalformedURLException loc) {
            void e;
            FFDCFilter.processException((Throwable)loc, (String)"com.ibm.ws.jca.internal.ResourceAdapterService", (String)"395", (Object)this, (Object[])new Object[]{rarContainer});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"CodeSource could not be created for RA file path of: rarFilePath", (Object[])new Object[]{e});
            }
            throw e;
        }
        if (!this.java2SecurityEnabled()) {
            ((PermissionCollection)perms).add(new AllPermission());
        } else {
            PermissionsConfig permissionsConfig = null;
            try {
                permissionsConfig = (PermissionsConfig)rarContainer.adapt(PermissionsConfig.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void ex;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.jca.internal.ResourceAdapterService", (String)"409", (Object)this, (Object[])new Object[]{rarContainer});
                Tr.error((TraceComponent)tc, (String)"J2CA8817.parse.deployment.descriptor.failed", (Object[])new Object[]{rarContainer.getName(), "META-INF/permissions.xml", ex});
                throw ex;
            }
            if (permissionsConfig != null) {
                List configuredPermissions = permissionsConfig.getPermissions();
                this.addPermissions(codeSource, configuredPermissions);
            }
            ArrayList mergedPermissions = this.permissionManager.getEffectivePermissions(this.rarFilePath);
            int count = mergedPermissions.size();
            for (int i = 0; i < count; ++i) {
                ((PermissionCollection)perms).add((Permission)mergedPermissions.get(i));
            }
        }
        return new ProtectionDomain(codeSource, perms);
    }

    private void addPermissions(CodeSource codeSource, List<com.ibm.ws.javaee.dd.permissions.Permission> configuredPermissions) {
        for (com.ibm.ws.javaee.dd.permissions.Permission permission : configuredPermissions) {
            Permission perm = this.permissionManager.createPermissionObject(permission.getClassName(), permission.getName(), permission.getActions(), null, null, null, PERMISSION_XML);
            if (perm == null) continue;
            this.permissionManager.addPermissionsXMLPermission(codeSource, perm);
        }
    }

    private boolean java2SecurityEnabled() {
        SecurityManager sm = System.getSecurityManager();
        return sm != null;
    }

    protected void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    protected void unsetPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = null;
    }

    private boolean deleteBundleCacheDir(File path) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (FileUtils.fileExists((File)path)) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Path specified exists: " + path.getPath()), (Object[])new Object[0]);
            }
        } else {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Path specified does not exist: " + path.getPath()), (Object[])new Object[0]);
            }
            return true;
        }
        boolean deleteWorked = true;
        for (File file : FileUtils.listFiles((File)path)) {
            if (FileUtils.fileIsDirectory((File)file)) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Delete directory contents: " + file.toString()), (Object[])new Object[0]);
                }
                deleteWorked &= this.deleteBundleCacheDir(file);
                continue;
            }
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Delete file: " + file.toString()), (Object[])new Object[0]);
            }
            if (FileUtils.fileDelete((File)file)) continue;
            deleteWorked = false;
            if (!trace || !tc.isDebugEnabled()) continue;
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Directory or file not deleted", (Object[])new Object[0]);
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Delete path: " + path), (Object[])new Object[0]);
        }
        if (!FileUtils.fileDelete((File)path)) {
            deleteWorked = false;
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Path not deleted", (Object[])new Object[0]);
            }
        }
        return deleteWorked;
    }

    public <CL extends ClassLoader> CL getDelegateLoader() {
        return (CL)this.classloader;
    }

    public String[] getLocales() {
        return null;
    }

    public ObjectClassDefinition getObjectClassDefinition(String pid, String locale) {
        if (this.metatype != null) {
            return this.metatype.getOcdById(pid).getObjectClassDefinition();
        }
        return null;
    }

    protected void setClassLoadingService(ClassLoadingService svc) {
        this.classloadingSvc = svc;
    }

    void setMetatype(Metatype metatype) {
        this.metatype = metatype;
    }

    protected void unsetClassLoadingService(ClassLoadingService svc) {
        this.classloadingSvc = null;
    }

    protected void setArtifactContainerFactory(ArtifactContainerFactory svc) {
        this._acf = svc;
    }

    protected void unsetArtifactContainerFactory(ArtifactContainerFactory svc) {
        if (svc == this._acf) {
            this._acf = null;
        }
    }

    protected void setAdaptableModuleFactory(AdaptableModuleFactory svc) {
        this._amf = svc;
    }

    protected void unsetAdaptableModuleFactory(AdaptableModuleFactory svc) {
        if (svc == this._amf) {
            this._amf = null;
        }
    }

    protected void setResourceAdapterBundleService(ResourceAdapterBundleService svc) {
        this.raBundleSvc = svc;
    }

    protected void unsetResourceAdapterBundleService(ResourceAdapterBundleService svc) {
        if (svc == this.raBundleSvc) {
            this.raBundleSvc = null;
        }
    }

    protected void setClassLoader(ClassLoader cl) {
        this.classloader = cl;
    }

    public ResourceAdapterMetaData getResourceAdapterMetaData() {
        return this.ramd;
    }

    public void setResourceAdapterMetaData(ResourceAdapterMetaData ramd) {
        this.ramd = ramd;
    }
}

