/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.cdi.extensions;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.security.javaeesec.ApplicationUtils;
import com.ibm.ws.security.javaeesec.cdi.beans.BasicHttpAuthenticationMechanism;
import com.ibm.ws.security.javaeesec.cdi.beans.CustomFormAuthenticationMechanism;
import com.ibm.ws.security.javaeesec.cdi.beans.FormAuthenticationMechanism;
import com.ibm.ws.security.javaeesec.cdi.extensions.AutoApplySessionInterceptor;
import com.ibm.ws.security.javaeesec.cdi.extensions.DatabaseIdentityStoreBean;
import com.ibm.ws.security.javaeesec.cdi.extensions.HttpAuthenticationMechanismsTracker;
import com.ibm.ws.security.javaeesec.cdi.extensions.IdentityStoreHandlerBean;
import com.ibm.ws.security.javaeesec.cdi.extensions.LdapIdentityStoreBean;
import com.ibm.ws.security.javaeesec.cdi.extensions.ModulePropertiesProviderBean;
import com.ibm.ws.security.javaeesec.cdi.extensions.PrimarySecurityCDIExtension;
import com.ibm.ws.security.javaeesec.cdi.extensions.RememberMeInterceptor;
import com.ibm.ws.security.javaeesec.cdi.extensions.SecurityContextProducer;
import com.ibm.ws.security.javaeesec.properties.ModuleProperties;
import com.ibm.ws.threadContext.ModuleMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.metadata.LoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.ws.webcontainer.security.util.WebConfigUtils;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessBeanAttributes;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.security.enterprise.authentication.mechanism.http.BasicAuthenticationMechanismDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.CustomFormAuthenticationMechanismDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.FormAuthenticationMechanismDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.LoginToContinue;
import jakarta.security.enterprise.identitystore.DatabaseIdentityStoreDefinition;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.IdentityStoreHandler;
import jakarta.security.enterprise.identitystore.LdapIdentityStoreDefinition;
import jakarta.security.enterprise.identitystore.PasswordHash;
import jakarta.security.enterprise.identitystore.Pbkdf2PasswordHash;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={WebSphereCDIExtension.class, PrimarySecurityCDIExtension.class}, property={"api.classes=jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;jakarta.security.enterprise.identitystore.IdentityStore;jakarta.security.enterprise.identitystore.IdentityStoreHandler;jakarta.security.enterprise.identitystore.RememberMeIdentityStore;jakarta.security.enterprise.SecurityContext;com.ibm.ws.security.javaeesec.properties.ModulePropertiesProvider", "bean.defining.annotations=jakarta.security.enterprise.authentication.mechanism.http.BasicAuthenticationMechanismDefinition;jakarta.security.enterprise.authentication.mechanism.http.CustomFormAuthenticationMechanismDefinition;jakarta.security.enterprise.authentication.mechanism.http.FormAuthenticationMechanismDefinition;jakarta.security.enterprise.authentication.mechanism.http.LoginToContinue;jakarta.security.enterprise.identitystore.DatabaseIdentityStoreDefinition;jakarta.security.enterprise.identitystore.LdapIdentityStoreDefinition"}, immediate=true)
public class JavaEESecCDIExtension<T>
implements Extension,
WebSphereCDIExtension,
PrimarySecurityCDIExtension {
    private static final TraceComponent tc = Tr.register(JavaEESecCDIExtension.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
    private final Set<Bean> beansToAdd = new HashSet<Bean>();
    private boolean identityStoreHandlerRegistered = false;
    private boolean identityStoreRegistered = false;
    private final boolean isAlternativeHAMAdded = false;
    private final String applicationName;
    private static final String DECORATOR = "Decorator";
    private static final String ALTERNATIVE = "Alternative";
    private final List<LdapIdentityStoreDefinition> ldapDefinitionList = new ArrayList<LdapIdentityStoreDefinition>();
    private final List<DatabaseIdentityStoreDefinition> databaseDefinitionList = new ArrayList<DatabaseIdentityStoreDefinition>();
    private static Set<Class<?>> mechanismClasses;
    private static HttpAuthenticationMechanismsTracker httpAuthenticationMechanismsTracker;
    static final long serialVersionUID = -7018504914861483511L;

    public JavaEESecCDIExtension() {
        this.applicationName = this.getApplicationName();
        httpAuthenticationMechanismsTracker.initialize(this.applicationName);
    }

    protected static void setHttpAuthenticationMechanismsTracker(HttpAuthenticationMechanismsTracker anHttpAuthenticationMechanismsTracker) {
        httpAuthenticationMechanismsTracker = anHttpAuthenticationMechanismsTracker;
    }

    @Override
    public void registerMechanismClass(Class<?> mechanismClass) {
        mechanismClasses.add(mechanismClass);
    }

    @Override
    public void deregisterMechanismClass(Class<?> mechanismClass) {
        mechanismClasses.remove(mechanismClass);
    }

    public void processApplicationHAMClass(@Observes ProcessAnnotatedType<? extends HttpAuthenticationMechanism> processAnnotatedType, BeanManager beanManager) {
        this.processAnnotatedType(processAnnotatedType, beanManager);
    }

    public <T> void processAnnotatedHAMandIS(@Observes @WithAnnotations(value={BasicAuthenticationMechanismDefinition.class, FormAuthenticationMechanismDefinition.class, CustomFormAuthenticationMechanismDefinition.class, LdapIdentityStoreDefinition.class, DatabaseIdentityStoreDefinition.class, LoginToContinue.class}) ProcessAnnotatedType<T> processAnnotatedType, BeanManager beanManager) {
        this.processAnnotatedType(processAnnotatedType, beanManager);
    }

    public <T> void processAnnotatedType(ProcessAnnotatedType<T> processAnnotatedType, BeanManager beanManager) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("instance: " + Integer.toHexString(this.hashCode()) + " BeanManager: " + Integer.toHexString(beanManager.hashCode())), (Object[])new Object[0]);
        }
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("annotationType: " + annotatedType), (Object[])new Object[0]);
        }
        Class javaClass = annotatedType.getJavaClass();
        boolean isAuthMechOverridden = this.isAuthMechOverridden();
        boolean isApplicationAuthMech = this.isApplicationAuthMech(javaClass);
        Set annotations = annotatedType.getAnnotations();
        if (isApplicationAuthMech) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found an application specific HttpAuthenticationMechanism: " + javaClass), (Object[])new Object[0]);
            }
            if (isAuthMechOverridden) {
                this.createModulePropertiesProviderBeanForGlobalLogin(beanManager, javaClass, annotations);
            } else {
                Annotation ltc = annotatedType.getAnnotation(LoginToContinue.class);
                this.createModulePropertiesProviderBeanForApplicationAuthMechToAdd(beanManager, ltc, javaClass, annotations);
            }
        }
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Annotations found: " + annotation), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)"Annotation class: ", (Object[])new Object[]{annotation.getClass()});
            }
            if (BasicAuthenticationMechanismDefinition.class.equals(annotationType = annotation.annotationType())) {
                if (isAuthMechOverridden) {
                    this.createModulePropertiesProviderBeanForGlobalLogin(beanManager, javaClass, annotations);
                    continue;
                }
                this.createModulePropertiesProviderBeanForBasicToAdd(beanManager, annotation, annotationType, javaClass, annotations);
                continue;
            }
            if (FormAuthenticationMechanismDefinition.class.equals(annotationType) || CustomFormAuthenticationMechanismDefinition.class.equals(annotationType)) {
                if (isAuthMechOverridden) {
                    this.createModulePropertiesProviderBeanForGlobalLogin(beanManager, javaClass, annotations);
                    continue;
                }
                this.createModulePropertiesProviderBeanForFormToAdd(beanManager, annotation, annotationType, javaClass, annotations);
                continue;
            }
            if (LdapIdentityStoreDefinition.class.equals(annotationType)) {
                this.createLdapIdentityStoreBeanToAdd(beanManager, annotation, annotationType);
                this.identityStoreRegistered = true;
                continue;
            }
            if (!DatabaseIdentityStoreDefinition.class.equals(annotationType)) continue;
            this.createDatabaseIdentityStoreBeanToAdd(beanManager, annotation, annotationType);
            this.identityStoreRegistered = true;
        }
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        AnnotatedType securityContextProducerType = beanManager.createAnnotatedType(SecurityContextProducer.class);
        beforeBeanDiscovery.addAnnotatedType(securityContextProducerType, SecurityContextProducer.class.getName() + ":" + this.getClass().getClassLoader().hashCode());
        AnnotatedType autoApplySessionInterceptorType = beanManager.createAnnotatedType(AutoApplySessionInterceptor.class);
        beforeBeanDiscovery.addAnnotatedType(autoApplySessionInterceptorType, AutoApplySessionInterceptor.class.getName() + ":" + this.getClass().getClassLoader().hashCode());
        AnnotatedType rememberMeInterceptorInterceptorType = beanManager.createAnnotatedType(RememberMeInterceptor.class);
        beforeBeanDiscovery.addAnnotatedType(rememberMeInterceptorInterceptorType, RememberMeInterceptor.class.getName() + ":" + this.getClass().getClassLoader().hashCode());
    }

    /*
     * WARNING - void declaration
     */
    public <T> void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("instance: " + Integer.toHexString(this.hashCode()) + " BeanManager: " + Integer.toHexString(beanManager.hashCode())), (Object[])new Object[0]);
        }
        try {
            this.verifyConfiguration();
            if (!this.identityStoreHandlerRegistered) {
                this.beansToAdd.add(new IdentityStoreHandlerBean(beanManager));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"registering the default IdentityStoreHandler.", (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"IdentityStoreHandler is not registered because a custom IdentityStoreHandler has been registered,", (Object[])new Object[0]);
            }
        }
        catch (DeploymentException deploymentException) {
            void de;
            FFDCFilter.processException((Throwable)deploymentException, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"223", (Object)this, (Object[])new Object[]{afterBeanDiscovery, beanManager});
            afterBeanDiscovery.addDefinitionError((Throwable)de);
        }
        if (!httpAuthenticationMechanismsTracker.isEmptyModuleMap(this.applicationName)) {
            ModulePropertiesProviderBean bean = new ModulePropertiesProviderBean(beanManager, httpAuthenticationMechanismsTracker.getModuleMap(this.applicationName));
            this.beansToAdd.add(bean);
            ApplicationUtils.registerApplication((String)this.getApplicationName());
        }
        for (Bean bean : this.beansToAdd) {
            afterBeanDiscovery.addBean(bean);
        }
        if (tc.isDebugEnabled()) {
            this.printBeans(beanManager, "After addBean()");
        }
    }

    void printBeans(BeanManager beanManager, String stage) {
        Set beans = beanManager.getBeans(Object.class, new Annotation[]{new AnnotationLiteral<Any>(){
            static final long serialVersionUID = 8036129841398372157L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension$1", 1.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
            }
        }});
        for (Bean bean : beans) {
            Tr.debug((TraceComponent)tc, (String)(stage + " bean name: " + bean.getBeanClass().getName()), (Object[])new Object[0]);
        }
    }

    public void processBean(@Observes ProcessBean<?> processBean, BeanManager beanManager) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("instance: " + Integer.toHexString(this.hashCode()) + " BeanManager: " + Integer.toHexString(beanManager.hashCode())), (Object[])new Object[0]);
        }
        if (!this.identityStoreHandlerRegistered && this.isIdentityStoreHandler(processBean)) {
            this.identityStoreHandlerRegistered = true;
        }
        if (!this.identityStoreRegistered && this.isIdentityStore(processBean)) {
            this.identityStoreRegistered = true;
        }
    }

    public void processBasicHttpAuthMechNeeded(@Observes ProcessBeanAttributes<BasicHttpAuthenticationMechanism> processBeanAttributes, BeanManager beanManager) {
        if (!this.existAuthMech(this.applicationName, BasicHttpAuthenticationMechanism.class)) {
            processBeanAttributes.veto();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"BasicHttpAuthenticationMechanism is disabled since another HttpAuthorizationMechanism is registered.", (Object[])new Object[0]);
            }
        }
    }

    public void processFormAuthMechNeeded(@Observes ProcessBeanAttributes<FormAuthenticationMechanism> processBeanAttributes, BeanManager beanManager) {
        if (!this.existAuthMech(this.applicationName, FormAuthenticationMechanism.class)) {
            processBeanAttributes.veto();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"FormAuthenticationMechanism is disabled since another HttpAuthorizationMechanism is registered.", (Object[])new Object[0]);
            }
        }
    }

    public void processCustomFormAuthMechNeeded(@Observes ProcessBeanAttributes<CustomFormAuthenticationMechanism> processBeanAttributes, BeanManager beanManager) {
        if (!this.existAuthMech(this.applicationName, CustomFormAuthenticationMechanism.class)) {
            processBeanAttributes.veto();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"CustomFormAuthenticationMechanism is disabled since another HttpAuthorizationMechanism is registered.", (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> void createModulePropertiesProviderBeanForFormToAdd(BeanManager beanManager, Annotation annotation, Class<? extends Annotation> annotationType, Class<?> annotatedClass, Set<Annotation> annotations) {
        try {
            Method loginToContinueMethod = annotationType.getMethod("loginToContinue", new Class[0]);
            Annotation ltcAnnotation = (Annotation)loginToContinueMethod.invoke((Object)annotation, new Object[0]);
            Properties props = this.parseLoginToContinue(ltcAnnotation);
            Class implClass = FormAuthenticationMechanismDefinition.class.equals(annotationType) ? FormAuthenticationMechanism.class : CustomFormAuthenticationMechanism.class;
            this.addAuthMech(this.applicationName, annotatedClass, implClass, annotations, props);
        }
        catch (Exception loginToContinueMethod) {
            void e;
            FFDCFilter.processException((Throwable)loginToContinueMethod, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"313", (Object)this, (Object[])new Object[]{beanManager, annotation, annotationType, annotatedClass, annotations});
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createModulePropertiesProviderBeanForBasicToAdd(BeanManager beanManager, Annotation annotation, Class<? extends Annotation> annotationType, Class annotatedClass, Set<Annotation> annotations) {
        try {
            Method realmNameMethod = annotationType.getMethod("realmName", new Class[0]);
            String realmName = (String)realmNameMethod.invoke((Object)annotation, new Object[0]);
            Properties props = new Properties();
            props.put("realmName", realmName);
            this.addAuthMech(this.applicationName, annotatedClass, BasicHttpAuthenticationMechanism.class, annotations, props);
        }
        catch (Exception realmNameMethod) {
            void e;
            FFDCFilter.processException((Throwable)realmNameMethod, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"334", (Object)this, (Object[])new Object[]{beanManager, annotation, annotationType, annotatedClass, annotations});
            e.printStackTrace();
        }
    }

    private void addDecoratOrAlternativeProps(Set<Annotation> annotations, Properties props) {
        for (Annotation annt : annotations) {
            Class<? extends Annotation> annType = annt.annotationType();
            if (DECORATOR.equals(annType.getSimpleName())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Add Decorator=true", (Object[])new Object[0]);
                }
                props.put(DECORATOR, (Object)true);
                continue;
            }
            if (!ALTERNATIVE.equals(annType.getSimpleName())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Add Alternative=true", (Object[])new Object[0]);
            }
            props.put(ALTERNATIVE, (Object)true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createModulePropertiesProviderBeanForApplicationAuthMechToAdd(BeanManager beanManager, Annotation ltc, Class implClass, Set<Annotation> annotations) {
        Properties props = null;
        if (ltc != null) {
            try {
                props = this.parseLoginToContinue(ltc);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"373", (Object)this, (Object[])new Object[]{beanManager, ltc, implClass, annotations});
                e.printStackTrace();
            }
        }
        if (props == null) {
            props = new Properties();
        }
        this.addAuthMech(this.applicationName, implClass, implClass, annotations, props);
    }

    /*
     * WARNING - void declaration
     */
    private void createModulePropertiesProviderBeanForGlobalLogin(BeanManager beanManager, Class annotatedClass, Set<Annotation> annotations) {
        try {
            Class implClass;
            Properties props;
            if (this.isAuthMechOverriddenByForm()) {
                props = this.getGlobalLoginFormProps();
                implClass = FormAuthenticationMechanism.class;
            } else {
                props = this.getGlobalLoginBasicProps();
                implClass = BasicHttpAuthenticationMechanism.class;
            }
            this.addAuthMech(this.applicationName, annotatedClass, implClass, annotations, props);
        }
        catch (Exception props) {
            void e;
            FFDCFilter.processException((Throwable)props, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"404", (Object)this, (Object[])new Object[]{beanManager, annotatedClass, annotations});
            e.printStackTrace();
        }
    }

    @Override
    public void addAuthMech(String applicationName, Class<?> annotatedClass, Class<?> implClass, Set<Annotation> annotations, Properties props) {
        if (props == null) {
            props = new Properties();
        }
        this.addDecoratOrAlternativeProps(annotations, props);
        httpAuthenticationMechanismsTracker.addAuthMech(applicationName, annotatedClass, implClass, annotations, props);
    }

    private Properties parseLoginToContinue(Annotation ltcAnnotation) throws Exception {
        Properties props = new Properties();
        Class<? extends Annotation> ltcAnnotationType = ltcAnnotation.annotationType();
        props.put("loginPage", this.getAnnotatedString(ltcAnnotation, ltcAnnotationType, "loginPage"));
        props.put("errorPage", this.getAnnotatedString(ltcAnnotation, ltcAnnotationType, "errorPage"));
        props.put("useForwardToLoginExpression", this.getAnnotatedString(ltcAnnotation, ltcAnnotationType, "useForwardToLoginExpression"));
        props.put("useForwardToLogin", (Object)this.getAnnotatedBoolean(ltcAnnotation, ltcAnnotationType, "useForwardToLogin"));
        return props;
    }

    /*
     * WARNING - void declaration
     */
    private String getAnnotatedString(final Annotation annotation, final Class<? extends Annotation> annotationType, final String element) throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
                static final long serialVersionUID = -9011428400607275080L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
                    return (String)annotationType.getMethod(element, new Class[0]).invoke((Object)annotation, new Object[0]);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension$2", 2.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"443", (Object)this, (Object[])new Object[]{annotation, annotationType, element});
            throw e.getException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean getAnnotatedBoolean(final Annotation annotation, final Class<? extends Annotation> annotationType, final String element) throws Exception {
        try {
            Boolean result = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                static final long serialVersionUID = -5603734238780290483L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
                    return (Boolean)annotationType.getMethod(element, new Class[0]).invoke((Object)annotation, new Object[0]);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension$3", 3.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
                }
            });
            return result;
        }
        catch (PrivilegedActionException result) {
            void e;
            FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"457", (Object)this, (Object[])new Object[]{annotation, annotationType, element});
            throw e.getException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createLdapIdentityStoreBeanToAdd(BeanManager beanManager, Annotation annotation, Class<? extends Annotation> annotationType) {
        try {
            Method[] methods;
            HashMap<String, Object> identityStoreProperties = new HashMap<String, Object>();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JavaEESec.createLdapISBeanToAdd", (Object[])new Object[0]);
            }
            for (Method m : methods = annotationType.getMethods()) {
                Tr.debug((TraceComponent)tc, (String)m.getName(), (Object[])new Object[0]);
                if (m.getName().equals("equals")) continue;
                identityStoreProperties.put(m.getName(), m.invoke((Object)annotation, new Object[0]));
            }
            LdapIdentityStoreDefinition ldapDefinition = this.getInstanceOfAnnotation(identityStoreProperties);
            if (!this.containsLdapDefinition(ldapDefinition, this.ldapDefinitionList)) {
                this.ldapDefinitionList.add(ldapDefinition);
                LdapIdentityStoreBean bean = new LdapIdentityStoreBean(beanManager, ldapDefinition);
                this.beansToAdd.add(bean);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"registering the default LdapIdentityStore.", (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"the same annotation exists, skip registering..", (Object[])new Object[0]);
            }
        }
        catch (Exception identityStoreProperties) {
            void e;
            FFDCFilter.processException((Throwable)identityStoreProperties, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"489", (Object)this, (Object[])new Object[]{beanManager, annotation, annotationType});
            e.printStackTrace();
        }
    }

    private boolean containsLdapDefinition(LdapIdentityStoreDefinition ldapDefinition, List<LdapIdentityStoreDefinition> ldapDefinitionList) {
        for (LdapIdentityStoreDefinition lisd : ldapDefinitionList) {
            if (!this.equalsLdapDefinition(ldapDefinition, lisd)) continue;
            return true;
        }
        return false;
    }

    private LdapIdentityStoreDefinition getInstanceOfAnnotation(final Map<String, Object> overrides) {
        LdapIdentityStoreDefinition annotation = new LdapIdentityStoreDefinition(){
            static final long serialVersionUID = 510460732074025260L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Class<? extends Annotation> annotationType() {
                return null;
            }

            public String bindDn() {
                return overrides != null && overrides.containsKey("bindDn") ? (String)overrides.get("bindDn") : "";
            }

            @Sensitive
            public String bindDnPassword() {
                return overrides != null && overrides.containsKey("bindDnPassword") ? (String)overrides.get("bindDnPassword") : "";
            }

            public String callerBaseDn() {
                return overrides != null && overrides.containsKey("callerBaseDn") ? (String)overrides.get("callerBaseDn") : "";
            }

            public String callerNameAttribute() {
                return overrides != null && overrides.containsKey("callerNameAttribute") ? (String)overrides.get("callerNameAttribute") : "uid";
            }

            public String callerSearchBase() {
                return overrides != null && overrides.containsKey("callerSearchBase") ? (String)overrides.get("callerSearchBase") : "";
            }

            public String callerSearchFilter() {
                return overrides != null && overrides.containsKey("callerSearchFilter") ? (String)overrides.get("callerSearchFilter") : "";
            }

            public LdapIdentityStoreDefinition.LdapSearchScope callerSearchScope() {
                return overrides != null && overrides.containsKey("callerSearchScope") ? (LdapIdentityStoreDefinition.LdapSearchScope)overrides.get("callerSearchScope") : LdapIdentityStoreDefinition.LdapSearchScope.SUBTREE;
            }

            public String callerSearchScopeExpression() {
                return overrides != null && overrides.containsKey("callerSearchScopeExpression") ? (String)overrides.get("callerSearchScopeExpression") : "";
            }

            public String groupMemberAttribute() {
                return overrides != null && overrides.containsKey("groupMemberAttribute") ? (String)overrides.get("groupMemberAttribute") : "member";
            }

            public String groupMemberOfAttribute() {
                return overrides != null && overrides.containsKey("groupMemberOfAttribute") ? (String)overrides.get("groupMemberOfAttribute") : "memberOf";
            }

            public String groupNameAttribute() {
                return overrides != null && overrides.containsKey("groupNameAttribute") ? (String)overrides.get("groupNameAttribute") : "cn";
            }

            public String groupSearchBase() {
                return overrides != null && overrides.containsKey("groupSearchBase") ? (String)overrides.get("groupSearchBase") : "";
            }

            public String groupSearchFilter() {
                return overrides != null && overrides.containsKey("groupSearchFilter") ? (String)overrides.get("groupSearchFilter") : "";
            }

            public LdapIdentityStoreDefinition.LdapSearchScope groupSearchScope() {
                return overrides != null && overrides.containsKey("groupSearchScope") ? (LdapIdentityStoreDefinition.LdapSearchScope)overrides.get("groupSearchScope") : LdapIdentityStoreDefinition.LdapSearchScope.SUBTREE;
            }

            public String groupSearchScopeExpression() {
                return overrides != null && overrides.containsKey("groupSearchScopeExpression") ? (String)overrides.get("groupSearchScopeExpression") : "";
            }

            public int maxResults() {
                return overrides != null && overrides.containsKey("maxResults") ? (Integer)overrides.get("maxResults") : 1000;
            }

            public String maxResultsExpression() {
                return overrides != null && overrides.containsKey("maxResultsExpression") ? (String)overrides.get("maxResultsExpression") : "";
            }

            public int priority() {
                return overrides != null && overrides.containsKey("priority") ? (Integer)overrides.get("priority") : 80;
            }

            public String priorityExpression() {
                return overrides != null && overrides.containsKey("priorityExpression") ? (String)overrides.get("priorityExpression") : "";
            }

            public int readTimeout() {
                return overrides != null && overrides.containsKey("readTimeout") ? (Integer)overrides.get("readTimeout") : 0;
            }

            public String readTimeoutExpression() {
                return overrides != null && overrides.containsKey("readTimeoutExpression") ? (String)overrides.get("readTimeoutExpression") : "";
            }

            public String url() {
                return overrides != null && overrides.containsKey("url") ? (String)overrides.get("url") : "";
            }

            public IdentityStore.ValidationType[] useFor() {
                IdentityStore.ValidationType[] validationTypeArray;
                if (overrides != null && overrides.containsKey("useFor")) {
                    validationTypeArray = (IdentityStore.ValidationType[])overrides.get("useFor");
                } else {
                    IdentityStore.ValidationType[] validationTypeArray2 = new IdentityStore.ValidationType[2];
                    validationTypeArray2[0] = IdentityStore.ValidationType.PROVIDE_GROUPS;
                    validationTypeArray = validationTypeArray2;
                    validationTypeArray2[1] = IdentityStore.ValidationType.VALIDATE;
                }
                return validationTypeArray;
            }

            public String useForExpression() {
                return overrides != null && overrides.containsKey("useForExpression") ? (String)overrides.get("useForExpression") : "";
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension$4", 4.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
            }
        };
        return annotation;
    }

    protected boolean equalsLdapDefinition(LdapIdentityStoreDefinition lisd1, LdapIdentityStoreDefinition lisd2) {
        return lisd1.bindDn().equals(lisd2.bindDn()) && lisd1.bindDnPassword().equals(lisd2.bindDnPassword()) && lisd1.callerBaseDn().equals(lisd2.callerBaseDn()) && lisd1.callerNameAttribute().equals(lisd2.callerNameAttribute()) && lisd1.callerSearchBase().equals(lisd2.callerSearchBase()) && lisd1.callerSearchFilter().equals(lisd2.callerSearchFilter()) && lisd1.callerSearchScope().equals((Object)lisd2.callerSearchScope()) && lisd1.callerSearchScopeExpression().equals(lisd2.callerSearchScopeExpression()) && lisd1.groupMemberAttribute().equals(lisd2.groupMemberAttribute()) && lisd1.groupMemberOfAttribute().equals(lisd2.groupMemberOfAttribute()) && lisd1.groupNameAttribute().equals(lisd2.groupNameAttribute()) && lisd1.groupSearchBase().equals(lisd2.groupSearchBase()) && lisd1.groupSearchFilter().equals(lisd2.groupSearchFilter()) && lisd1.groupSearchScope().equals((Object)lisd2.groupSearchScope()) && lisd1.groupSearchScopeExpression().equals(lisd2.groupSearchScopeExpression()) && lisd1.maxResults() == lisd2.maxResults() && lisd1.maxResultsExpression().equals(lisd2.maxResultsExpression()) && lisd1.priority() == lisd2.priority() && lisd1.priorityExpression().equals(lisd2.priorityExpression()) && lisd1.readTimeout() == lisd2.readTimeout() && lisd1.readTimeoutExpression().equals(lisd2.readTimeoutExpression()) && lisd1.url().equals(lisd2.url()) && this.equalsUseFor(lisd1.useFor(), lisd2.useFor()) && lisd1.useForExpression().equals(lisd2.useForExpression());
    }

    private boolean equalsUseFor(IdentityStore.ValidationType[] vt1, IdentityStore.ValidationType[] vt2) {
        if (vt1 == vt2) {
            return true;
        }
        if (vt1.length == vt2.length && vt1.length == 1) {
            return vt1[0] == vt2[0];
        }
        List<IdentityStore.ValidationType> list1 = Arrays.asList(vt1);
        List<IdentityStore.ValidationType> list2 = Arrays.asList(vt2);
        return list1.contains(IdentityStore.ValidationType.PROVIDE_GROUPS) == list2.contains(IdentityStore.ValidationType.PROVIDE_GROUPS) && list1.contains(IdentityStore.ValidationType.VALIDATE) == list2.contains(IdentityStore.ValidationType.VALIDATE);
    }

    /*
     * WARNING - void declaration
     */
    private void createDatabaseIdentityStoreBeanToAdd(BeanManager beanManager, Annotation annotation, Class<? extends Annotation> annotationType) {
        block8: {
            try {
                Method[] methods;
                HashMap<String, Object> identityStoreProperties = new HashMap<String, Object>();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"JavaEESec.createDatabaseIdentityStoreBeanToAdd", (Object[])new Object[0]);
                }
                for (Method m : methods = annotationType.getMethods()) {
                    Tr.debug((TraceComponent)tc, (String)m.getName(), (Object[])new Object[0]);
                    if (m.getName().equals("equals")) continue;
                    identityStoreProperties.put(m.getName(), m.invoke((Object)annotation, new Object[0]));
                }
                DatabaseIdentityStoreDefinition databaseDefinition = this.getInstanceOfDBAnnotation(identityStoreProperties);
                if (!this.containsDatabaseDefinition(databaseDefinition, this.databaseDefinitionList)) {
                    DatabaseIdentityStoreBean bean = new DatabaseIdentityStoreBean(beanManager, databaseDefinition);
                    this.beansToAdd.add(bean);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"registering the default DatabaseIdentityStore.", (Object[])new Object[0]);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"the same annotation exists, skip registering..", (Object[])new Object[0]);
                }
            }
            catch (IllegalAccessException | InvocationTargetException identityStoreProperties) {
                void e;
                FFDCFilter.processException((Throwable)identityStoreProperties, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension", (String)"708", (Object)this, (Object[])new Object[]{beanManager, annotation, annotationType});
                if (!tc.isEventEnabled()) break block8;
                Tr.event((TraceComponent)tc, (String)"unexpected", (Object[])new Object[]{e});
            }
        }
    }

    private boolean containsDatabaseDefinition(DatabaseIdentityStoreDefinition dbDefinition, List<DatabaseIdentityStoreDefinition> dbDefinitionList) {
        for (DatabaseIdentityStoreDefinition disd : dbDefinitionList) {
            if (!this.equalsDatabaseDefinition(dbDefinition, disd)) continue;
            return true;
        }
        return false;
    }

    protected boolean equalsDatabaseDefinition(DatabaseIdentityStoreDefinition disd1, DatabaseIdentityStoreDefinition disd2) {
        return disd1.callerQuery().equals(disd2.callerQuery()) && disd1.dataSourceLookup().equals(disd2.dataSourceLookup()) && disd1.groupsQuery().equals(disd2.groupsQuery()) && disd1.hashAlgorithm().equals(disd2.hashAlgorithm()) && this.equalsHashAlgorithmParameters(disd1.hashAlgorithmParameters(), disd2.hashAlgorithmParameters()) && disd1.priority() == disd2.priority() && disd1.priorityExpression().equals(disd2.priorityExpression()) && this.equalsUseFor(disd1.useFor(), disd2.useFor()) && disd1.useForExpression().equals(disd2.useForExpression());
    }

    private boolean equalsHashAlgorithmParameters(String[] params1, String[] params2) {
        if (params1 == params2) {
            return true;
        }
        if (params1.length != params2.length) {
            return false;
        }
        HashSet<String> set1 = new HashSet<String>(Arrays.asList(params1));
        HashSet<String> set2 = new HashSet<String>(Arrays.asList(params2));
        return set1.equals(set2);
    }

    protected boolean isIdentityStoreHandler(ProcessBean<?> processBean) {
        Set types;
        Bean bean = processBean.getBean();
        if (bean.getBeanClass() != IdentityStoreHandler.class && (types = bean.getTypes()).contains(IdentityStoreHandler.class)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("found a custom IdentityStoreHandler : " + bean.getBeanClass()), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    protected boolean isIdentityStore(ProcessBean<?> processBean) {
        Set types;
        Bean bean = processBean.getBean();
        if (bean.getBeanClass() != IdentityStore.class && (types = bean.getTypes()).contains(IdentityStore.class)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("found a custom IdentityStore : " + bean.getBeanClass()), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    protected Set<Bean> getBeansToAdd() {
        return this.beansToAdd;
    }

    protected boolean getIdentityStoreHandlerRegistered() {
        return this.identityStoreHandlerRegistered;
    }

    protected boolean getIdentityStoreRegistered() {
        return this.identityStoreRegistered;
    }

    protected Map<String, ModuleProperties> getModuleMap() {
        return httpAuthenticationMechanismsTracker.getModuleMap(this.applicationName);
    }

    protected Map<URL, ModuleMetaData> getModuleMetaDataMap() {
        return ModuleMetaDataAccessorImpl.getModuleMetaDataAccessor().getModuleMetaDataMap();
    }

    protected WebAppSecurityConfig getWebAppSecurityConfig() {
        return WebConfigUtils.getWebAppSecurityConfig();
    }

    private DatabaseIdentityStoreDefinition getInstanceOfDBAnnotation(final Map<String, Object> overrides) {
        DatabaseIdentityStoreDefinition annotation = new DatabaseIdentityStoreDefinition(){
            static final long serialVersionUID = 7566154695072161093L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Class<? extends Annotation> annotationType() {
                return null;
            }

            public String callerQuery() {
                return overrides != null && overrides.containsKey("callerQuery") ? (String)overrides.get("callerQuery") : "";
            }

            public String dataSourceLookup() {
                return overrides != null && overrides.containsKey("dataSourceLookup") ? (String)overrides.get("dataSourceLookup") : "java:comp/DefaultDataSource";
            }

            public String groupsQuery() {
                return overrides != null && overrides.containsKey("groupsQuery") ? (String)overrides.get("groupsQuery") : "";
            }

            public Class<? extends PasswordHash> hashAlgorithm() {
                return overrides != null && overrides.containsKey("hashAlgorithm") ? (Class)overrides.get("hashAlgorithm") : Pbkdf2PasswordHash.class;
            }

            public String[] hashAlgorithmParameters() {
                return overrides != null && overrides.containsKey("hashAlgorithmParameters") ? (String[])overrides.get("hashAlgorithmParameters") : new String[]{};
            }

            public int priority() {
                return overrides != null && overrides.containsKey("priority") ? (Integer)overrides.get("priority") : 70;
            }

            public String priorityExpression() {
                return overrides != null && overrides.containsKey("priorityExpression") ? (String)overrides.get("priorityExpression") : "";
            }

            public IdentityStore.ValidationType[] useFor() {
                IdentityStore.ValidationType[] validationTypeArray;
                if (overrides != null && overrides.containsKey("useFor")) {
                    validationTypeArray = (IdentityStore.ValidationType[])overrides.get("useFor");
                } else {
                    IdentityStore.ValidationType[] validationTypeArray2 = new IdentityStore.ValidationType[2];
                    validationTypeArray2[0] = IdentityStore.ValidationType.PROVIDE_GROUPS;
                    validationTypeArray = validationTypeArray2;
                    validationTypeArray2[1] = IdentityStore.ValidationType.VALIDATE;
                }
                return validationTypeArray;
            }

            public String useForExpression() {
                return overrides != null && overrides.containsKey("useForExpression") ? (String)overrides.get("useForExpression") : "";
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.javaeesec.cdi.extensions.JavaEESecCDIExtension$5", 5.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
            }
        };
        return annotation;
    }

    private void verifyConfiguration() throws DeploymentException {
        Map<URL, ModuleMetaData> mmds = this.getModuleMetaDataMap();
        if (mmds != null) {
            for (Map.Entry<URL, ModuleMetaData> entry : mmds.entrySet()) {
                LoginConfiguration lc;
                String j2eeModuleName;
                Map<Class<?>, Properties> authMechs;
                ModuleMetaData mmd = entry.getValue();
                if (!(mmd instanceof WebModuleMetaData) || (authMechs = httpAuthenticationMechanismsTracker.getAuthMechs(this.applicationName, j2eeModuleName = mmd.getJ2EEName().getModule())) == null || authMechs.isEmpty()) continue;
                if (authMechs.size() != 1 && !this.isDecoratorOrAlternative(authMechs)) {
                    String appName = mmd.getJ2EEName().getApplication();
                    String authMechNames = this.getAuthMechNames(authMechs);
                    Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_MULTIPLE_HTTPAUTHMECHS", (Object[])new Object[]{j2eeModuleName, appName, authMechNames});
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_MULTIPLE_HTTPAUTHMECHS", (Object[])new Object[]{j2eeModuleName, appName, authMechNames});
                    throw new DeploymentException(msg);
                }
                SecurityMetadata smd = (SecurityMetadata)((WebModuleMetaData)mmd).getSecurityMetaData();
                if (smd == null || (lc = smd.getLoginConfiguration()) == null || lc.isAuthenticationMethodDefaulted()) continue;
                String appName = mmd.getJ2EEName().getApplication();
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_LOGIN_CONFIG_EXISTS", (Object[])new Object[]{j2eeModuleName, appName});
                Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_LOGIN_CONFIG_EXISTS", (Object[])new Object[]{j2eeModuleName, appName});
                throw new DeploymentException(msg);
            }
        }
    }

    private boolean isDecoratorOrAlternative(Map<Class<?>, Properties> authMechs) {
        for (Map.Entry<Class<?>, Properties> authMech : authMechs.entrySet()) {
            Properties value = authMech.getValue();
            if (value == null || !value.toString().contains(DECORATOR) && !value.toString().contains(ALTERNATIVE)) continue;
            return true;
        }
        return false;
    }

    private String getAuthMechNames(Map<Class<?>, Properties> authMechs) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (Class<?> authMech : authMechs.keySet()) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(authMech.getName());
        }
        return result.toString();
    }

    protected String getApplicationName() {
        String result = null;
        Map<URL, ModuleMetaData> mmds = this.getModuleMetaDataMap();
        if (mmds != null && !mmds.isEmpty()) {
            for (Map.Entry<URL, ModuleMetaData> entry : mmds.entrySet()) {
                J2EEName j2eeName;
                ModuleMetaData mmd = entry.getValue();
                if (!(mmd instanceof WebModuleMetaData) || (j2eeName = mmd.getJ2EEName()) == null) continue;
                result = j2eeName.getApplication();
                break;
            }
        }
        return result;
    }

    private Properties getGlobalLoginBasicProps() throws Exception {
        String realm = this.getWebAppSecurityConfig().getBasicAuthRealmName();
        Properties props = new Properties();
        if (realm == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"basicAuthenticationMechanismRealmName is not set. the default value defaultRealm is used.", (Object[])new Object[0]);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The container provided BasicAuthenticationMechanism will be used with the realm name  : " + realm), (Object[])new Object[0]);
            }
            props.put("realmName", realm);
        }
        return props;
    }

    private Properties getGlobalLoginFormProps() throws Exception {
        String contextRoot;
        WebAppSecurityConfig webAppSecConfig = this.getWebAppSecurityConfig();
        String loginURL = webAppSecConfig.getLoginFormURL();
        String errorURL = webAppSecConfig.getLoginErrorURL();
        if (loginURL == null || loginURL.isEmpty()) {
            Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_NO_URL", (Object[])new Object[]{"loginFormURL"});
        }
        if (errorURL == null || errorURL.isEmpty()) {
            Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_NO_URL", (Object[])new Object[]{"loginErrorURL"});
        }
        if ((contextRoot = webAppSecConfig.getLoginFormContextRoot()) == null) {
            contextRoot = this.getFirstPathElement(loginURL);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("loginFormContextRoot is not set, use the first element of loginURL  : " + contextRoot), (Object[])new Object[0]);
            }
        } else {
            if (!this.validateContextRoot(contextRoot, loginURL)) {
                Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_INVALID_CONTEXT_ROOT", (Object[])new Object[]{contextRoot, loginURL, "loginFormURL"});
            }
            if (!this.validateContextRoot(contextRoot, errorURL)) {
                Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_INVALID_CONTEXT_ROOT", (Object[])new Object[]{contextRoot, errorURL, "loginErrorURL"});
            }
        }
        loginURL = this.FixUpUrl(loginURL, contextRoot);
        errorURL = this.FixUpUrl(errorURL, contextRoot);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The container provided FormAuthenticationMechanism will be used with the following attributes. login page  : " + loginURL + ", error page : " + errorURL + ", context root : " + contextRoot), (Object[])new Object[0]);
        }
        Properties props = new Properties();
        if (loginURL != null) {
            props.put("loginPage", loginURL);
        }
        if (errorURL != null) {
            props.put("errorPage", errorURL);
        }
        props.put("useForwardToLogin", (Object)true);
        props.put("useGlobalLogin", (Object)true);
        if (contextRoot != null) {
            props.put("formLoginContextRoot", contextRoot);
        }
        return props;
    }

    private boolean isApplicationAuthMech(Class<?> javaClass) {
        return HttpAuthenticationMechanism.class.isAssignableFrom(javaClass) && !mechanismClasses.contains(javaClass);
    }

    private boolean isAuthMechOverridden() {
        WebAppSecurityConfig webAppSecConfig = this.getWebAppSecurityConfig();
        String value = webAppSecConfig.getOverrideHttpAuthMethod();
        if (value != null) {
            if (value.equals("FORM") || value.equals("BASIC")) {
                return true;
            }
            if (value.equals("CLIENT_CERT") && (webAppSecConfig.getAllowFailOverToFormLogin() || webAppSecConfig.getAllowFailOverToBasicAuth())) {
                return true;
            }
        }
        return false;
    }

    private boolean isAuthMechOverriddenByForm() {
        WebAppSecurityConfig webAppSecConfig = this.getWebAppSecurityConfig();
        String value = webAppSecConfig.getOverrideHttpAuthMethod();
        if (value != null) {
            if (value.equals("FORM")) {
                return true;
            }
            if (value.equals("CLIENT_CERT") && webAppSecConfig.getAllowFailOverToFormLogin()) {
                return true;
            }
        }
        return false;
    }

    private String getFirstPathElement(String input) {
        String[] output = input.split("/");
        if (output[0].isEmpty()) {
            return "/" + output[1];
        }
        return "/" + output[0];
    }

    private boolean validateContextRoot(String contextRoot, String url) {
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        return url.startsWith(contextRoot) && url.charAt(contextRoot.length()) == '/';
    }

    private String FixUpUrl(String input, String contextRoot) {
        String output = input;
        if (input != null) {
            if (!input.startsWith("/")) {
                input = "/" + input;
            }
            if (input.startsWith(contextRoot) && input.charAt(contextRoot.length()) == '/') {
                output = input.substring(contextRoot.length());
            }
        }
        return output;
    }

    @Override
    public boolean existAuthMech(String applicationName, Class<?> authMechToExist) {
        return httpAuthenticationMechanismsTracker.existAuthMech(applicationName, authMechToExist);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        httpAuthenticationMechanismsTracker = new HttpAuthenticationMechanismsTracker();
        mechanismClasses = new HashSet();
        mechanismClasses.add(BasicHttpAuthenticationMechanism.class);
        mechanismClasses.add(FormAuthenticationMechanism.class);
        mechanismClasses.add(CustomFormAuthenticationMechanism.class);
        mechanismClasses.add(HttpAuthenticationMechanism.class);
    }
}

