/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.ContextualAction;
import com.ibm.ws.concurrent.internal.ManagedForkJoinWorkerThread;
import com.ibm.ws.concurrent.internal.ManagedThreadImpl;
import com.ibm.ws.concurrent.internal.ThreadGroupTracker;
import com.ibm.ws.container.service.metadata.extended.MetaDataIdentifierService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.WSContextService;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ManagedThreadFactoryService
implements ResourceFactory,
ApplicationRecycleComponent {
    private static final TraceComponent tc = Tr.register(ManagedThreadFactoryService.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
    private static final String CONFIG_ID = "config.displayId";
    private static final String CREATE_DAEMON_THREADS = "createDaemonThreads";
    private static final String DEFAULT_PRIORITY = "defaultPriority";
    private static final String MAX_PRIORITY = "maxPriority";
    private final Set<String> applications = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicServiceReference<WSContextService> contextSvcRef = new AtomicServiceReference("contextService");
    boolean createDaemonThreads;
    private final AtomicInteger createdThreadCount = new AtomicInteger();
    private Map<String, String> defaultExecutionProperties;
    Integer defaultPriority;
    final AtomicBoolean isShutdown = new AtomicBoolean();
    private String name;
    private ThreadGroup threadGroup;
    private ThreadGroupTracker threadGroupTracker;
    private MetaDataIdentifierService metadataIdentifierService;
    static final long serialVersionUID = -7024501813677746673L;

    @Trivial
    @ManualTrace
    protected void activate(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{properties});
        }
        this.contextSvcRef.activate(componentContext);
        String jndiName = (String)properties.get("jndiName");
        this.name = jndiName == null ? (String)properties.get(CONFIG_ID) : jndiName;
        this.defaultExecutionProperties = new TreeMap<String, String>();
        this.defaultExecutionProperties.put("com.ibm.ws.concurrent.DEFAULT_CONTEXT", "UNCONFIGURED_CONTEXT_TYPES");
        this.defaultExecutionProperties.put("com.ibm.ws.concurrent.TASK_OWNER", this.name);
        this.createDaemonThreads = (Boolean)properties.get(CREATE_DAEMON_THREADS);
        this.defaultPriority = (Integer)properties.get(DEFAULT_PRIORITY);
        Integer maxPriority = (Integer)properties.get(MAX_PRIORITY);
        this.threadGroup = AccessController.doPrivileged(new CreateThreadGroupAction(this.name + " Thread Group", maxPriority), this.threadGroupTracker.serverAccessControlContext);
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"activate");
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        this.isShutdown.set(true);
        this.contextSvcRef.deactivate(componentContext);
        this.threadGroupTracker.threadFactoryDestroyed(this.name, this.threadGroup);
    }

    public ApplicationRecycleContext getContext() {
        return null;
    }

    public Set<String> getDependentApplications() {
        HashSet<String> members = new HashSet<String>(this.applications);
        this.applications.removeAll(members);
        return members;
    }

    public Object createResource(ResourceInfo info) throws Exception {
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cData != null) {
            this.applications.add(cData.getJ2EEName().getApplication());
        }
        return new ManagedThreadFactoryImpl(this.threadGroupTracker.serverAccessControlContext);
    }

    protected void setContextService(ServiceReference<WSContextService> ref) {
        this.contextSvcRef.setReference(ref);
    }

    protected void setThreadGroupTracker(ThreadGroupTracker svc) {
        this.threadGroupTracker = svc;
    }

    protected void setMetadataIdentifierService(MetaDataIdentifierService svc) {
        this.metadataIdentifierService = svc;
    }

    protected void unsetContextService(ServiceReference<WSContextService> ref) {
        this.contextSvcRef.unsetReference(ref);
    }

    protected void unsetThreadGroupTracker(ThreadGroupTracker svc) {
        this.threadGroupTracker = null;
    }

    protected void unsetMetadataIdentifierService(MetaDataIdentifierService svc) {
        this.metadataIdentifierService = null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class ManagedThreadFactoryImpl
    implements ManagedThreadFactory {
        private final String identifier;
        final AccessControlContext serverAccessControlContext;
        final ManagedThreadFactoryService service;
        final ThreadContextDescriptor threadContextDescriptor;
        final ThreadGroup threadGroup;
        static final long serialVersionUID = -7433513950115352304L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ManagedThreadFactoryImpl(AccessControlContext serverAccessControlContext) {
            this.service = ManagedThreadFactoryService.this;
            this.serverAccessControlContext = serverAccessControlContext;
            WSContextService contextSvc = (WSContextService)ManagedThreadFactoryService.this.contextSvcRef.getServiceWithException();
            this.threadContextDescriptor = contextSvc.captureThreadContext(ManagedThreadFactoryService.this.defaultExecutionProperties, new Map[0]);
            ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            this.identifier = cData == null ? null : ManagedThreadFactoryService.this.metadataIdentifierService.getMetaDataIdentifier((MetaData)cData);
            this.threadGroup = this.identifier == null ? ManagedThreadFactoryService.this.threadGroup : ManagedThreadFactoryService.this.threadGroupTracker.getThreadGroup(this.identifier, ManagedThreadFactoryService.this.name, this.service.threadGroup);
        }

        @ManualTrace
        public Thread newThread(Runnable runnable) {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)ManagedThreadFactoryService.this, (TraceComponent)tc, (String)"newThread", (Object[])new Object[]{this, runnable});
            }
            if (ManagedThreadFactoryService.this.isShutdown.get()) {
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1100.resource.unavailable", (Object[])new Object[]{ManagedThreadFactoryService.this.name}));
            }
            if (runnable instanceof ContextualAction) {
                throw new IllegalArgumentException(runnable.getClass().getName());
            }
            String threadName = ManagedThreadFactoryService.this.name + "-thread-" + ManagedThreadFactoryService.this.createdThreadCount.incrementAndGet();
            ManagedThreadImpl thread = new ManagedThreadImpl(this, runnable, threadName);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)ManagedThreadFactoryService.this, (TraceComponent)tc, (String)"newThread", (Object)thread);
            }
            return thread;
        }

        @ManualTrace
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)ManagedThreadFactoryService.this, (TraceComponent)tc, (String)"newThread", (Object[])new Object[]{this, pool});
            }
            if (ManagedThreadFactoryService.this.isShutdown.get()) {
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1100.resource.unavailable", (Object[])new Object[]{ManagedThreadFactoryService.this.name}));
            }
            ManagedForkJoinWorkerThread thread = new ManagedForkJoinWorkerThread(this, pool);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)ManagedThreadFactoryService.this, (TraceComponent)tc, (String)"newThread", (Object)thread);
            }
            return thread;
        }

        boolean sameMetaDataIdentity() {
            ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            return this.identifier != null && ManagedThreadFactoryService.this.metadataIdentifierService != null && this.identifier.equals(ManagedThreadFactoryService.this.metadataIdentifierService.getMetaDataIdentifier((MetaData)cData));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.concurrent.internal.ManagedThreadFactoryService$ManagedThreadFactoryImpl", ManagedThreadFactoryImpl.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
        }
    }

    @Trivial
    private static class CreateThreadGroupAction
    implements PrivilegedAction<ThreadGroup> {
        private final Integer maxPriority;
        private final String name;

        private CreateThreadGroupAction(String name, Integer maxPriority) {
            this.maxPriority = maxPriority;
            this.name = name;
        }

        @Override
        public ThreadGroup run() {
            ThreadGroup group = new ThreadGroup(this.name);
            group.setDaemon(false);
            if (this.maxPriority != null) {
                group.setMaxPriority(this.maxPriority);
            }
            return group;
        }
    }
}

