/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.AnnotatedEndpoint;
import com.ibm.ws.wsoc.EndpointMethodHelper;
import com.ibm.ws.wsoc.FrameFormatException;
import com.ibm.ws.wsoc.MaxMessageException;
import com.ibm.ws.wsoc.MessageReadInfo;
import com.ibm.ws.wsoc.MessageReader;
import com.ibm.ws.wsoc.MessageWriter;
import com.ibm.ws.wsoc.MethodData;
import com.ibm.ws.wsoc.OpcodeType;
import com.ibm.ws.wsoc.PongMessageImpl;
import com.ibm.ws.wsoc.WsocBufferException;
import com.ibm.ws.wsoc.WsocConnLink;
import com.ibm.ws.wsoc.WsocReadCallback;
import com.ibm.ws.wsoc.util.Utils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import jakarta.websocket.CloseReason;
import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.PongMessage;
import jakarta.websocket.SessionException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LinkRead {
    private static final TraceComponent tc = Tr.register(LinkRead.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    private final HashMap<Class<?>, ArrayList<Decoder>> binaryDecoders = new HashMap();
    private final HashMap<Class<?>, ArrayList<Decoder>> textDecoders = new HashMap();
    private final HashMap<Class<?>, ArrayList<Decoder>> binaryStreamDecoders = new HashMap();
    private final HashMap<Class<?>, ArrayList<Decoder>> textStreamDecoders = new HashMap();
    private MessageReader messageReader = null;
    private MessageHandler appTextMessageHandler = null;
    private MessageHandler appBinaryMessageHandler = null;
    private MessageHandler appPongMessageHandler = null;
    private TCPReadRequestContext tcpReadContext = null;
    private EndpointConfig endpointConfig = null;
    private Class<?> appTextMessageHandlerClass = null;
    private Class<?> appBinaryMessageHandlerClass = null;
    private Class<?> appPongMessageHandlerClass = null;
    private MessageHandler appTextPartialMessageHandler = null;
    private MessageHandler appBinaryPartialMessageHandler = null;
    private Class<?> appTextPartialMessageHandlerClass = null;
    private Class<?> appBinaryPartialMessageHandlerClass = null;
    private boolean annotatedTextMethodPresent = false;
    private boolean annotatedBinaryMethodPresent = false;
    private boolean annotatedPongMethodPresent = false;
    private WsocConnLink connLink = null;
    private boolean shouldReadMaskedData = false;
    private PartialState partialProcessingState = PartialState.NOT_ATTEMPTED;
    static final long serialVersionUID = 7928995429435769344L;

    public void initialize(TCPReadRequestContext _rrc, EndpointConfig _epc, Endpoint _ep, WsocConnLink _link, boolean _shouldReadMaskedData) {
        this.tcpReadContext = _rrc;
        this.endpointConfig = _epc;
        this.connLink = _link;
        this.shouldReadMaskedData = _shouldReadMaskedData;
        if (_ep instanceof AnnotatedEndpoint) {
            AnnotatedEndpoint ae = (AnnotatedEndpoint)_ep;
            EndpointMethodHelper m = null;
            m = ae.getOnMessageTextMethod();
            if (m != null) {
                this.annotatedTextMethodPresent = true;
            }
            if ((m = ae.getOnMessageBinaryMethod()) != null) {
                this.annotatedBinaryMethodPresent = true;
            }
            if ((m = ae.getOnMessagePongMethod()) != null) {
                this.annotatedPongMethodPresent = true;
            }
        }
        this.messageReader = new MessageReader();
        WsocReadCallback readCallback = this.connLink.getReadCallback();
        this.messageReader.initialize(readCallback, this.connLink, this.shouldReadMaskedData);
    }

    /*
     * WARNING - void declaration
     */
    public boolean processRead(TCPReadRequestContext rrc, Endpoint appEndPoint) {
        MessageReadInfo messageInfo;
        WsocConnLink.DATA_TYPE dt = WsocConnLink.DATA_TYPE.UNKNOWN;
        AnnotatedEndpoint ae = null;
        boolean appMessageProcessingAttempted = false;
        try {
            messageInfo = this.messageReader.processRead(rrc, this.isPartialAvailable(appEndPoint, true), this.isPartialAvailable(appEndPoint, false), this.connLink.anticipatingCloseFrame());
        }
        catch (FrameFormatException frameFormatException) {
            void ffe;
            FFDCFilter.processException((Throwable)frameFormatException, (String)"com.ibm.ws.wsoc.LinkRead", (String)"146", (Object)this, (Object[])new Object[]{rrc, appEndPoint});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception in reading incoming message frame: " + ffe.getMessage() + ". Calling Endpoint.onClose()"), (Object[])new Object[0]);
            }
            String reasonPhrase = ffe.getMessage();
            reasonPhrase = Utils.truncateCloseReason(reasonPhrase);
            CloseReason closeReason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, reasonPhrase);
            this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
            this.connLink.closeUsingSession(closeReason, false, false);
            this.messageReader.reset();
            return false;
        }
        catch (WsocBufferException ffe) {
            void e;
            FFDCFilter.processException((Throwable)ffe, (String)"com.ibm.ws.wsoc.LinkRead", (String)"159", (Object)this, (Object[])new Object[]{rrc, appEndPoint});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No more Bytes available while reading an incoming message: " + e.getMessage() + ". Calling Endpoint.onError()"), (Object[])new Object[0]);
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"bytes.notavailable", (Object[])new Object[0]);
            SessionException se = new SessionException(msg, (Throwable)e, this.connLink.getWsocSession());
            this.connLink.callOnError((Throwable)se, true);
            return false;
        }
        catch (MaxMessageException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.LinkRead", (String)"169", (Object)this, (Object[])new Object[]{rrc, appEndPoint});
            String reasonPhrase = e.getMessage();
            reasonPhrase = Utils.truncateCloseReason(reasonPhrase);
            CloseReason closeReason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.TOO_BIG, reasonPhrase);
            this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
            this.connLink.closeUsingSession(closeReason, false, false);
            this.messageReader.reset();
            return false;
        }
        if (messageInfo.getState() == MessageReadInfo.State.CLOSE_FRAME_ERROR) {
            this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
            this.connLink.closeUsingSession(null, false, true);
            this.messageReader.reset();
        }
        if (messageInfo.getState() == MessageReadInfo.State.CONTROL_MESSAGE_EMBEDDED || messageInfo.getState() == MessageReadInfo.State.COMPLETE && (this.partialProcessingState == PartialState.NOT_ATTEMPTED || this.partialProcessingState == PartialState.OFF)) {
            OpcodeType ot = messageInfo.getType();
            if (ot == OpcodeType.BINARY_WHOLE) {
                dt = WsocConnLink.DATA_TYPE.BINARY;
            } else if (ot == OpcodeType.TEXT_WHOLE) {
                dt = WsocConnLink.DATA_TYPE.TEXT;
            } else if (ot == OpcodeType.PING) {
                dt = WsocConnLink.DATA_TYPE.PING;
            } else if (ot == OpcodeType.PONG) {
                dt = WsocConnLink.DATA_TYPE.PONG;
            } else if (ot == OpcodeType.CONNECTION_CLOSE) {
                dt = WsocConnLink.DATA_TYPE.CLOSE;
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not determine message type", (Object[])new Object[0]);
            }
            if (this.connLink.getLinkStatus() == WsocConnLink.LINK_STATUS.LOCAL_CLOSING && dt != WsocConnLink.DATA_TYPE.CLOSE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processRead :closeframe: Received a non close frame when close frame sent, ignoring.", (Object[])new Object[0]);
                }
                this.messageReader.reset();
                this.connLink.setReadLinkStatusAndCloseFrameState(WsocConnLink.READ_LINK_STATUS.OK_TO_READ, WsocConnLink.CLOSE_FRAME_STATE.ANTICIPATING);
                return false;
            }
            if (dt == WsocConnLink.DATA_TYPE.CLOSE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processRead :closeframe: Received close frame: Close frame state: " + (Object)((Object)this.connLink.getCloseFrameState())), (Object[])new Object[0]);
                }
                byte[] data = this.convertPayloadToByteArray(true);
                int closeCode = 1000;
                String reason = "";
                if (data.length == 1) {
                    closeCode = 1002;
                    reason = "Close frame must either zero bytes or 2 or more bytes.";
                } else if (data.length >= 2) {
                    int reasonLength = data.length - 2;
                    if (data.length > 125) {
                        reasonLength = 123;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("data len: " + data.length + " reason len: " + reasonLength), (Object[])new Object[0]);
                    }
                    closeCode = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
                    if (reasonLength > 0) {
                        byte[] reasonData = new byte[reasonLength];
                        System.arraycopy(data, 2, reasonData, 0, reasonLength);
                        try {
                            reason = Utils.uTF8byteArrayToString(reasonData);
                        }
                        catch (CharacterCodingException characterCodingException) {
                            FFDCFilter.processException((Throwable)characterCodingException, (String)"com.ibm.ws.wsoc.LinkRead", (String)"260", (Object)this, (Object[])new Object[]{rrc, appEndPoint});
                            closeCode = 1007;
                            reason = "Invalid utf-8 data received in  close frame.";
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("closeCode: " + closeCode + " reason: " + reason), (Object[])new Object[0]);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Closing with reason of: " + reason), (Object[])new Object[0]);
                }
                CloseReason cr = null;
                if (closeCode == 1006 || closeCode == 1004 || closeCode == 1005 || closeCode > 1011 && closeCode < 3000 || closeCode < 1000) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Invalid closecode " + closeCode + " Coverting closecode to 1002"), (Object[])new Object[0]);
                    }
                    cr = new CloseReason(CloseReason.CloseCodes.getCloseCode((int)1002), "Invalid close code " + closeCode + " provided, closing with protocol error.");
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Valid closecode " + closeCode), (Object[])new Object[0]);
                    }
                    cr = new CloseReason(CloseReason.CloseCodes.getCloseCode((int)closeCode), reason);
                }
                this.connLink.incomingCloseConnection(cr);
                this.messageReader.reset();
                appMessageProcessingAttempted = true;
            }
            if (dt == WsocConnLink.DATA_TYPE.PING) {
                byte[] retData = this.convertPayloadToByteArray(true);
                WsByteBuffer wsBuffer = this.connLink.getBufferManager().wrap(retData);
                this.connLink.writeBuffer(wsBuffer, OpcodeType.PONG, MessageWriter.WRITE_TYPE.SYNC, null, 0, true, true);
                appMessageProcessingAttempted = true;
            } else if (appEndPoint instanceof AnnotatedEndpoint) {
                ae = (AnnotatedEndpoint)appEndPoint;
                EndpointMethodHelper m = null;
                if (dt == WsocConnLink.DATA_TYPE.TEXT && (m = ae.getOnMessageTextMethod()) != null) {
                    appMessageProcessingAttempted = true;
                    try {
                        this.processOnMessageTextAnnotation(ae, m, true);
                    }
                    catch (CharacterCodingException wsBuffer) {
                        FFDCFilter.processException((Throwable)wsBuffer, (String)"com.ibm.ws.wsoc.LinkRead", (String)"307", (Object)this, (Object[])new Object[]{rrc, appEndPoint});
                        CloseReason closeReason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NOT_CONSISTENT, "Invalid UTF-8 data received.");
                        this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
                        this.connLink.closeUsingSession(closeReason, true, false);
                        this.messageReader.reset();
                        return false;
                    }
                }
                if (dt == WsocConnLink.DATA_TYPE.BINARY && (m = ae.getOnMessageBinaryMethod()) != null) {
                    appMessageProcessingAttempted = true;
                    this.processOnMessageBinaryAnnotation(ae, m, true);
                }
                if (dt == WsocConnLink.DATA_TYPE.PONG && (m = ae.getOnMessagePongMethod()) != null) {
                    appMessageProcessingAttempted = true;
                    this.processOnMessagePongAnnotation(ae, m);
                }
            }
            if (!appMessageProcessingAttempted) {
                try {
                    appMessageProcessingAttempted = this.processWithWholeMessageHandler(dt);
                    if (!appMessageProcessingAttempted && dt != WsocConnLink.DATA_TYPE.PONG && !(appMessageProcessingAttempted = this.processWithPartialMessageHandler(dt, true))) {
                        String name = null;
                        name = ae != null ? ae.getServerEndpointClass().getName() : appEndPoint.getClass().getName();
                        String reasonPhrase = Tr.formatMessage((TraceComponent)tc, (String)"onmessage.notdefined", (Object[])new Object[]{name});
                        Tr.warning((TraceComponent)tc, (String)"onmessage.notdefined", (Object[])new Object[]{name});
                        this.connLink.callOnClose(reasonPhrase, (CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT);
                    }
                }
                catch (CharacterCodingException name) {
                    FFDCFilter.processException((Throwable)name, (String)"com.ibm.ws.wsoc.LinkRead", (String)"361", (Object)this, (Object[])new Object[]{rrc, appEndPoint});
                    CloseReason closeReason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NOT_CONSISTENT, "Invalid UTF-8 data received.");
                    this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
                    this.connLink.closeUsingSession(closeReason, true, false);
                    this.messageReader.reset();
                    return false;
                }
                catch (Throwable e) {
                    void t;
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.LinkRead", (String)"368", (Object)this, (Object[])new Object[]{rrc, appEndPoint});
                    this.connLink.callOnError((Throwable)t, true);
                }
            }
            if (messageInfo.getState() != MessageReadInfo.State.CONTROL_MESSAGE_EMBEDDED) {
                this.partialProcessingState = PartialState.NOT_ATTEMPTED;
                this.messageReader.reset();
            } else {
                this.messageReader.resetControlFrameParameters(true);
            }
        } else if (this.partialProcessingState != PartialState.OFF && (messageInfo.getState() == MessageReadInfo.State.PARTIAL_COMPLETE || messageInfo.getState() == MessageReadInfo.State.COMPLETE)) {
            try {
                OpcodeType ot;
                boolean isLast = false;
                boolean lookForProcessor = true;
                if (messageInfo.getState() == MessageReadInfo.State.COMPLETE) {
                    isLast = true;
                }
                if ((ot = messageInfo.getType()) == OpcodeType.BINARY_WHOLE) {
                    dt = WsocConnLink.DATA_TYPE.BINARY;
                } else if (ot == OpcodeType.TEXT_WHOLE) {
                    dt = WsocConnLink.DATA_TYPE.TEXT;
                } else {
                    lookForProcessor = false;
                    this.partialProcessingState = PartialState.OFF;
                }
                if (lookForProcessor) {
                    if (appEndPoint instanceof AnnotatedEndpoint) {
                        EndpointMethodHelper m;
                        if ((this.partialProcessingState == PartialState.AE_TEXT_ATTEMPTED || this.partialProcessingState == PartialState.NOT_ATTEMPTED) && dt == WsocConnLink.DATA_TYPE.TEXT && (m = (ae = (AnnotatedEndpoint)appEndPoint).getOnMessageTextMethod()) != null && this.processOnMessageTextAnnotation(ae, m, isLast)) {
                            this.messageReader.removeFirstFrameFromProcessor();
                            this.partialProcessingState = PartialState.AE_TEXT_ATTEMPTED;
                            this.messageReader.setFrameSequenceState(MessageReader.FSeqState.EXPECTING_PARTIAL_OR_LAST);
                            lookForProcessor = false;
                        }
                        if (lookForProcessor && (this.partialProcessingState == PartialState.AE_BINARY_ATTEMPTED || this.partialProcessingState == PartialState.NOT_ATTEMPTED) && dt == WsocConnLink.DATA_TYPE.BINARY && (m = (ae = (AnnotatedEndpoint)appEndPoint).getOnMessageBinaryMethod()) != null) {
                            appMessageProcessingAttempted = true;
                            if (this.processOnMessageBinaryAnnotation(ae, m, isLast)) {
                                this.messageReader.removeFirstFrameFromProcessor();
                                this.partialProcessingState = PartialState.AE_BINARY_ATTEMPTED;
                                this.messageReader.setFrameSequenceState(MessageReader.FSeqState.EXPECTING_PARTIAL_OR_LAST);
                                lookForProcessor = false;
                            }
                        }
                    }
                    if ((lookForProcessor && this.partialProcessingState == PartialState.MESSAGE_HANDLER_ATTEMPTED || this.partialProcessingState == PartialState.NOT_ATTEMPTED) && this.processWithPartialMessageHandler(dt, isLast)) {
                        this.partialProcessingState = PartialState.MESSAGE_HANDLER_ATTEMPTED;
                        this.messageReader.setFrameSequenceState(MessageReader.FSeqState.EXPECTING_PARTIAL_OR_LAST);
                        lookForProcessor = false;
                    }
                    if (lookForProcessor) {
                        if (this.partialProcessingState == PartialState.NOT_ATTEMPTED) {
                            this.partialProcessingState = PartialState.OFF;
                            this.messageReader.setFrameSequenceState(MessageReader.FSeqState.EXPECTING_PARTIAL_OR_LAST);
                        } else {
                            String reasonPhrase = Tr.formatMessage((TraceComponent)tc, (String)"onmessage.notdefined", (Object[])new Object[]{appEndPoint.getClass().getName()});
                            Tr.warning((TraceComponent)tc, (String)"onmessage.notdefined", (Object[])new Object[]{appEndPoint.getClass().getName()});
                            this.connLink.callOnClose(reasonPhrase, (CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT);
                        }
                    }
                }
            }
            catch (CharacterCodingException isLast) {
                FFDCFilter.processException((Throwable)isLast, (String)"com.ibm.ws.wsoc.LinkRead", (String)"470", (Object)this, (Object[])new Object[]{rrc, appEndPoint});
                CloseReason closeReason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NOT_CONSISTENT, "Invalid UTF-8 data received.");
                this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
                this.connLink.closeUsingSession(closeReason, true, false);
                this.messageReader.reset();
                return false;
            }
            catch (Throwable e) {
                void t;
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.LinkRead", (String)"476", (Object)this, (Object[])new Object[]{rrc, appEndPoint});
                this.connLink.callOnError((Throwable)t, true);
            }
            if (messageInfo.getState() == MessageReadInfo.State.COMPLETE) {
                this.partialProcessingState = PartialState.NOT_ATTEMPTED;
                this.messageReader.reset();
            }
        }
        return messageInfo.isMoreBufferToProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processWithPartialMessageHandler(WsocConnLink.DATA_TYPE dt, boolean isLast) throws CharacterCodingException {
        Class<?> clazz;
        if (this.appTextPartialMessageHandler != null && dt == WsocConnLink.DATA_TYPE.TEXT && (clazz = this.appTextPartialMessageHandlerClass).equals(String.class)) {
            String message = this.convertMessageToString();
            try {
                this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
                ((MessageHandler.Partial)this.appTextPartialMessageHandler).onMessage((Object)message, isLast);
            }
            finally {
                this.messageReader.removeFirstFrameFromProcessor();
            }
            return true;
        }
        if (this.appBinaryPartialMessageHandler != null && dt == WsocConnLink.DATA_TYPE.BINARY) {
            clazz = this.appBinaryPartialMessageHandlerClass;
            if (clazz.equals(ByteBuffer.class)) {
                ByteBuffer message = this.convertMessageToByteBuffer();
                try {
                    this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
                    ((MessageHandler.Partial)this.appBinaryPartialMessageHandler).onMessage((Object)message, isLast);
                }
                finally {
                    this.messageReader.removeFirstFrameFromProcessor();
                }
                return true;
            }
            if (clazz.equals(byte[].class)) {
                byte[] message = this.convertPayloadToByteArray();
                try {
                    this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
                    ((MessageHandler.Partial)this.appBinaryPartialMessageHandler).onMessage((Object)message, isLast);
                }
                finally {
                    this.messageReader.removeFirstFrameFromProcessor();
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={IOException.class})
    public boolean processWithWholeMessageHandler(WsocConnLink.DATA_TYPE dt) throws CharacterCodingException {
        Decoder dc;
        Object message;
        Decoder firstDecoder;
        ArrayList<Decoder> dcList;
        Class<?> clazz;
        if (this.appTextMessageHandler != null && dt == WsocConnLink.DATA_TYPE.TEXT) {
            clazz = this.appTextMessageHandlerClass;
            if (clazz.equals(String.class)) {
                String message2 = this.convertMessageToString();
                this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
                ((MessageHandler.Whole)this.appTextMessageHandler).onMessage((Object)message2);
                return true;
            }
            if (clazz.equals(Reader.class)) {
                Reader message3 = this.convertMessageToReader();
                this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
                ((MessageHandler.Whole)this.appTextMessageHandler).onMessage((Object)message3);
                return true;
            }
        }
        if (this.appBinaryMessageHandler != null && dt == WsocConnLink.DATA_TYPE.BINARY) {
            clazz = this.appBinaryMessageHandlerClass;
            if (clazz.equals(ByteBuffer.class)) {
                ByteBuffer message4 = this.convertMessageToByteBuffer();
                this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
                ((MessageHandler.Whole)this.appBinaryMessageHandler).onMessage((Object)message4);
                return true;
            }
            if (clazz.equals(byte[].class)) {
                byte[] message5 = this.convertPayloadToByteArray();
                this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
                ((MessageHandler.Whole)this.appBinaryMessageHandler).onMessage((Object)message5);
                return true;
            }
            if (clazz.equals(InputStream.class)) {
                InputStream message6 = this.convertMessageToInputStream();
                this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
                ((MessageHandler.Whole)this.appBinaryMessageHandler).onMessage((Object)message6);
                return true;
            }
        }
        if (this.appPongMessageHandler != null && dt == WsocConnLink.DATA_TYPE.PONG && (clazz = this.appPongMessageHandlerClass).equals(PongMessage.class)) {
            ByteBuffer message7 = this.convertMessageToByteBuffer(true);
            PongMessageImpl msg = new PongMessageImpl(message7);
            this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
            ((MessageHandler.Whole)this.appPongMessageHandler).onMessage((Object)msg);
            return true;
        }
        if (this.appTextMessageHandler != null && dt == WsocConnLink.DATA_TYPE.TEXT && (dcList = this.findDecoderFromAppDecoderType(clazz = this.appTextMessageHandlerClass, dt)) != null && dcList.size() > 0) {
            firstDecoder = dcList.get(0);
            if (firstDecoder instanceof Decoder.Text) {
                message = this.convertMessageToString();
                dc = this.findWillDecodeDecoder(dcList, message);
                if (dc != null) {
                    try {
                        dc.init(this.endpointConfig);
                        Object appObj = ((Decoder.Text)dc).decode((String)message);
                        this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
                        ((MessageHandler.Whole)this.appTextMessageHandler).onMessage(appObj);
                        return true;
                    }
                    catch (DecodeException appObj) {
                        void e;
                        FFDCFilter.processException((Throwable)appObj, (String)"com.ibm.ws.wsoc.LinkRead", (String)"641", (Object)this, (Object[])new Object[]{dt});
                        this.connLink.callOnError((Throwable)e, true);
                        return true;
                    }
                }
            } else if (firstDecoder instanceof Decoder.TextStream) {
                Reader message8 = this.convertMessageToReader();
                try {
                    firstDecoder.init(this.endpointConfig);
                    Object appObj = ((Decoder.TextStream)firstDecoder).decode(message8);
                    this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
                    ((MessageHandler.Whole)this.appTextMessageHandler).onMessage(appObj);
                    return true;
                }
                catch (DecodeException appObj) {
                    void e;
                    FFDCFilter.processException((Throwable)appObj, (String)"com.ibm.ws.wsoc.LinkRead", (String)"657", (Object)this, (Object[])new Object[]{dt});
                    this.connLink.callOnError((Throwable)e, true);
                    return true;
                }
                catch (IOException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("IOException calling onMessage on class " + clazz.getName() + " while decoding Decoder.TextStream type " + ((Decoder.TextStream)firstDecoder).toString() + "Exception is: " + e.getMessage()), (Object[])new Object[0]);
                    }
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"decoder.ioexception", (Object[])new Object[]{this.appTextMessageHandler.getClass().getName(), firstDecoder.getClass().getName()});
                    DecodeException de = new DecodeException(msg, e.getMessage(), (Throwable)e);
                    this.connLink.callOnError(de, true);
                    return true;
                }
            }
        }
        if (this.appBinaryMessageHandler != null && dt == WsocConnLink.DATA_TYPE.BINARY && (dcList = this.findDecoderFromAppDecoderType(clazz = this.appBinaryMessageHandlerClass, dt)) != null && dcList.size() > 0) {
            firstDecoder = dcList.get(0);
            if (firstDecoder instanceof Decoder.Binary) {
                message = this.convertMessageToByteBuffer();
                dc = this.findWillDecodeDecoder(dcList, message);
                if (dc != null) {
                    try {
                        dc.init(this.endpointConfig);
                        Object appObj = ((Decoder.Binary)dc).decode((ByteBuffer)message);
                        this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
                        ((MessageHandler.Whole)this.appBinaryMessageHandler).onMessage(appObj);
                        return true;
                    }
                    catch (DecodeException appObj) {
                        void e;
                        FFDCFilter.processException((Throwable)appObj, (String)"com.ibm.ws.wsoc.LinkRead", (String)"701", (Object)this, (Object[])new Object[]{dt});
                        this.connLink.callOnError((Throwable)e, true);
                        return true;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"willDecode returned false", (Object[])new Object[0]);
                }
                return true;
            }
            if (firstDecoder instanceof Decoder.BinaryStream) {
                message = this.convertMessageToInputStream();
                try {
                    firstDecoder.init(this.endpointConfig);
                    Object appObj = ((Decoder.BinaryStream)firstDecoder).decode((InputStream)message);
                    this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
                    ((MessageHandler.Whole)this.appBinaryMessageHandler).onMessage(appObj);
                    return true;
                }
                catch (DecodeException appObj) {
                    void e;
                    FFDCFilter.processException((Throwable)appObj, (String)"com.ibm.ws.wsoc.LinkRead", (String)"721", (Object)this, (Object[])new Object[]{dt});
                    this.connLink.callOnError((Throwable)e, true);
                    return true;
                }
                catch (IOException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("IOException calling onMessage on class " + clazz.getName() + " while decoding Decoder.BinaryStream type " + ((Decoder.BinaryStream)firstDecoder).toString() + "Exception is: " + e.getMessage()), (Object[])new Object[0]);
                    }
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"decoder.ioexception", (Object[])new Object[]{this.appBinaryMessageHandler.getClass().getName(), ((Decoder.BinaryStream)firstDecoder).getClass().getName()});
                    DecodeException de = new DecodeException(msg, e.getMessage(), (Throwable)e);
                    this.connLink.callOnError(de, true);
                    return true;
                }
            }
        }
        return false;
    }

    public void processOnMessagePongAnnotation(AnnotatedEndpoint ae, EndpointMethodHelper m) {
        Object[] args = new Object[m.getMethod().getParameterTypes().length];
        MethodData methodData = ae.getOnMessagePongMethod().getMethodData();
        Class<?> inputType = methodData.getMessageType();
        int msgIndex = methodData.getMessageIndex();
        int sessionIndex = methodData.getSessionIndex();
        if (sessionIndex >= 0) {
            args[sessionIndex] = this.connLink.getWsocSession();
        }
        if (inputType.equals(PongMessage.class)) {
            ByteBuffer message = this.convertMessageToByteBuffer(true);
            PongMessageImpl pm = new PongMessageImpl(message);
            args[msgIndex] = pm;
            Object appInstance = ae.getAppInstance();
            Object obj = this.callOnMessage(args, appInstance, m, ae);
            if (obj != null) {
                this.connLink.writeObject(obj, MessageWriter.WRITE_TYPE.SYNC, null, true);
            }
        }
    }

    public boolean isPartialAvailable(Endpoint appEndPoint, boolean isText) {
        if (isText) {
            AnnotatedEndpoint ae;
            if (this.appTextPartialMessageHandler != null) {
                return true;
            }
            if (appEndPoint instanceof AnnotatedEndpoint && (ae = (AnnotatedEndpoint)appEndPoint).getOnMessageTextMethod() != null && this.isPartialMethodPresent(ae.getOnMessageTextMethod().getMethodData())) {
                return true;
            }
        } else {
            AnnotatedEndpoint ae;
            if (this.appBinaryPartialMessageHandler != null) {
                return true;
            }
            if (appEndPoint instanceof AnnotatedEndpoint && (ae = (AnnotatedEndpoint)appEndPoint).getOnMessageBinaryMethod() != null && this.isPartialMethodPresent(ae.getOnMessageBinaryMethod().getMethodData())) {
                return true;
            }
        }
        return false;
    }

    public boolean isPartialMethodPresent(MethodData methodData) {
        boolean retVal = false;
        int booleanIndex = methodData.getMsgBooleanPairIndex();
        if (booleanIndex >= 0) {
            retVal = true;
        }
        return retVal;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={IOException.class})
    public boolean processOnMessageTextAnnotation(AnnotatedEndpoint ae, EndpointMethodHelper m, boolean isLast) throws CharacterCodingException {
        Object appInstance;
        Object obj;
        Object[] args = new Object[m.getMethod().getParameterTypes().length];
        MethodData methodData = ae.getOnMessageTextMethod().getMethodData();
        Class<?> inputType = methodData.getMessageType();
        int msgIndex = methodData.getMessageIndex();
        int sessionIndex = methodData.getSessionIndex();
        if (sessionIndex >= 0) {
            args[sessionIndex] = this.connLink.getWsocSession();
        }
        if (inputType.equals(String.class)) {
            int booleanIndex = methodData.getMsgBooleanPairIndex();
            if (booleanIndex >= 0) {
                args[booleanIndex] = isLast;
            } else if (!isLast) {
                return false;
            }
            String message = this.convertMessageToString();
            args[msgIndex] = message;
        } else {
            if (!isLast) {
                return false;
            }
            if (inputType.equals(Reader.class)) {
                Reader message = this.convertMessageToReader();
                args[msgIndex] = message;
            } else if (inputType.equals(Boolean.TYPE)) {
                String payload = this.convertPayloadToString();
                boolean message = Boolean.valueOf(payload);
                args[msgIndex] = message;
            } else if (inputType.equals(Boolean.class)) {
                String payload = this.convertPayloadToString();
                Boolean message = Boolean.valueOf(payload);
                args[msgIndex] = message;
            } else if (inputType.equals(Byte.TYPE)) {
                byte message = Byte.parseByte(this.convertPayloadToString());
                args[msgIndex] = message;
            } else if (inputType.equals(Byte.class)) {
                args[msgIndex] = Byte.parseByte(this.convertPayloadToString());
            } else if (inputType.equals(Short.TYPE)) {
                String payload = this.convertPayloadToString();
                short message = new Short(payload);
                args[msgIndex] = message;
            } else if (inputType.equals(Short.class)) {
                String payload = this.convertPayloadToString();
                Short message = new Short(payload);
                args[msgIndex] = message;
            } else if (inputType.equals(Character.TYPE)) {
                byte[] ba = this.convertPayloadToByteArray();
                char message = '\u0000';
                try {
                    message = Utils.byteArrayToChar(ba);
                }
                catch (WsocBufferException wsocBufferException) {
                    void e;
                    FFDCFilter.processException((Throwable)wsocBufferException, (String)"com.ibm.ws.wsoc.LinkRead", (String)"875", (Object)this, (Object[])new Object[]{ae, m, isLast});
                    this.connLink.callOnError(e.getCause(), true);
                }
                args[msgIndex] = Character.valueOf(message);
            } else if (inputType.equals(Character.class)) {
                byte[] ba = this.convertPayloadToByteArray();
                char message = '\u0000';
                try {
                    message = Utils.byteArrayToChar(ba);
                }
                catch (WsocBufferException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.LinkRead", (String)"884", (Object)this, (Object[])new Object[]{ae, m, isLast});
                    this.connLink.callOnError(e.getCause(), true);
                }
                args[msgIndex] = Character.valueOf(message);
            } else if (inputType.equals(Integer.TYPE)) {
                String payload = this.convertPayloadToString();
                int message = new Integer(payload);
                args[msgIndex] = message;
            } else if (inputType.equals(Integer.class)) {
                String payload = this.convertPayloadToString();
                Integer message = new Integer(payload);
                args[msgIndex] = message;
            } else if (inputType.equals(Long.TYPE)) {
                String payload = this.convertPayloadToString();
                long message = new Long(payload);
                args[msgIndex] = message;
            } else if (inputType.equals(Long.class)) {
                String payload = this.convertPayloadToString();
                Long message = new Long(payload);
                args[msgIndex] = message;
            } else if (inputType.equals(Float.TYPE)) {
                String payload = this.convertPayloadToString();
                float message = new Float(payload).floatValue();
                args[msgIndex] = Float.valueOf(message);
            } else if (inputType.equals(Float.class)) {
                String payload = this.convertPayloadToString();
                Float message = new Float(payload);
                args[msgIndex] = message;
            } else if (inputType.equals(Double.TYPE)) {
                String payload = this.convertPayloadToString();
                double message = new Double(payload);
                args[msgIndex] = message;
            } else if (inputType.equals(Double.class)) {
                String payload = this.convertPayloadToString();
                Double message = new Double(payload);
                args[msgIndex] = message;
            } else {
                ArrayList<Decoder> dcList = this.findDecoderFromAppDecoderType(inputType, WsocConnLink.DATA_TYPE.TEXT);
                if (dcList != null && dcList.size() > 0) {
                    Decoder firstDecoder = dcList.get(0);
                    if (firstDecoder instanceof Decoder.Text) {
                        String message = this.convertMessageToString();
                        Decoder dc = this.findWillDecodeDecoder(dcList, message);
                        if (dc != null) {
                            try {
                                Object appObj;
                                dc.init(this.endpointConfig);
                                args[msgIndex] = appObj = ((Decoder.Text)dc).decode(message);
                            }
                            catch (DecodeException appObj) {
                                void e;
                                FFDCFilter.processException((Throwable)appObj, (String)"com.ibm.ws.wsoc.LinkRead", (String)"938", (Object)this, (Object[])new Object[]{ae, m, isLast});
                                this.connLink.callOnError((Throwable)e, true);
                                args = null;
                            }
                        }
                    } else if (firstDecoder instanceof Decoder.TextStream) {
                        Reader message = this.convertMessageToReader();
                        try {
                            Object appObj;
                            firstDecoder.init(this.endpointConfig);
                            args[msgIndex] = appObj = ((Decoder.TextStream)firstDecoder).decode(message);
                        }
                        catch (DecodeException appObj) {
                            void e;
                            FFDCFilter.processException((Throwable)appObj, (String)"com.ibm.ws.wsoc.LinkRead", (String)"954", (Object)this, (Object[])new Object[]{ae, m, isLast});
                            args = null;
                            this.connLink.callOnError((Throwable)e, true);
                        }
                        catch (IOException e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("IOException calling onMessage method " + m.getMethod().getName() + " in class " + ae.getServerEndpointClass().getName() + " while decoding Decoder.TextStream type " + ((Decoder.TextStream)firstDecoder).toString() + "Exception is: " + e.getMessage()), (Object[])new Object[0]);
                            }
                            args = null;
                            String msg = Tr.formatMessage((TraceComponent)tc, (String)"decoder.ioexception", (Object[])new Object[]{ae.getServerEndpointClass().getName(), ((Decoder.TextStream)firstDecoder).getClass().getName()});
                            DecodeException de = new DecodeException(msg, e.getMessage(), (Throwable)e);
                            this.connLink.callOnError(de, true);
                        }
                    }
                }
            }
        }
        if (args != null && (obj = this.callOnMessage(args, appInstance = ae.getAppInstance(), m, ae)) != null) {
            this.connLink.writeObject(obj, MessageWriter.WRITE_TYPE.SYNC, null, true);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={IOException.class})
    public boolean processOnMessageBinaryAnnotation(AnnotatedEndpoint ae, EndpointMethodHelper m, boolean isLast) {
        Object appInstance;
        Object obj;
        Object[] args = new Object[m.getMethod().getParameterTypes().length];
        MethodData methodData = ae.getOnMessageBinaryMethod().getMethodData();
        Class<?> inputType = methodData.getMessageType();
        int msgIndex = methodData.getMessageIndex();
        int sessionIndex = methodData.getSessionIndex();
        if (sessionIndex >= 0) {
            args[sessionIndex] = this.connLink.getWsocSession();
        }
        if (inputType.equals(ByteBuffer.class)) {
            int booleanIndex = methodData.getMsgBooleanPairIndex();
            if (booleanIndex >= 0) {
                args[booleanIndex] = isLast;
            } else if (!isLast) {
                return false;
            }
            ByteBuffer message = this.convertMessageToByteBuffer();
            args[msgIndex] = message;
        } else if (inputType.equals(byte[].class)) {
            byte[] message = this.convertPayloadToByteArray();
            args[msgIndex] = message;
            int booleanIndex = methodData.getMsgBooleanPairIndex();
            if (booleanIndex >= 0) {
                args[booleanIndex] = isLast;
            } else if (!isLast) {
                return false;
            }
        } else {
            if (!isLast) {
                return false;
            }
            if (inputType.equals(InputStream.class)) {
                InputStream message = this.convertMessageToInputStream();
                args[msgIndex] = message;
            } else {
                ArrayList<Decoder> dcList = this.findDecoderFromAppDecoderType(inputType, WsocConnLink.DATA_TYPE.BINARY);
                if (dcList != null && dcList.size() > 0) {
                    Decoder firstDecoder = dcList.get(0);
                    if (firstDecoder instanceof Decoder.Binary) {
                        ByteBuffer message = this.convertMessageToByteBuffer();
                        Decoder dc = this.findWillDecodeDecoder(dcList, message);
                        if (dc != null) {
                            try {
                                Object appObj;
                                dc.init(this.endpointConfig);
                                args[msgIndex] = appObj = ((Decoder.Binary)dc).decode(message);
                            }
                            catch (DecodeException appObj) {
                                void e;
                                FFDCFilter.processException((Throwable)appObj, (String)"com.ibm.ws.wsoc.LinkRead", (String)"1054", (Object)this, (Object[])new Object[]{ae, m, isLast});
                                this.connLink.callOnError((Throwable)e, true);
                            }
                        }
                    } else if (firstDecoder instanceof Decoder.BinaryStream) {
                        InputStream message = this.convertMessageToInputStream();
                        try {
                            Object appObj;
                            firstDecoder.init(this.endpointConfig);
                            args[msgIndex] = appObj = ((Decoder.BinaryStream)firstDecoder).decode(message);
                        }
                        catch (DecodeException appObj) {
                            void e;
                            FFDCFilter.processException((Throwable)appObj, (String)"com.ibm.ws.wsoc.LinkRead", (String)"1068", (Object)this, (Object[])new Object[]{ae, m, isLast});
                            this.connLink.callOnError((Throwable)e, true);
                        }
                        catch (IOException e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("IOException calling onMessage method " + m.getMethod().getName() + " in class " + ae.getServerEndpointClass().getName() + " while decoding Decoder.BinaryStream type " + ((Decoder.BinaryStream)firstDecoder).toString() + "Exception is: " + e.getMessage()), (Object[])new Object[0]);
                            }
                            String msg = Tr.formatMessage((TraceComponent)tc, (String)"decoder.ioexception", (Object[])new Object[]{ae.getServerEndpointClass().getName(), ((Decoder.BinaryStream)firstDecoder).getClass().getName()});
                            DecodeException de = new DecodeException(msg, e.getMessage(), (Throwable)e);
                            this.connLink.callOnError(de, true);
                        }
                    }
                }
            }
        }
        if (args != null && (obj = this.callOnMessage(args, appInstance = ae.getAppInstance(), m, ae)) != null) {
            this.connLink.writeObject(obj, MessageWriter.WRITE_TYPE.SYNC, null, true);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Sensitive
    public Object callOnMessage(@Sensitive Object[] args, Object _appInstance, EndpointMethodHelper _m, AnnotatedEndpoint ae) {
        Object methodReturn = null;
        try {
            _m.processPathParameters(ae, args);
        }
        catch (DecodeException decodeException) {
            void e;
            Object[] objectArray = new Object[4];
            objectArray[0] = "<sensitive java.lang.Object[]>";
            objectArray[1] = _appInstance;
            objectArray[2] = _m;
            objectArray[3] = ae;
            FFDCFilter.processException((Throwable)decodeException, (String)"com.ibm.ws.wsoc.LinkRead", (String)"1108", (Object)this, (Object[])objectArray);
            this.connLink.callOnError((Throwable)e, true);
            return null;
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("METHOD: " + _m.getMethod().getName() + " Number of arguments: " + args.length + " Message index: " + _m.getMethodData().getMessageIndex() + " Boolean pair index: " + _m.getMethodData().getMsgBooleanPairIndex() + " Session index: " + _m.getMethodData().getSessionIndex()), (Object[])new Object[0]);
            }
            this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
            methodReturn = _m.getMethod().invoke(_appInstance, args);
        }
        catch (IllegalAccessException e) {
            Object[] objectArray = new Object[4];
            objectArray[0] = "<sensitive java.lang.Object[]>";
            objectArray[1] = _appInstance;
            objectArray[2] = _m;
            objectArray[3] = ae;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.LinkRead", (String)"1129", (Object)this, (Object[])objectArray);
            this.connLink.callOnError(this.getCause(e), true);
        }
        catch (IllegalArgumentException e) {
            Object[] objectArray = new Object[4];
            objectArray[0] = "<sensitive java.lang.Object[]>";
            objectArray[1] = _appInstance;
            objectArray[2] = _m;
            objectArray[3] = ae;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.LinkRead", (String)"1131", (Object)this, (Object[])objectArray);
            this.connLink.callOnError(this.getCause(e), true);
        }
        catch (InvocationTargetException e) {
            Object[] objectArray = new Object[4];
            objectArray[0] = "<sensitive java.lang.Object[]>";
            objectArray[1] = _appInstance;
            objectArray[2] = _m;
            objectArray[3] = ae;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.LinkRead", (String)"1133", (Object)this, (Object[])objectArray);
            this.connLink.callOnError(this.getCause(e), true);
        }
        catch (Throwable e) {
            void t;
            Object[] objectArray = new Object[4];
            objectArray[0] = "<sensitive java.lang.Object[]>";
            objectArray[1] = _appInstance;
            objectArray[2] = _m;
            objectArray[3] = ae;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.LinkRead", (String)"1135", (Object)this, (Object[])objectArray);
            this.connLink.callOnError(this.getCause((Throwable)t), true);
        }
        return methodReturn;
    }

    private Throwable getCause(Throwable t) {
        Throwable cause = t.getCause();
        if (t.getCause() != null) {
            return cause;
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<Decoder> findDecoderFromAppDecoderType(Class<?> typeToLookFor, WsocConnLink.DATA_TYPE dataType) {
        List decoders = this.endpointConfig.getDecoders();
        ArrayList<Object> dcList = null;
        if (decoders == null) {
            return null;
        }
        Class<?> clazz = null;
        try {
            for (Class decoder : decoders) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("looking at decoder: " + decoder), (Object[])new Object[0]);
                }
                ArrayList<Type> interfaces = new ArrayList<Type>();
                Utils.getAllInterfaces(decoder, interfaces);
                Object[] ta = interfaces.toArray();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ta[]: " + Arrays.toString(ta)), (Object[])new Object[0]);
                }
                for (Object t : ta) {
                    clazz = Utils.getCodingClass((Type)t);
                    if (clazz == null || !clazz.equals(typeToLookFor)) continue;
                    dcList = this.getDecoderFromCache(clazz);
                    if (dcList == null) {
                        dcList = new ArrayList();
                        dcList.add((Decoder)decoder.newInstance());
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("(1) Added decoder of class: " + decoder), (Object[])new Object[0]);
                        }
                    } else {
                        boolean foundOne = false;
                        for (int i = 0; i < dcList.size(); ++i) {
                            if (!decoder.equals(((Decoder)dcList.get(i)).getClass())) continue;
                            foundOne = true;
                            break;
                        }
                        if (!foundOne) {
                            dcList.add((Decoder)decoder.newInstance());
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("(2) Added decoder of class: " + decoder), (Object[])new Object[0]);
                            }
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Number of decoders: " + dcList.size()), (Object[])new Object[0]);
                    }
                    if (dcList.get(0) instanceof Decoder.Binary) {
                        this.binaryDecoders.put(clazz, dcList);
                        continue;
                    }
                    if (dcList.get(0) instanceof Decoder.Text) {
                        this.textDecoders.put(clazz, dcList);
                        continue;
                    }
                    if (dcList.get(0) instanceof Decoder.BinaryStream) {
                        this.binaryStreamDecoders.put(clazz, dcList);
                        continue;
                    }
                    if (!(dcList.get(0) instanceof Decoder.TextStream)) continue;
                    this.textStreamDecoders.put(clazz, dcList);
                }
            }
        }
        catch (InstantiationException instantiationException) {
            void ie;
            FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.wsoc.LinkRead", (String)"1222", (Object)this, (Object[])new Object[]{typeToLookFor, dataType});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Problem creating new instance of decoder class " + clazz.getName() + " Exception: " + ie.getMessage() + ". Calling Endpoint.onError()"), (Object[])new Object[0]);
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"decoder.create.exception", (Object[])new Object[]{clazz.getName(), ie.getMessage()});
            DecodeException de = new DecodeException(msg, ie.getMessage(), (Throwable)ie);
            this.connLink.callOnError(de, true);
        }
        catch (IllegalAccessException ie) {
            void e;
            FFDCFilter.processException((Throwable)ie, (String)"com.ibm.ws.wsoc.LinkRead", (String)"1231", (Object)this, (Object[])new Object[]{typeToLookFor, dataType});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Problem creating new instance of decoder class " + clazz.getName() + " Exception: " + e.getMessage() + ". Calling Endpoint.onError()"), (Object[])new Object[0]);
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"decoder.create.exception", (Object[])new Object[]{clazz.getName(), e.getMessage()});
            DecodeException de = new DecodeException(msg, e.getMessage(), (Throwable)e);
            this.connLink.callOnError(de, true);
        }
        if (dcList != null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Number of decoders: " + dcList.size()), (Object[])new Object[0]);
        }
        return dcList;
    }

    private ArrayList<Decoder> getDecoderFromCache(Class<?> decoderType) {
        ArrayList<Decoder> dc;
        if (this.binaryDecoders != null && (dc = this.binaryDecoders.get(decoderType)) != null) {
            return dc;
        }
        if (this.textDecoders != null && (dc = this.textDecoders.get(decoderType)) != null) {
            return dc;
        }
        if (this.binaryStreamDecoders != null && (dc = this.binaryStreamDecoders.get(decoderType)) != null) {
            return dc;
        }
        if (this.textStreamDecoders != null && (dc = this.textStreamDecoders.get(decoderType)) != null) {
            return dc;
        }
        return null;
    }

    @Sensitive
    private byte[] convertPayloadToByteArray() {
        return this.convertPayloadToByteArray(false);
    }

    @Sensitive
    private byte[] convertPayloadToByteArray(boolean ControlFrame) {
        int size;
        WsByteBuffer[] buffers;
        if (!ControlFrame) {
            buffers = this.messageReader.getMessagePayload();
            size = this.messageReader.getMessageCompletePayloadSize();
        } else {
            buffers = this.messageReader.getMessagePayload_Control();
            size = this.messageReader.getMessageCompletePayloadSize_Control();
        }
        byte[] result = new byte[size];
        int start = 0;
        int length = 0;
        if (buffers != null) {
            for (WsByteBuffer buf : buffers) {
                length = buf.limit() - buf.position();
                buf.get(result, start, length);
                start += length;
            }
        }
        return result;
    }

    @Sensitive
    private String convertPayloadToString() throws CharacterCodingException {
        WsByteBuffer[] buffers = this.messageReader.getMessagePayload();
        int size = this.messageReader.getMessageCompletePayloadSize();
        byte[] result = new byte[size];
        int start = 0;
        int length = 0;
        for (WsByteBuffer buf : buffers) {
            length = buf.limit() - buf.position();
            buf.get(result, start, length);
            start += length;
        }
        String payload = "";
        if (result.length > 0) {
            payload = Utils.uTF8byteArrayToString(result);
        }
        return payload;
    }

    @Sensitive
    private String convertMessageToString() throws CharacterCodingException {
        String result = null;
        byte[] ba = this.convertPayloadToByteArray();
        result = ba.length > 0 ? Utils.uTF8byteArrayToString(ba) : "";
        return result;
    }

    @Sensitive
    private ByteBuffer convertMessageToByteBuffer() {
        return this.convertMessageToByteBuffer(false);
    }

    @Sensitive
    private ByteBuffer convertMessageToByteBuffer(boolean controlFrame) {
        int size;
        WsByteBuffer[] buffers;
        ByteBuffer result = null;
        if (!controlFrame) {
            buffers = this.messageReader.getMessagePayload();
            size = this.messageReader.getMessageCompletePayloadSize();
        } else {
            buffers = this.messageReader.getMessagePayload_Control();
            size = this.messageReader.getMessageCompletePayloadSize_Control();
        }
        result = ByteBuffer.allocate(size);
        for (WsByteBuffer buf : buffers) {
            result.put(buf.getWrappedByteBuffer());
        }
        result.flip();
        return result;
    }

    private InputStream convertMessageToInputStream() {
        byte[] ba = this.convertPayloadToByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(ba);
        return is;
    }

    private Reader convertMessageToReader() throws CharacterCodingException {
        byte[] ba = this.convertPayloadToByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(ba);
        CharsetDecoder d = Utils.UTF8_CHARSET.newDecoder();
        InputStreamReader isr = new InputStreamReader((InputStream)is, d);
        return isr;
    }

    private Class<?> getMessageHandlerConsumerClass(MessageHandler mh) {
        ArrayList<Type> interfaces = new ArrayList<Type>();
        Utils.getAllInterfaces(mh.getClass(), interfaces);
        Object[] ta = interfaces.toArray();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ta[]: " + Arrays.toString(ta)), (Object[])new Object[0]);
        }
        for (Object t : ta) {
            Type t2;
            Type[] ta2;
            ParameterizedType pt;
            Type rawType;
            if (!((Type)t instanceof ParameterizedType)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(t + " is instanceof ParameterizedType"), (Object[])new Object[0]);
            }
            if (!((rawType = (pt = (ParameterizedType)t).getRawType()) instanceof Class)) continue;
            Class clazz = (Class)rawType;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("rawType: " + clazz.getName()), (Object[])new Object[0]);
            }
            if (!clazz.equals(MessageHandler.Whole.class) && !clazz.equals(MessageHandler.Partial.class) || (ta2 = pt.getActualTypeArguments()).length != 1 || !((t2 = ta2[0]) instanceof Class)) continue;
            Class clazz2 = (Class)t2;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found match: " + clazz2), (Object[])new Object[0]);
            }
            return clazz2;
        }
        return null;
    }

    public void destroy(Exception e) {
        if (this.binaryDecoders != null) {
            this.destroyDecoders(this.binaryDecoders);
        }
        if (this.textDecoders != null) {
            this.destroyDecoders(this.textDecoders);
        }
        if (this.binaryStreamDecoders != null) {
            this.destroyDecoders(this.binaryStreamDecoders);
        }
        if (this.textStreamDecoders != null) {
            this.destroyDecoders(this.textStreamDecoders);
        }
    }

    private void destroyDecoders(Map<?, ArrayList<Decoder>> _decoders) {
        Iterator<Map.Entry<?, ArrayList<Decoder>>> it = _decoders.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<?, ArrayList<Decoder>> entry = it.next();
            ArrayList<Decoder> dcList = entry.getValue();
            for (int i = 0; i < dcList.size(); ++i) {
                dcList.get(i).destroy();
            }
            it.remove();
        }
    }

    public void addMessageHandler(MessageHandler handler) throws IllegalStateException {
        this.determineAndSetMessageHandler(null, handler);
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Whole<T> handler) {
        this.determineAndSetMessageHandler(clazz, (MessageHandler)handler);
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Partial<T> handler) {
        this.determineAndSetMessageHandler(clazz, (MessageHandler)handler);
    }

    public Set<MessageHandler> getMessageHandlers() {
        HashSet<MessageHandler> set = new HashSet<MessageHandler>();
        if (this.appTextMessageHandler != null) {
            set.add(this.appTextMessageHandler);
        } else if (this.appTextPartialMessageHandler != null) {
            set.add(this.appTextPartialMessageHandler);
        }
        if (this.appBinaryMessageHandler != null) {
            set.add(this.appBinaryMessageHandler);
        } else if (this.appBinaryPartialMessageHandler != null) {
            set.add(this.appBinaryPartialMessageHandler);
        }
        if (this.appPongMessageHandler != null) {
            set.add(this.appPongMessageHandler);
        }
        return set;
    }

    public void removeMessageHandler(MessageHandler handler) {
        if (handler == null) {
            return;
        }
        if (handler.equals(this.appTextMessageHandler)) {
            this.appTextMessageHandler = null;
        } else if (handler.equals(this.appBinaryMessageHandler)) {
            this.appBinaryMessageHandler = null;
        } else if (handler.equals(this.appTextPartialMessageHandler)) {
            this.appTextPartialMessageHandler = null;
        } else if (handler.equals(this.appBinaryPartialMessageHandler)) {
            this.appBinaryPartialMessageHandler = null;
        } else if (handler.equals(this.appPongMessageHandler)) {
            this.appPongMessageHandler = null;
        }
    }

    public void cancelRead() {
        this.tcpReadContext.read(1L, null, true, -2);
    }

    private <T> WsocConnLink.DATA_TYPE determineAndSetMessageHandler(Class<T> cl, MessageHandler _mh) throws IllegalStateException, IllegalArgumentException {
        boolean isPartial = false;
        Class<Object> clazz = null;
        clazz = cl == null ? this.getMessageHandlerConsumerClass(_mh) : cl;
        if (MessageHandler.Partial.class.isAssignableFrom(_mh.getClass())) {
            isPartial = true;
        }
        if (clazz.equals(String.class) || clazz.equals(Reader.class)) {
            if (this.annotatedTextMethodPresent || this.appTextMessageHandler != null || this.appTextPartialMessageHandler != null) {
                IllegalStateException x = new IllegalStateException();
                throw x;
            }
            if (isPartial) {
                this.appTextPartialMessageHandler = _mh;
                this.appTextPartialMessageHandlerClass = clazz;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("appTextPartialMessageHandler set for: " + _mh), (Object[])new Object[0]);
                }
            } else {
                this.appTextMessageHandler = _mh;
                this.appTextMessageHandlerClass = clazz;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("appTextMessageHandler set for: " + _mh), (Object[])new Object[0]);
                }
            }
            return WsocConnLink.DATA_TYPE.TEXT;
        }
        if (clazz.equals(ByteBuffer.class) || clazz.equals(byte[].class) || clazz.equals(InputStream.class)) {
            if (this.annotatedBinaryMethodPresent || this.appBinaryMessageHandler != null || this.appBinaryPartialMessageHandler != null) {
                IllegalStateException x = new IllegalStateException();
                throw x;
            }
            if (isPartial) {
                this.appBinaryPartialMessageHandler = _mh;
                this.appBinaryPartialMessageHandlerClass = clazz;
            } else {
                this.appBinaryMessageHandler = _mh;
                this.appBinaryMessageHandlerClass = clazz;
            }
            return WsocConnLink.DATA_TYPE.BINARY;
        }
        if (clazz.equals(PongMessage.class)) {
            if (this.annotatedPongMethodPresent || this.appPongMessageHandler != null) {
                IllegalStateException x = new IllegalStateException();
                throw x;
            }
            this.appPongMessageHandler = _mh;
            this.appPongMessageHandlerClass = clazz;
            return WsocConnLink.DATA_TYPE.PONG;
        }
        WsocConnLink.DATA_TYPE dt = this.findDecoderTypeFromAppDecoderType(clazz);
        if (dt == WsocConnLink.DATA_TYPE.TEXT) {
            this.appTextMessageHandler = _mh;
            this.appTextMessageHandlerClass = clazz;
            return WsocConnLink.DATA_TYPE.TEXT;
        }
        if (dt == WsocConnLink.DATA_TYPE.BINARY) {
            this.appBinaryMessageHandler = _mh;
            this.appBinaryMessageHandlerClass = clazz;
            return WsocConnLink.DATA_TYPE.BINARY;
        }
        IllegalArgumentException iae = new IllegalArgumentException();
        throw iae;
    }

    private WsocConnLink.DATA_TYPE findDecoderTypeFromAppDecoderType(Class<?> typeToLookFor) {
        List decoders = this.endpointConfig.getDecoders();
        if (decoders == null) {
            return null;
        }
        for (Class decoder : decoders) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("looking at decoder: " + decoder), (Object[])new Object[0]);
            }
            ArrayList<Type> interfaces = new ArrayList<Type>();
            Utils.getAllInterfaces(decoder, interfaces);
            Object[] ta = interfaces.toArray();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ta[]: " + Arrays.toString(ta)), (Object[])new Object[0]);
            }
            for (Object t : ta) {
                Class<?> clazz = Utils.getCodingClass((Type)t);
                if (clazz == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("clazz " + clazz.getName()), (Object[])new Object[0]);
                }
                if (!clazz.equals(typeToLookFor)) continue;
                if (Decoder.Text.class.isAssignableFrom(decoder) || Decoder.TextStream.class.isAssignableFrom(decoder)) {
                    return WsocConnLink.DATA_TYPE.TEXT;
                }
                if (!Decoder.Binary.class.isAssignableFrom(decoder) && !Decoder.BinaryStream.class.isAssignableFrom(decoder)) continue;
                return WsocConnLink.DATA_TYPE.BINARY;
            }
        }
        return null;
    }

    private Decoder findWillDecodeDecoder(ArrayList<Decoder> dcList, Object message) {
        Decoder decoder = null;
        boolean willDecode = false;
        for (int i = 0; i < dcList.size() && !((decoder = dcList.get(i)) instanceof Decoder.Text ? (willDecode = ((Decoder.Text)decoder).willDecode((String)message)) : decoder instanceof Decoder.Binary && (willDecode = ((Decoder.Binary)decoder).willDecode((ByteBuffer)message))); ++i) {
        }
        if (willDecode) {
            return decoder;
        }
        return null;
    }

    public void resetReader() {
        if (this.messageReader != null) {
            this.messageReader.reset();
        }
    }

    private static enum PartialState {
        NOT_ATTEMPTED,
        MESSAGE_HANDLER_ATTEMPTED,
        AE_TEXT_ATTEMPTED,
        AE_BINARY_ATTEMPTED,
        OFF;

    }
}

