/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.yoko.util.CollectionExtras;

abstract class Connection {
    private static final Logger logger = Logger.getLogger(Connection.class.getName());
    private State state;
    private int flags = 0;

    Connection(State initialState) {
        this.state = initialState;
    }

    synchronized State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setState(State newState) {
        Connection connection = this;
        synchronized (connection) {
            if (this.state.cannotTransitionTo(newState)) {
                logger.fine("No state change from " + (Object)((Object)this.state) + " to " + (Object)((Object)newState));
                return false;
            }
            this.state = newState;
        }
        this.state.applyTo(this);
        return true;
    }

    final synchronized boolean isRequestSent() {
        return (this.flags & 1) != 0;
    }

    final synchronized boolean isDestroyed() {
        return (this.flags & 4) != 0;
    }

    final synchronized boolean isReplySent() {
        return (this.flags & 2) != 0;
    }

    final synchronized boolean isOutbound() {
        return (this.flags & 8) != 0;
    }

    final synchronized boolean isClientEnabled() {
        return (this.flags & 0x10) != 0;
    }

    final synchronized boolean isServerEnabled() {
        return (this.flags & 0x20) != 0;
    }

    final synchronized void markRequestSent() {
        this.flags |= 1;
    }

    final synchronized void markDestroyed() {
        this.flags |= 4;
    }

    final synchronized void markOutbound() {
        this.flags |= 8;
    }

    final synchronized void markClientEnabled() {
        this.flags |= 0x10;
    }

    final synchronized void markServerEnabled() {
        this.flags |= 0x20;
    }

    final synchronized boolean markClosingLogged() {
        try {
            boolean bl = (this.flags & 0x40) == 0;
            return bl;
        }
        finally {
            this.flags |= 0x40;
        }
    }

    abstract void ACM_callback();

    abstract void start();

    abstract void refresh();

    abstract void pause();

    abstract void gracefulShutdown();

    abstract void abortiveShutdown();

    abstract void close();

    static interface Flag {
        public static final int REQUEST_SENT = 1;
        public static final int DESTROYED = 4;
        public static final int REPLY_SENT = 2;
        public static final int OUTBOUND = 8;
        public static final int CLIENT_ENABLED = 16;
        public static final int SERVER_ENABLED = 32;
        public static final int CLOSING_LOGGED = 64;
    }

    static enum State {
        ACTIVE(new Access[]{Access.READ, Access.WRITE}){

            @Override
            void applyTo(Connection conn) {
                conn.start();
                conn.refresh();
            }
        }
        ,
        HOLDING(new Access[]{Access.WRITE}){

            @Override
            void applyTo(Connection conn) {
                conn.pause();
            }
        }
        ,
        CLOSING(new Access[]{Access.READ, Access.WRITE, Access.CLOSE}){

            @Override
            void applyTo(Connection conn) {
                conn.gracefulShutdown();
                conn.refresh();
            }
        }
        ,
        ERROR(new Access[]{Access.CLOSE}){

            @Override
            void applyTo(Connection conn) {
                conn.abortiveShutdown();
                conn.markDestroyed();
                conn.refresh();
            }
        }
        ,
        CLOSED{

            @Override
            void applyTo(Connection conn) {
                conn.close();
                conn.markDestroyed();
                conn.refresh();
            }
        }
        ,
        STALE{

            @Override
            void applyTo(Connection conn) {
            }
        };

        private final Set<Access> permissions;
        private static final Map<State, Set<?>> ALLOWED_TRANSITIONS;

        private State() {
            this.permissions = Collections.EMPTY_SET;
        }

        private State(Access ... permissions) {
            this.permissions = Collections.unmodifiableSet(EnumSet.of(permissions[0], permissions));
        }

        final boolean cannotTransitionTo(State next) {
            return !this.canGoTo(next);
        }

        private boolean canGoTo(State next) {
            return ALLOWED_TRANSITIONS.get((Object)this).contains((Object)next);
        }

        final boolean forbids(Access op) {
            return !this.permissions.contains((Object)op);
        }

        final boolean isClosed() {
            return this == CLOSED || this == STALE;
        }

        abstract void applyTo(Connection var1);

        static {
            EnumMap<State, Set> map = new EnumMap<State, Set>(State.class);
            ALLOWED_TRANSITIONS = Collections.unmodifiableMap(map);
            map.put(ACTIVE, CollectionExtras.readOnlyEnumSet((Enum)HOLDING, (Enum[])new State[]{CLOSING, ERROR, CLOSED}));
            map.put(HOLDING, CollectionExtras.readOnlyEnumSet((Enum)ACTIVE, (Enum[])new State[]{CLOSING, ERROR, CLOSED}));
            map.put(CLOSING, CollectionExtras.readOnlyEnumSet((Enum)ERROR, (Enum[])new State[]{CLOSED}));
            map.put(ERROR, CollectionExtras.readOnlyEnumSet((Enum)CLOSED, (Enum[])new State[0]));
            map.put(CLOSED, CollectionExtras.readOnlyEnumSet((Enum)STALE, (Enum[])new State[0]));
            map.put(STALE, Collections.EMPTY_SET);
        }
    }

    static enum Access {
        READ,
        WRITE,
        CLOSE;

    }
}

