/*
 * Decompiled with CFR 0.152.
 */
package io.openfuture.sdk.sender;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.openfuture.sdk.domain.error.Error;
import io.openfuture.sdk.exception.ClientException;
import io.openfuture.sdk.exception.ServerException;
import io.openfuture.sdk.sender.BaseSender$WhenMappings;
import io.openfuture.sdk.util.HttpStatusGroup;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J)\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\rH\u0004\u00a2\u0006\u0002\u0010\u000eJ)\u0010\u000f\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\rH\u0004\u00a2\u0006\u0002\u0010\u000eJ5\u0010\u0010\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0004\u00a2\u0006\u0002\u0010\u0012J5\u0010\u0013\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0004\u00a2\u0006\u0002\u0010\u0012J5\u0010\u0014\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0004\u00a2\u0006\u0002\u0010\u0012J)\u0010\u0015\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\rH\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/openfuture/sdk/sender/BaseSender;", "", "baseRoute", "", "token", "(Ljava/lang/String;Ljava/lang/String;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "openRoute", "delete", "T", "route", "responseClass", "Lcom/fasterxml/jackson/core/type/TypeReference;", "(Ljava/lang/String;Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "get", "patch", "body", "(Ljava/lang/String;Lcom/fasterxml/jackson/core/type/TypeReference;Ljava/lang/Object;)Ljava/lang/Object;", "post", "put", "send", "request", "Lorg/apache/http/client/methods/HttpUriRequest;", "(Lorg/apache/http/client/methods/HttpUriRequest;Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "sdk"})
public abstract class BaseSender {
    private final String openRoute;
    private final ObjectMapper mapper;
    private final String token;

    protected final <T> T get(@NotNull String route, @NotNull TypeReference<T> responseClass) {
        Intrinsics.checkParameterIsNotNull((Object)route, (String)"route");
        Intrinsics.checkParameterIsNotNull(responseClass, (String)"responseClass");
        return this.send((HttpUriRequest)new HttpGet(this.openRoute + route), responseClass);
    }

    protected final <T> T post(@NotNull String route, @NotNull TypeReference<T> responseClass, @Nullable Object body) {
        HttpPost request;
        block0: {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)route, (String)"route");
            Intrinsics.checkParameterIsNotNull(responseClass, (String)"responseClass");
            request = new HttpPost(this.openRoute + route);
            Object object2 = body;
            if (object2 == null) break block0;
            Object it = object = object2;
            request.setEntity((HttpEntity)new StringEntity(this.mapper.writeValueAsString(it)));
            ContentType contentType = ContentType.APPLICATION_JSON;
            Intrinsics.checkExpressionValueIsNotNull((Object)contentType, (String)"APPLICATION_JSON");
            request.addHeader("Content-Type", contentType.getMimeType());
        }
        return this.send((HttpUriRequest)request, responseClass);
    }

    public static /* bridge */ /* synthetic */ Object post$default(BaseSender baseSender, String string, TypeReference typeReference, Object object, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: post");
        }
        if ((n & 4) != 0) {
            object = null;
        }
        return baseSender.post(string, typeReference, object);
    }

    protected final <T> T put(@NotNull String route, @NotNull TypeReference<T> responseClass, @Nullable Object body) {
        HttpPut request;
        block0: {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)route, (String)"route");
            Intrinsics.checkParameterIsNotNull(responseClass, (String)"responseClass");
            request = new HttpPut(this.openRoute + route);
            Object object2 = body;
            if (object2 == null) break block0;
            Object it = object = object2;
            request.setEntity((HttpEntity)new StringEntity(this.mapper.writeValueAsString(it)));
            ContentType contentType = ContentType.APPLICATION_JSON;
            Intrinsics.checkExpressionValueIsNotNull((Object)contentType, (String)"APPLICATION_JSON");
            request.addHeader("Content-Type", contentType.getMimeType());
        }
        return this.send((HttpUriRequest)request, responseClass);
    }

    public static /* bridge */ /* synthetic */ Object put$default(BaseSender baseSender, String string, TypeReference typeReference, Object object, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
        }
        if ((n & 4) != 0) {
            object = null;
        }
        return baseSender.put(string, typeReference, object);
    }

    protected final <T> T patch(@NotNull String route, @NotNull TypeReference<T> responseClass, @Nullable Object body) {
        HttpPatch request;
        block0: {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)route, (String)"route");
            Intrinsics.checkParameterIsNotNull(responseClass, (String)"responseClass");
            request = new HttpPatch(this.openRoute + route);
            Object object2 = body;
            if (object2 == null) break block0;
            Object it = object = object2;
            request.setEntity((HttpEntity)new StringEntity(this.mapper.writeValueAsString(it)));
            ContentType contentType = ContentType.APPLICATION_JSON;
            Intrinsics.checkExpressionValueIsNotNull((Object)contentType, (String)"APPLICATION_JSON");
            request.addHeader("Content-Type", contentType.getMimeType());
        }
        return this.send((HttpUriRequest)request, responseClass);
    }

    public static /* bridge */ /* synthetic */ Object patch$default(BaseSender baseSender, String string, TypeReference typeReference, Object object, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: patch");
        }
        if ((n & 4) != 0) {
            object = null;
        }
        return baseSender.patch(string, typeReference, object);
    }

    protected final <T> T delete(@NotNull String route, @NotNull TypeReference<T> responseClass) {
        Intrinsics.checkParameterIsNotNull((Object)route, (String)"route");
        Intrinsics.checkParameterIsNotNull(responseClass, (String)"responseClass");
        return this.send((HttpUriRequest)new HttpDelete(this.openRoute + route), responseClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <T> T send(HttpUriRequest request, TypeReference<T> responseClass) {
        Object object;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Closeable closeable = (Closeable)client;
        Throwable throwable = null;
        try {
            CloseableHttpResponse response;
            CloseableHttpClient it = (CloseableHttpClient)closeable;
            request.addHeader("Authorization", this.token);
            CloseableHttpResponse closeableHttpResponse = response = it.execute(request);
            Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"response");
            StatusLine statusLine = closeableHttpResponse.getStatusLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"response.statusLine");
            switch (BaseSender$WhenMappings.$EnumSwitchMapping$0[HttpStatusGroup.Companion.valueOf(statusLine.getStatusCode()).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    void $receiver$iv;
                    void content$iv;
                    ClientException clientException;
                    ObjectMapper objectMapper = this.mapper;
                    String string = EntityUtils.toString((HttpEntity)response.getEntity());
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"toString(response.entity)");
                    String string2 = string;
                    ClientException clientException2 = clientException;
                    ClientException clientException3 = clientException;
                    void var12_14 = content$iv;
                    void var13_15 = $receiver$iv;
                    TypeReference typeReference = (TypeReference)new TypeReference<Error>(){};
                    Object object2 = var13_15.readValue((String)var12_14, typeReference);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"readValue(content, jacksonTypeRef<T>())");
                    Object object3 = object2;
                    clientException2(((Error)object3).getMessage());
                    throw (Throwable)clientException3;
                }
                case 3: 
                case 4: 
                case 5: {
                    throw (Throwable)new ServerException("There are some troubles on server. Please try later");
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            object = this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), responseClass);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (T)object;
    }

    public BaseSender(@NotNull String baseRoute, @NotNull String token) {
        Intrinsics.checkParameterIsNotNull((Object)baseRoute, (String)"baseRoute");
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        this.token = token;
        this.openRoute = "https://api.openfuture.io" + baseRoute;
        this.mapper = ExtensionsKt.jacksonObjectMapper();
    }
}

