/*
 * Decompiled with CFR 0.152.
 */
package io.openfuture.chain.smartcontract.model;

import io.openfuture.chain.smartcontract.model.ExecutionContext;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH&J\b\u0010\r\u001a\u00020\u000eH\u0004J\b\u0010\u000f\u001a\u00020\u0004H\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000eH\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lio/openfuture/chain/smartcontract/model/SmartContract;", "Ljava/io/Serializable;", "()V", "address", "", "getAddress", "()Ljava/lang/String;", "executionContext", "Lio/openfuture/chain/smartcontract/model/ExecutionContext;", "owner", "getOwner", "execute", "", "getAmount", "", "getIssuerAddress", "transfer", "", "recipientAddress", "amount", "chain-kotlin-sdk"})
public abstract class SmartContract
implements Serializable {
    @NotNull
    private final String owner = "";
    @NotNull
    private final String address = "";
    private ExecutionContext executionContext;

    @NotNull
    public final String getOwner() {
        return this.owner;
    }

    @NotNull
    public final String getAddress() {
        return this.address;
    }

    public abstract void execute();

    protected final boolean transfer(@NotNull String recipientAddress, long amount) {
        Intrinsics.checkParameterIsNotNull((Object)recipientAddress, (String)"recipientAddress");
        ExecutionContext executionContext = this.executionContext;
        if (executionContext == null) {
            Intrinsics.throwNpe();
        }
        return executionContext.addTransfer(recipientAddress, amount);
    }

    protected final long getAmount() {
        ExecutionContext executionContext = this.executionContext;
        if (executionContext == null) {
            Intrinsics.throwNpe();
        }
        return executionContext.getAmount();
    }

    @NotNull
    protected final String getIssuerAddress() {
        ExecutionContext executionContext = this.executionContext;
        if (executionContext == null) {
            Intrinsics.throwNpe();
        }
        return executionContext.getIssuerAddress();
    }
}

