/*
 * Decompiled with CFR 0.152.
 */
package io.openfuture.chain.smartcontract.component.validation;

import io.openfuture.chain.smartcontract.component.validation.Whitelist;
import io.openfuture.chain.smartcontract.model.SmartContract;
import io.openfuture.chain.smartcontract.model.ValidationResult;
import io.openfuture.chain.smartcontract.util.TypeExtensionsKt;
import java.lang.reflect.Modifier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002JM\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0010\u0010\u0012\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J:\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016JC\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0010\u0010\u001c\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u001dR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lio/openfuture/chain/smartcontract/component/validation/SmartContractVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "()V", "validationResult", "Lio/openfuture/chain/smartcontract/model/ValidationResult;", "getValidationResult", "()Lio/openfuture/chain/smartcontract/model/ValidationResult;", "validateType", "", "classType", "", "visit", "version", "", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitField", "Lorg/objectweb/asm/FieldVisitor;", "descriptor", "value", "", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "Companion", "SourceMethodVisitor", "chain-kotlin-sdk"})
public final class SmartContractVisitor
extends ClassVisitor {
    @NotNull
    private final ValidationResult validationResult = new ValidationResult();
    private static final String superContractName;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public final ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public void visit(int version, int access, @Nullable String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        if (superName == null || Intrinsics.areEqual((Object)superName, (Object)superContractName) ^ true) {
            this.validationResult.addError("Class is not a smart contract. Should inherit a " + superContractName + " class");
        }
        if (interfaces != null) {
            String[] $receiver$iv;
            String[] stringArray = $receiver$iv = interfaces;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl = false;
                this.validateType(TypeExtensionsKt.getAsPackagePath(it));
            }
        }
        log.debug("CLASS: name-" + name + ", superName-" + superName + ", signature-" + signature + ", version-" + version);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Nullable
    public FieldVisitor visitField(int access, @Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable Object value) {
        String string = descriptor;
        SmartContractVisitor smartContractVisitor = this;
        String it = string;
        boolean bl = false;
        Type type = Type.getType((String)descriptor);
        String string2 = type != null ? type.getClassName() : null;
        smartContractVisitor.validateType(string2);
        log.debug("FIELD: name-" + name + ", descriptor-" + descriptor + ", signature-" + signature);
        return super.visitField(access, name, descriptor, signature, value);
    }

    @NotNull
    public MethodVisitor visitMethod(int access, @NotNull String name, @Nullable String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (Modifier.isNative(access)) {
            this.validationResult.addError("Native methods not allowed");
        }
        if (Modifier.isSynchronized(access)) {
            this.validationResult.addError("Synchronized methods not allowed");
        }
        String string = descriptor;
        SmartContractVisitor smartContractVisitor = this;
        String it = string;
        boolean bl = false;
        Type type = Type.getReturnType((String)descriptor);
        String string2 = type != null ? type.getClassName() : null;
        smartContractVisitor.validateType(string2);
        log.debug("METHOD: name-" + name + ", descriptor-" + descriptor + ", signature-" + signature + ", exceptions-" + exceptions);
        return new SourceMethodVisitor();
    }

    private final void validateType(String classType) {
        if (classType != null && !Whitelist.INSTANCE.isAllowedType(classType)) {
            this.validationResult.addError(classType + " is forbidden in the smart contract");
        }
    }

    public SmartContractVisitor() {
        super(393216);
    }

    static {
        Companion = new Companion(null);
        String string = SmartContract.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SmartContract::class.java.name");
        superContractName = TypeExtensionsKt.getAsResourcePath(string);
        log = LoggerFactory.getLogger(SmartContractVisitor.class);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0016J6\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J0\u0010\u0013\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0016J\u001a\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0017"}, d2={"Lio/openfuture/chain/smartcontract/component/validation/SmartContractVisitor$SourceMethodVisitor;", "Lorg/objectweb/asm/MethodVisitor;", "(Lio/openfuture/chain/smartcontract/component/validation/SmartContractVisitor;)V", "visitLocalVariable", "", "name", "", "descriptor", "signature", "start", "Lorg/objectweb/asm/Label;", "end", "index", "", "visitMethodInsn", "opcode", "owner", "isInterface", "", "visitTryCatchBlock", "handler", "type", "visitTypeInsn", "chain-kotlin-sdk"})
    private final class SourceMethodVisitor
    extends MethodVisitor {
        public void visitLocalVariable(@Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable Label start, @Nullable Label end, int index) {
            if (name != null && Intrinsics.areEqual((Object)"this", (Object)name) ^ true) {
                String string = descriptor;
                SmartContractVisitor smartContractVisitor = SmartContractVisitor.this;
                String it = string;
                boolean bl = false;
                Type type = Type.getType((String)descriptor);
                String string2 = type != null ? type.getClassName() : null;
                smartContractVisitor.validateType(string2);
            }
            log.debug("LOCAL_VAR: name-" + name + ", descriptor-" + descriptor);
            super.visitLocalVariable(name, descriptor, signature, start, end, index);
        }

        public void visitTryCatchBlock(@Nullable Label start, @Nullable Label end, @Nullable Label handler, @Nullable String type) {
            String string = type;
            SmartContractVisitor.this.validateType(string != null ? TypeExtensionsKt.getAsPackagePath(string) : null);
            log.debug("TRY_CATCH: type-" + type);
            super.visitTryCatchBlock(start, end, handler, type);
        }

        public void visitTypeInsn(int opcode, @Nullable String type) {
            String string = type;
            SmartContractVisitor.this.validateType(string != null ? TypeExtensionsKt.getAsPackagePath(string) : null);
            log.debug("TYPE: type-" + type);
            super.visitTypeInsn(opcode, type);
        }

        public void visitMethodInsn(int opcode, @Nullable String owner, @Nullable String name, @Nullable String descriptor, boolean isInterface) {
            String string = owner;
            if (string != null) {
                String string2;
                String it = string2 = string;
                boolean bl = false;
                String string3 = name;
                if (string3 != null) {
                    String string4;
                    String it2 = string4 = string3;
                    boolean bl2 = false;
                    String fullName = TypeExtensionsKt.getAsPackagePath(owner + '/' + name);
                    if (!Whitelist.INSTANCE.isAllowedMethod(fullName)) {
                        SmartContractVisitor.this.getValidationResult().addError("Method`s name: " + fullName + " is not allowed");
                    }
                }
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        public SourceMethodVisitor() {
            super(393216);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/openfuture/chain/smartcontract/component/validation/SmartContractVisitor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "superContractName", "", "chain-kotlin-sdk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

