/*
 * Decompiled with CFR 0.152.
 */
package io.openfuture.chain.smartcontract.component.validation;

import io.openfuture.chain.smartcontract.component.validation.SmartContractVisitor;
import io.openfuture.chain.smartcontract.model.ValidationResult;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/openfuture/chain/smartcontract/component/validation/SmartContractValidator;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "validate", "", "bytes", "", "chain-kotlin-sdk"})
public final class SmartContractValidator {
    private static final Logger log;
    public static final SmartContractValidator INSTANCE;

    public final boolean validate(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        ClassReader reader = null;
        try {
            reader = new ClassReader(bytes);
        }
        catch (Exception e) {
            log.warn("Bytes does not match with bytecode");
            return false;
        }
        SmartContractVisitor visitor = new SmartContractVisitor();
        reader.accept((ClassVisitor)visitor, 2);
        ValidationResult result = visitor.getValidationResult();
        if (result.hasErrors()) {
            log.warn(CollectionsKt.joinToString$default((Iterable)result.getErrors(), (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null));
            return false;
        }
        return true;
    }

    private SmartContractValidator() {
    }

    static {
        SmartContractValidator smartContractValidator;
        INSTANCE = smartContractValidator = new SmartContractValidator();
        log = LoggerFactory.getLogger(SmartContractValidator.class);
    }
}

