/*
 * Decompiled with CFR 0.152.
 */
package io.opencubes.boxlin.adapter;

import io.opencubes.boxlin.adapter.BoxlinContainer;
import io.opencubes.boxlin.adapter.BoxlinContext;
import io.opencubes.boxlin.adapter.FunctionInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;

public final class BoxlinContainerFunctional
extends BoxlinContainer {
    private Object instance;
    private final FunctionInfo info;
    private static final Map<Class<?>, Supplier<Object>> injectables = new HashMap();

    public BoxlinContainerFunctional(IModInfo info, String className, String methodSignature, ClassLoader classLoader, ModFileScanData modFileScanData) {
        super(info, className, classLoader, modFileScanData);
        this.info = new FunctionInfo(methodSignature);
    }

    @Override
    public Object getInstance() {
        if (this.instance == null) {
            Method function;
            Class[] methodParameterClasses = new Class[this.info.getParameterClassNames().length];
            try {
                for (int i = 0; i < this.info.getParameterClassNames().length; ++i) {
                    methodParameterClasses[i] = Class.forName(this.info.getParameterClassNames()[i]);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Unable to load class from functional mod function parameters", e);
            }
            try {
                function = this.getClazz().getMethod(this.info.getName(), methodParameterClasses);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("The function for entry does not exist?");
            }
            try {
                Object[] args = new Object[methodParameterClasses.length];
                for (int i = 0; i < methodParameterClasses.length; ++i) {
                    Supplier<Object> objectGetter = null;
                    for (Map.Entry<Class<?>, Supplier<Object>> entry : injectables.entrySet()) {
                        if (!entry.getKey().isAssignableFrom(methodParameterClasses[i])) continue;
                        objectGetter = entry.getValue();
                    }
                    if (objectGetter == null) {
                        throw new IllegalStateException("No argument can be injected for parameter of type " + this.info.getParameterClassNames()[i]);
                    }
                    args[i] = objectGetter.get();
                }
                Object res = function.invoke(null, args);
                if (!Objects.equals(this.info.getReturnTypeClassName(), "void")) {
                    this.instance = res;
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            BoxlinContainerFunctional.injectEvents(this, this.modFileScanData, this.modClassLoader);
            if (this.instance == null) {
                this.instance = new VirtualModInstance();
            }
        }
        return this.instance;
    }

    static {
        injectables.put(BoxlinContext.class, BoxlinContext::get);
    }

    public static final class VirtualModInstance {
        private VirtualModInstance() {
        }
    }
}

