/*
 * Decompiled with CFR 0.152.
 */
package io.opencubes.boxlin.adapter;

import io.opencubes.boxlin.adapter.BoxlinContainer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;

public final class BoxlinContainerClass
extends BoxlinContainer {
    private Object instance;

    public BoxlinContainerClass(IModInfo info, String className, ClassLoader classLoader, ModFileScanData modFileScanData) {
        super(info, className, classLoader, modFileScanData);
    }

    @Override
    protected Object getInstance() {
        if (this.instance == null) {
            try {
                logger.debug(Logging.LOADING, "Loading mod instance {} ({})", (Object)this.modInfo.getModId(), (Object)this.className);
                if (this.getClazz().getConstructors().length == 0) {
                    try {
                        Field field = this.getClazz().getField("INSTANCE");
                        int modifiers = field.getModifiers();
                        if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                            this.instance = field.get(null);
                        }
                    }
                    catch (IllegalAccessException | NoSuchFieldException field) {
                        // empty catch block
                    }
                }
                if (this.instance == null) {
                    this.instance = this.getClazz().newInstance();
                }
            }
            catch (Throwable e) {
                logger.error(Logging.LOADING, "Failed to load mod instance for " + this.modInfo.getModId() + " (" + this.className + ")", e);
                throw new RuntimeException("Failed to load mod instance for " + this.modInfo.getModId() + " (" + this.className + ")", e);
            }
            BoxlinContainerClass.injectEvents(this, this.modFileScanData, this.modClassLoader);
        }
        return this.instance;
    }
}

