/*
 * Decompiled with CFR 0.152.
 */
package io.opencubes.boxlin.adapter;

import java.util.Objects;
import org.objectweb.asm.Type;

final class FunctionInfo {
    private final String name;
    private final String[] parameterClassNames;
    private final String returnTypeClassName;

    FunctionInfo(String methodSignature) {
        int s1i = methodSignature.indexOf(40);
        int s2i = methodSignature.indexOf(41);
        this.name = methodSignature.substring(0, s1i);
        String params = methodSignature.substring(s1i + 1, s2i);
        String[] typeParams = params.split("(?<=;)");
        if (typeParams.length == 1 && Objects.equals(typeParams[0], "")) {
            this.parameterClassNames = new String[0];
        } else {
            this.parameterClassNames = new String[typeParams.length];
            for (int i = 0; i < typeParams.length; ++i) {
                this.parameterClassNames[i] = Type.getType((String)typeParams[i]).getClassName();
            }
        }
        this.returnTypeClassName = Type.getType((String)methodSignature.substring(s2i + 1)).getClassName();
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameterClassNames() {
        return this.parameterClassNames;
    }

    public String getReturnTypeClassName() {
        return this.returnTypeClassName;
    }

    public String toString() {
        StringBuilder res = new StringBuilder(this.name + "(");
        for (int i = 0; i < this.parameterClassNames.length; ++i) {
            res.append(this.parameterClassNames[i]);
            if (i + 1 == this.parameterClassNames.length) continue;
            res.append(",");
        }
        res.append("): ");
        res.append(this.returnTypeClassName);
        return res.toString();
    }
}

