/*
 * Decompiled with CFR 0.152.
 */
package io.opencubes.boxlin.adapter;

import io.opencubes.boxlin.adapter.BoxlinProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.forgespi.language.ModFileScanData;

public final class BoxlinModLoaderClass
implements IModLanguageProvider.IModLanguageLoader {
    private String className;

    public BoxlinModLoaderClass(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public <T> T loadMod(IModInfo info, ClassLoader modClassLoader, ModFileScanData modFileScanResults) {
        try {
            Class<?> fmlContainer = Class.forName("io.opencubes.boxlin.adapter.BoxlinContainerClass", true, Thread.currentThread().getContextClassLoader());
            BoxlinProvider.logger.debug(Logging.LOADING, "Loading BoxlinClassContainerJ from classloader {} - got {}", (Object)Thread.currentThread().getContextClassLoader(), (Object)fmlContainer.getClassLoader());
            Constructor<?> constructor = fmlContainer.getConstructor(IModInfo.class, String.class, ClassLoader.class, ModFileScanData.class);
            return (T)constructor.newInstance(info, this.className, modClassLoader, modFileScanResults);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            BoxlinProvider.logger.fatal(Logging.LOADING, "Unable to load FMLModContainer, wut?", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

