/*
 * Decompiled with CFR 0.152.
 */
package io.opencubes.boxlin.adapter;

import io.opencubes.boxlin.adapter.BoxlinContext;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.EventBusErrorMessage;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LifecycleEventProvider;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.objectweb.asm.Type;

public abstract class BoxlinContainer
extends ModContainer {
    protected static Logger logger = LogManager.getLogger();
    private IEventBus eventBus = BusBuilder.builder().setExceptionHandler((bus, event, listeners, index, throwable) -> logger.error((Message)new EventBusErrorMessage(event, index, listeners, throwable))).build();
    protected ClassLoader modClassLoader;
    protected String className;
    private Class<?> clazz;
    protected ModFileScanData modFileScanData;
    private static Type AUTO_SUBSCRIBER = Type.getType(Mod.EventBusSubscriber.class);

    public BoxlinContainer(IModInfo info, String className, ClassLoader classLoader, ModFileScanData modFileScanData) {
        super(info);
        this.modClassLoader = classLoader;
        this.className = className;
        this.modFileScanData = modFileScanData;
        this.triggerMap.put(ModLoadingStage.CONSTRUCT, it -> {
            this.getInstance();
            this.checkError((LifecycleEventProvider.LifecycleEvent)it);
        });
        this.triggerMap.put(ModLoadingStage.CREATE_REGISTRIES, it -> {
            this.postEvent((LifecycleEventProvider.LifecycleEvent)it);
            this.checkError((LifecycleEventProvider.LifecycleEvent)it);
        });
        this.triggerMap.put(ModLoadingStage.LOAD_REGISTRIES, it -> {
            this.postEvent((LifecycleEventProvider.LifecycleEvent)it);
            this.checkError((LifecycleEventProvider.LifecycleEvent)it);
        });
        this.triggerMap.put(ModLoadingStage.COMMON_SETUP, it -> {
            this.postEvent((LifecycleEventProvider.LifecycleEvent)it);
            this.checkError((LifecycleEventProvider.LifecycleEvent)it);
        });
        this.triggerMap.put(ModLoadingStage.SIDED_SETUP, it -> {
            this.postEvent((LifecycleEventProvider.LifecycleEvent)it);
            this.checkError((LifecycleEventProvider.LifecycleEvent)it);
        });
        this.triggerMap.put(ModLoadingStage.ENQUEUE_IMC, it -> {
            this.postEvent((LifecycleEventProvider.LifecycleEvent)it);
            this.checkError((LifecycleEventProvider.LifecycleEvent)it);
        });
        this.triggerMap.put(ModLoadingStage.PROCESS_IMC, it -> {
            this.postEvent((LifecycleEventProvider.LifecycleEvent)it);
            this.checkError((LifecycleEventProvider.LifecycleEvent)it);
        });
        this.triggerMap.put(ModLoadingStage.COMPLETE, it -> {
            this.postEvent((LifecycleEventProvider.LifecycleEvent)it);
            this.checkError((LifecycleEventProvider.LifecycleEvent)it);
        });
        this.triggerMap.put(ModLoadingStage.GATHERDATA, it -> {
            this.postEvent((LifecycleEventProvider.LifecycleEvent)it);
            this.checkError((LifecycleEventProvider.LifecycleEvent)it);
        });
        this.configHandler = Optional.of(it -> this.eventBus.post((Event)it));
        BoxlinContext extension = new BoxlinContext(this);
        this.contextExtension = () -> extension;
    }

    protected abstract Object getInstance();

    private void postEvent(LifecycleEventProvider.LifecycleEvent event) {
        Event e = event.getOrBuildEvent((ModContainer)this);
        logger.debug(Logging.LOADING, "Emitting {} for {}", (Object)e, (Object)this.modInfo.getModId());
        try {
            this.eventBus.post(e);
        }
        catch (Throwable exception) {
            logger.error(Logging.LOADING, "Caught exception during event {} dispatch for modid {}", (Object)e, (Object)this.modInfo.getModId(), (Object)exception);
            throw new ModLoadingException(this.modInfo, event.fromStage(), "fml.modloading.errorduringevent", exception, new Object[0]);
        }
    }

    private void checkError(LifecycleEventProvider.LifecycleEvent event) {
        if (this.modLoadingStage == ModLoadingStage.ERROR) {
            logger.error(Logging.LOADING, "An error occurred during the {} event by {}", (Object)event.fromStage(), (Object)this.modInfo.getModId());
        }
    }

    public boolean matches(Object mod) {
        return this.getInstance().equals(mod);
    }

    public Object getMod() {
        return this.getInstance();
    }

    public Class<?> getClazz() {
        if (this.clazz == null) {
            try {
                this.clazz = Class.forName(this.className, true, this.modClassLoader);
            }
            catch (Throwable e) {
                logger.error(Logging.LOADING, "Failed to load class {}", (Object)this.className, (Object)e);
                throw new RuntimeException("Failed to load class " + this.className, e);
            }
        }
        return this.clazz;
    }

    public IEventBus getEventBus() {
        return this.eventBus;
    }

    public static void injectEvents(ModContainer modContainer, ModFileScanData scanData, ClassLoader loader) {
        if (scanData == null) {
            return;
        }
        logger.debug(Logging.LOADING, "Attempting to inject @EventBusSubscriber classes into the eventbus for {}", (Object)modContainer.getModId());
        List<ModFileScanData.AnnotationData> ebsTargets = scanData.getAnnotations().stream().filter(annotationData -> AUTO_SUBSCRIBER.equals((Object)annotationData.getAnnotationType())).collect(Collectors.toList());
        ebsTargets.forEach(ad -> {
            List<ModAnnotation.EnumHolder> sidesValue = ad.getAnnotationData().getOrDefault("value", Arrays.asList(new ModAnnotation.EnumHolder(null, "CLIENT"), new ModAnnotation.EnumHolder(null, "DEDICATED_SERVER")));
            EnumSet sides = sidesValue.stream().map(eh -> Dist.valueOf((String)eh.getValue())).collect(Collectors.toCollection(() -> EnumSet.noneOf(Dist.class)));
            String modId = ad.getAnnotationData().getOrDefault("modid", modContainer.getModId());
            ModAnnotation.EnumHolder busTargetHolder = ad.getAnnotationData().getOrDefault("bus", new ModAnnotation.EnumHolder(null, "FORGE"));
            Mod.EventBusSubscriber.Bus busTarget = Mod.EventBusSubscriber.Bus.valueOf((String)busTargetHolder.getValue());
            if (Objects.equals(modContainer.getModId(), modId) && sides.contains(FMLEnvironment.dist)) {
                try {
                    logger.debug(Logging.LOADING, "Auto-subscribing {} to {}", (Object)ad.getClassType().getClassName(), (Object)busTarget);
                    Class<?> clazz = Class.forName(ad.getClassType().getClassName(), true, loader);
                    if (busTarget == Mod.EventBusSubscriber.Bus.MOD) {
                        ((BoxlinContainer)modContainer).getEventBus().register(clazz);
                    } else {
                        ((IEventBus)busTarget.bus().get()).register(clazz);
                    }
                }
                catch (ClassNotFoundException e) {
                    logger.fatal(Logging.LOADING, "Failed to load mod class {} for @EventBusSubscriber annotation", (Object)ad.getClassType(), (Object)e);
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

