/*
 * Decompiled with CFR 0.152.
 */
package io.onetapbeyond.renjin.r.executor.tasks;

import io.onetapbeyond.renjin.r.executor.RenjinResult;
import io.onetapbeyond.renjin.r.executor.RenjinTask;
import io.onetapbeyond.renjin.r.executor.manager.RenjinManager;
import io.onetapbeyond.renjin.r.executor.results.RenjinResultImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.renjin.eval.Context;
import org.renjin.primitives.io.serialization.RDataReader;
import org.renjin.primitives.io.serialization.RDataWriter;
import org.renjin.sexp.SEXP;

public class RenjinTaskImpl
implements RenjinTask {
    private static final long serialVersionUID = -2524222643305532748L;
    private final String code;
    private final Map<String, Object> sexpInputs;
    private final Map<String, Object> primInputs;
    private boolean disableTaskSerialization;
    private boolean disableResultSerialization;
    private transient ScriptEngine suppliedEngine;
    private transient boolean autoClearSuppliedEngine;
    private transient ScriptEngine liveEngine;
    private static final Context TLC = Context.newTopLevelContext();
    private final transient String RENJIN_CLEAR = "rm(list = ls())";

    public RenjinTaskImpl(String code, Map<String, Object> sexpInputs, Map<String, Object> primInputs, boolean disableTaskSerialization, boolean disableResultSerialization, ScriptEngine suppliedEngine, boolean autoClearSuppliedEngine) {
        this.code = code;
        this.sexpInputs = sexpInputs;
        this.primInputs = primInputs;
        this.disableTaskSerialization = disableTaskSerialization;
        this.disableResultSerialization = disableResultSerialization;
        this.suppliedEngine = suppliedEngine;
        this.autoClearSuppliedEngine = autoClearSuppliedEngine;
        this.liveEngine = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RenjinResult execute() {
        RenjinResultImpl result = null;
        try {
            long taskStart = System.currentTimeMillis();
            ScriptEngine scriptEngine = this.liveEngine = this.suppliedEngine != null ? this.suppliedEngine : RenjinManager.POOL.getEngine();
            if (this.disableTaskSerialization) {
                for (Map.Entry<String, Object> pair : this.sexpInputs.entrySet()) {
                    this.liveEngine.put(pair.getKey(), pair.getValue());
                }
            } else {
                for (Map.Entry<String, Object> pair : this.sexpInputs.entrySet()) {
                    this.liveEngine.put(pair.getKey(), RenjinTaskImpl.deserializeSEXP((byte[])pair.getValue()));
                }
            }
            for (Map.Entry<String, Object> pair : this.primInputs.entrySet()) {
                this.liveEngine.put(pair.getKey(), pair.getValue());
            }
            long execstart = System.currentTimeMillis();
            SEXP output = (SEXP)this.liveEngine.eval(this.code);
            long execend = System.currentTimeMillis();
            result = this.disableResultSerialization ? new RenjinResultImpl(this.buildResultMap(output, System.currentTimeMillis() - taskStart)) : new RenjinResultImpl(this.buildResultMap(RenjinTaskImpl.serializeSEXP(output), System.currentTimeMillis() - taskStart));
        }
        catch (Throwable cause) {
            result = new RenjinResultImpl(this.buildResultMap(cause.getMessage(), cause));
        }
        finally {
            try {
                if (this.engineFromPool() || this.engineSuppliedAndStateless()) {
                    this.liveEngine.getBindings(100).clear();
                    this.liveEngine.eval("rm(list = ls())");
                }
            }
            catch (ScriptException taskStart) {}
            if (this.engineFromPool()) {
                RenjinManager.POOL.releaseEngine(this.liveEngine);
            }
        }
        return result;
    }

    private boolean engineFromPool() {
        return this.liveEngine != this.suppliedEngine;
    }

    private boolean engineSuppliedAndStateless() {
        return this.autoClearSuppliedEngine && !this.engineFromPool();
    }

    private Map<String, Object> buildResultMap(Object output, long timeTaken) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", true);
        resultMap.put("timeTaken", timeTaken);
        resultMap.put("output", output);
        resultMap.put("outputSerialized", !this.disableResultSerialization);
        resultMap.putAll(this.buildInputMap());
        resultMap.put("error", null);
        resultMap.put("cause", null);
        return resultMap;
    }

    private Map<String, Object> buildResultMap(String error, Throwable cause) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", false);
        resultMap.put("timeTaken", 0L);
        resultMap.put("output", null);
        resultMap.put("outputSerialized", !this.disableResultSerialization);
        resultMap.putAll(this.buildInputMap());
        resultMap.put("error", error);
        resultMap.put("cause", cause);
        return resultMap;
    }

    private Map<String, Object> buildInputMap() {
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        inputMap.put("sexpInputs", this.sexpInputs);
        inputMap.put("primInputs", this.primInputs);
        inputMap.put("inputSerialized", !this.disableTaskSerialization);
        return inputMap;
    }

    public static SEXP deserializeSEXP(byte[] data) {
        SEXP deserializedSEXP = null;
        try {
            long start = System.currentTimeMillis();
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            RDataReader reader = new RDataReader(TLC, (InputStream)bais);
            deserializedSEXP = reader.readFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deserializedSEXP;
    }

    public static byte[] serializeSEXP(SEXP data) {
        byte[] serializedSEXP = null;
        try {
            long start = System.currentTimeMillis();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            RDataWriter writer = new RDataWriter(TLC, (OutputStream)baos);
            writer.save(data);
            serializedSEXP = baos.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serializedSEXP;
    }
}

