/*
 * Decompiled with CFR 0.152.
 */
package io.onetapbeyond.renjin.r.executor.results;

import io.onetapbeyond.renjin.r.executor.RenjinResult;
import io.onetapbeyond.renjin.r.executor.tasks.RenjinTaskImpl;
import java.util.HashMap;
import java.util.Map;
import org.renjin.sexp.SEXP;

public class RenjinResultImpl
implements RenjinResult {
    private static final long serialVersionUID = 3871346233619381871L;
    private Map<String, Object> resultMap;

    public RenjinResultImpl(Map<String, Object> resultMap) {
        this.resultMap = resultMap;
    }

    @Override
    public boolean success() {
        return (Boolean)this.resultMap.get("success");
    }

    @Override
    public String error() {
        return (String)this.resultMap.get("error");
    }

    @Override
    public Throwable cause() {
        return (Throwable)this.resultMap.get("cause");
    }

    @Override
    public Map<String, Object> input() {
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        boolean inputSerialized = (Boolean)this.resultMap.get("inputSerialized");
        Map sexpInputs = (Map)this.resultMap.get("sexpInputs");
        Map primInputs = (Map)this.resultMap.get("primInputs");
        if (sexpInputs != null) {
            if (inputSerialized) {
                for (Map.Entry pair : sexpInputs.entrySet()) {
                    inputMap.put((String)pair.getKey(), RenjinTaskImpl.deserializeSEXP((byte[])pair.getValue()));
                }
            } else {
                inputMap.putAll(sexpInputs);
            }
        }
        if (primInputs != null) {
            inputMap.putAll(primInputs);
        }
        return inputMap;
    }

    @Override
    public SEXP output() {
        boolean outputSerialized = (Boolean)this.resultMap.get("outputSerialized");
        Object output = this.resultMap.get("output");
        if (outputSerialized && output != null) {
            output = RenjinTaskImpl.deserializeSEXP((byte[])output);
        }
        return (SEXP)output;
    }

    @Override
    public long timeTaken() {
        return (Long)this.resultMap.get("timeTaken");
    }

    public String toString() {
        boolean success = (Boolean)this.resultMap.get("success");
        if (success) {
            return "RenjinResult: [ success ]";
        }
        String error = (String)this.resultMap.get("error");
        return "RenjinResult: [ failed ], error=" + error;
    }
}

