/*
 * Decompiled with CFR 0.152.
 */
package io.onetapbeyond.renjin.r.executor.tasks;

import io.onetapbeyond.renjin.r.executor.RenjinResult;
import io.onetapbeyond.renjin.r.executor.RenjinTask;
import io.onetapbeyond.renjin.r.executor.manager.RenjinManager;
import io.onetapbeyond.renjin.r.executor.results.RenjinResultImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.renjin.eval.Context;
import org.renjin.primitives.io.serialization.RDataReader;
import org.renjin.primitives.io.serialization.RDataWriter;
import org.renjin.sexp.SEXP;

public class RenjinTaskImpl
implements RenjinTask {
    private static final long serialVersionUID = -2524222643305532748L;
    private final String code;
    private final Map<String, Object> sexpInputs;
    private final Map<String, Object> primInputs;
    private boolean serializableTasks;
    private boolean serializableResults;
    private transient ScriptEngine suppliedEngine;
    private transient boolean autoClearSuppliedEngine;
    private transient ScriptEngine liveEngine;
    private static final Context TLC = Context.newTopLevelContext();
    private final transient String RENJIN_CLEAR = "rm(list = ls())";

    public RenjinTaskImpl(String code, Map<String, Object> sexpInputs, Map<String, Object> primInputs, boolean serializableTasks, boolean serializableResults, ScriptEngine suppliedEngine, boolean autoClearSuppliedEngine) {
        this.code = code;
        this.sexpInputs = sexpInputs;
        this.primInputs = primInputs;
        this.serializableTasks = serializableTasks;
        this.serializableResults = serializableResults;
        this.suppliedEngine = suppliedEngine;
        this.autoClearSuppliedEngine = autoClearSuppliedEngine;
        this.liveEngine = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RenjinResult execute() {
        RenjinResultImpl result = null;
        try {
            long taskStart = System.currentTimeMillis();
            ScriptEngine scriptEngine = this.liveEngine = this.suppliedEngine != null ? this.suppliedEngine : RenjinManager.POOL.getEngine();
            if (this.serializableTasks) {
                for (Map.Entry<String, Object> pair : this.sexpInputs.entrySet()) {
                    this.liveEngine.put(pair.getKey(), RenjinTaskImpl.deserializeInput(pair.getKey(), (byte[])pair.getValue()));
                }
            } else {
                for (Map.Entry<String, Object> pair : this.sexpInputs.entrySet()) {
                    this.liveEngine.put(pair.getKey(), pair.getValue());
                }
            }
            for (Map.Entry<String, Object> pair : this.primInputs.entrySet()) {
                this.liveEngine.put(pair.getKey(), pair.getValue());
            }
            long execstart = System.currentTimeMillis();
            SEXP output = (SEXP)this.liveEngine.eval(this.code);
            long execend = System.currentTimeMillis();
            result = this.serializableResults ? new RenjinResultImpl(RenjinTaskImpl.serializeInput("result", output), System.currentTimeMillis() - taskStart) : new RenjinResultImpl(output, System.currentTimeMillis() - taskStart);
        }
        catch (Throwable cause) {
            result = new RenjinResultImpl(cause.getMessage(), cause);
        }
        finally {
            try {
                if (this.engineFromPool() || this.engineSuppliedAndStateless()) {
                    this.liveEngine.getBindings(100).clear();
                    this.liveEngine.eval("rm(list = ls())");
                }
            }
            catch (ScriptException taskStart) {}
            if (this.engineFromPool()) {
                RenjinManager.POOL.releaseEngine(this.liveEngine);
            }
        }
        return result;
    }

    private boolean engineFromPool() {
        return this.liveEngine != this.suppliedEngine;
    }

    private boolean engineSuppliedAndStateless() {
        return this.autoClearSuppliedEngine && !this.engineFromPool();
    }

    public static SEXP deserializeInput(String name, byte[] inputData) {
        SEXP deserializedInput = null;
        try {
            long start = System.currentTimeMillis();
            ByteArrayInputStream bais = new ByteArrayInputStream(inputData);
            RDataReader reader = new RDataReader(TLC, (InputStream)bais);
            deserializedInput = reader.readFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deserializedInput;
    }

    public static byte[] serializeInput(String name, SEXP inputData) {
        byte[] serializedInput = null;
        try {
            long start = System.currentTimeMillis();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            RDataWriter writer = new RDataWriter(TLC, (OutputStream)baos);
            writer.save(inputData);
            serializedInput = baos.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serializedInput;
    }
}

