/*
 * Decompiled with CFR 0.152.
 */
package io.onetapbeyond.renjin.r.executor.manager;

import io.onetapbeyond.renjin.r.executor.Renjin;
import java.util.concurrent.LinkedBlockingQueue;
import javax.script.ScriptEngine;

public enum RenjinManager {
    POOL;

    private LinkedBlockingQueue<ScriptEngine> enginePool;
    private long maxEnginesInPool = Long.getLong("renjin-r-executor-pool-size-limit", 12L);

    public ScriptEngine getEngine() {
        ScriptEngine engine = this.enginePool.poll();
        if (engine == null) {
            try {
                long bstart = System.currentTimeMillis();
                engine = Renjin.scriptEngine();
                long bend = System.currentTimeMillis();
                long l = bend - bstart;
            }
            catch (Exception eex) {
                engine = null;
            }
        }
        return engine;
    }

    public void releaseEngine(ScriptEngine engine) {
        try {
            if ((long)this.enginePool.size() < this.maxEnginesInPool) {
                this.enginePool.add(engine);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private RenjinManager() {
        this.enginePool = new LinkedBlockingQueue();
        try {
            ScriptEngine seedEngine = Renjin.scriptEngine();
            this.enginePool.put(seedEngine);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

