/*
 * Decompiled with CFR 0.152.
 */
package io.onetapbeyond.renjin.r.executor;

import io.onetapbeyond.renjin.r.executor.RenjinException;
import io.onetapbeyond.renjin.r.executor.RenjinTask;
import io.onetapbeyond.renjin.r.executor.tasks.RenjinTaskImpl;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.renjin.sexp.SEXP;

public class Renjin {
    private String code;
    private Map<String, Object> sexpInputs = new HashMap<String, Object>();
    private Map<String, Object> primInputs = new HashMap<String, Object>();
    private boolean serializableTasks;
    private boolean serializableResults;
    private boolean cleanBuilder = true;
    private static final String RENJIN_ENGINE = "Renjin";
    private static final ScriptEngineManager scriptEngineManager = new ScriptEngineManager();

    private Renjin() {
    }

    private Renjin(boolean serializableTasks, boolean serializableResults) {
        this.serializableTasks = serializableTasks;
        this.serializableResults = serializableResults;
    }

    public static Renjin R() {
        return new Renjin();
    }

    public static Renjin R(boolean serializableTasks, boolean serializableResults) {
        return new Renjin(serializableTasks, serializableResults);
    }

    public Renjin code(String code) throws RenjinException {
        if (code == null) {
            throw new RenjinException();
        }
        this.code = code;
        return this;
    }

    public Renjin code(Reader code) throws RenjinException {
        StringBuilder codeBuf = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(code);
            String codeLine = null;
            while ((codeLine = br.readLine()) != null) {
                codeBuf.append(codeLine);
            }
        }
        catch (Exception rex) {
            throw new RenjinException(rex);
        }
        this.code = codeBuf.toString();
        return this;
    }

    public Renjin input(String name, Object value) throws RenjinException {
        try {
            if (value instanceof SEXP) {
                if (this.serializableTasks) {
                    this.sexpInputs.put(name, RenjinTaskImpl.serializeInput(name, (SEXP)value));
                } else {
                    this.sexpInputs.put(name, value);
                }
            } else {
                this.primInputs.put(name, value);
            }
        }
        catch (Exception iex) {
            throw new RenjinException(iex);
        }
        return this;
    }

    public Renjin input(Map<String, Object> nameValues) throws RenjinException {
        try {
            for (Map.Entry<String, Object> pair : nameValues.entrySet()) {
                this.input(pair.getKey(), pair.getValue());
            }
        }
        catch (Exception iex) {
            throw new RenjinException(iex);
        }
        return this;
    }

    public RenjinTask build() throws RenjinException {
        return this.build(null);
    }

    public RenjinTask build(ScriptEngine suppliedEngine) throws RenjinException {
        return this.build(suppliedEngine, false);
    }

    public RenjinTask build(ScriptEngine suppliedEngine, boolean autoClearSuppliedEngine) throws RenjinException {
        if (!this.cleanBuilder) {
            throw new RenjinException("Renjin builder deactivated.");
        }
        this.cleanBuilder = false;
        if (this.code == null) {
            throw new RenjinException("R code on task not specified.");
        }
        return new RenjinTaskImpl(this.code, this.sexpInputs, this.primInputs, this.serializableTasks, this.serializableResults, suppliedEngine, autoClearSuppliedEngine);
    }

    public static ScriptEngine scriptEngine() {
        return scriptEngineManager.getEngineByName(RENJIN_ENGINE);
    }
}

